﻿namespace isRoc.Core
{
    /// <summary>
    /// 缓存表对象
    /// </summary>
    public class SiteCache
    {
        /// <summary>
        /// 配置表
        /// </summary>
        public string Setting = "Setting";

        /// <summary>
        /// 导航
        /// </summary>
        public string Navigation = "Navigation";

        /// <summary>
        /// 分类
        /// </summary>
        public string Column = "Column";

        /// <summary>
        /// 随机文章
        /// </summary>
        public string RandomPost = "RandomPost";

        /// <summary>
        /// 热门文章
        /// </summary>
        public string HotPost = "HotPost";

        /// <summary>
        /// 推荐文章
        /// </summary>
        public string FinePost = "FinePost";

        /// <summary>
        /// 最新评论
        /// </summary>
        public string NewComment = "NewComment";

        /// <summary>
        /// 热门标签
        /// </summary>
        public string HotTag = "HotTag";

        /// <summary>
        /// 友情链接
        /// </summary>
        public string Fellow = "Fellow";

        /// <summary>
        /// 单页
        /// </summary>
        public string Page = "Page";

        /// <summary>
        /// 自定义标签
        /// </summary>
        public string MyTag = "MyTag";

        /// <summary>
        /// 文章列表
        /// </summary>
        public string PostsListFormat = "Posts-{0}-{1}-{2}-{3}";

        /// <summary>
        /// 评论列表，{0}为内容编号，{1}为页数
        /// </summary>
        public string CommentsListFormat = "Comments-{0}-{1}";

        /// <summary>
        /// 内容页，{0}为编号
        /// </summary>
        public string PostFormat = "Post-{0}";

        /// <summary>
        /// 栏目数据，{0}为编号
        /// </summary>
        public string ColumnFormat = "Column-{0}";
    }
}
