﻿using System.Configuration;
using System.Web;

namespace isRoc.Core
{
    /// <summary>
    /// 全局配置
    /// </summary>
    public sealed class SiteCfg
    {
        /// <summary>
        /// 获取系统名称
        /// </summary>
        public static string System
        {
            get { return "isRoc"; }
        }

        /// <summary>
        /// 获取系统版本
        /// </summary>
        public static string Version
        {
            get { return "1.3.13 SP1"; }
        }

        /// <summary>
        /// 官方网站
        /// </summary>
        public static string WebSite
        {
            get { return "http://www.isroc.com/"; }
        }

        /// <summary>
        /// 更新源
        /// </summary>
        public static string UpdateHost
        {
            get { return "http://update.isroc.com/"; }
        }

        /// <summary>
        /// 获取系统版本完整纯字符串
        /// </summary>
        public static string SystemVersionFull
        {
            get { return string.Format("{0} v{1}", System, Version); }
        }

        /// <summary>
        /// 获取提供版权代码
        /// </summary>
        public static string Powered
        {
            get { return string.Format("Powered by <a href=\"{2}\" rel=\"external\"><strong>{0}</strong></a> <em>v{1}</em>", System, Version, WebSite); }
        }

        /// <summary>
        /// 获取安装根目录相对路径
        /// </summary>
        public static string Path
        {
            get { return ConfigurationManager.AppSettings["Path"].ToString(); }
        }

        /// <summary>
        /// 获取安装根目录绝对路径
        /// </summary>
        public static string Router
        {
            get { return HttpContext.Current.Server.MapPath(Path); }
        }

        /// <summary>
        /// 数据库相对路径
        /// </summary>
        public static string DBPath
        {
            get { return ConfigurationManager.AppSettings["DBPath"].ToString(); }
        }

        /// <summary>
        /// 获取数据库相对路径
        /// </summary>
        public static string Conn
        {
            get
            {
                string path = HttpContext.Current.Server.MapPath(DBPath);
                return ConfigurationManager.AppSettings["DBConn"].Replace("{Path}", path);
            }
        }

        /// <summary>
        /// 获取会话标记
        /// </summary>
        public static string Token
        {
            get { return ConfigurationManager.AppSettings["Token"].ToString(); }
        }

        /// <summary>
        /// 是否显示效率时间
        /// </summary>
        public static bool Debug
        {
            get { return ConfigurationManager.AppSettings["Debug"].ToUpper() == "ON"; }
        }

        /// <summary>
        /// 截断匹配正则
        /// </summary>
        public static string PageBreakRegular
        {
            get { return @"<div\s+style=""page-break-after:\s*always;?\s*"">((.|\n)+?|^<\/div>)<\/div>"; }
            //get { return @"<div class=""pagebreak"">[^<\/div>]*<\/div>"; }
        }

        /// <summary>
        /// 截断检查符号
        /// </summary>
        public static string PageBreakSymbol
        {
            get { return "[__ISROC_TEMP_PAGEBREAK_CHARS]"; }
        }
    }
}
