﻿using System;
using System.Web;

namespace isRoc.Core
{
    /// <summary>
    /// 系统模块类重写
    /// </summary>
    public class SiteHttpModule : IHttpModule
    {
        private SiteDat _siteDat = new SiteDat();

        /// <summary>
        /// 初始化
        /// </summary>
        /// <param name="objApp">基础类对象</param>
        public void Init(HttpApplication objApp)
        {
            objApp.BeginRequest += new EventHandler(this.Rewrite_BeginRequest);
        }

        /// <summary>
        /// 开始获取重写数据
        /// </summary>
        /// <param name="sender">基础类对象</param>
        /// <param name="e">事件对象</param>
        private void Rewrite_BeginRequest(object sender, EventArgs e)
        {
            HttpApplication application = sender as HttpApplication;
            string url = _siteDat.GetUrl(application.Context.Request.Path);
            if (!string.IsNullOrEmpty(url))
            {
                application.Context.RewritePath(url);
            }
        }

        /// <summary>
        /// 重写注销内存
        /// </summary>
        void IHttpModule.Dispose() { }
    }
}
