﻿using System;
using System.IO;
using System.Text;
using isRoc.Core;
using isRoc.Core.UI;
using isRoc.Data;
using isRoc.Data.Entity;

namespace isRoc.Logic.Admin
{
    /// <summary>
    /// 附件管理类
    /// </summary>
    public class AdminAttach
    {
        private SiteFun _fun = new SiteFun();
        private SiteDat _siteDat = new SiteDat();
        private AdminUI _admUi = new AdminUI();
        private HtmlUI _htmlUi = new HtmlUI();

        /// <summary>
        /// 附件列表
        /// </summary>
        /// <returns>附件列表区域</returns>
        public string List()
        {
            StringBuilder sr = new StringBuilder();
            AttachmentData attData = new AttachmentData();
            if (_fun.IsPost)
            {
                int id = _fun.ToInt(_fun.Post("id"));
                try
                {
                    AttachmentItem delAttInfo = attData.GetAttachment(id);
                    if (File.Exists(Path.Combine(SiteCfg.Router, delAttInfo.Path)))
                    {
                        File.Delete(Path.Combine(SiteCfg.Router, delAttInfo.Path));
                    }
                    attData.DeleteAttachment(id);
                    sr.Append(_admUi.SuccessBox(_siteDat.GetLan("MsgDelFile")));
                }
                catch (Exception err) { sr.Append(_admUi.ErrorBox(err.Message)); }
            }
            sr.Append(_admUi.AdminBoxStart(true));
            sr.Append(_htmlUi.TableStart());
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("FileName")));
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("FileType")));
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("Size")));
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("DateTime")));
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("Operate")));
            sr.Append(_htmlUi.TrFinal());
            //下面三行是分页设置
            int page = _fun.ToInt(_fun.Query("page"));
            if (page < 1) { page = 1; }
            int pageSize = 20;
            DataList<AttachmentItem> list = attData.SelectAttachment(page, pageSize);
            int i = 1;
            foreach (AttachmentItem vItem in list)
            {
                i++;
                FileInfo fileInfo = new FileInfo(Path.Combine(SiteCfg.Router, vItem.Path));
                sr.Append(_htmlUi.FormStart());
                sr.Append(_htmlUi.TrStart(i % 2 == 0 ? " cRow" : null));
                if (fileInfo.Exists)
                {
                    sr.Append(_htmlUi.CreateTd(_htmlUi.Image("Common/Images/FileType/" + (fileInfo.Length > 1 ? fileInfo.Extension.Substring(1) + ".png" : string.Empty), _fun.HtmlEncode(vItem.Type)) + _htmlUi.Link(_fun.HtmlEncode(vItem.Name), SiteCfg.Path + vItem.Path, vItem.Path, true)));
                }
                else { sr.Append(_htmlUi.CreateTd("--")); }
                sr.Append(_htmlUi.CreateTd(_fun.HtmlEncode(vItem.Type)));
                sr.Append(_htmlUi.CreateTd(_fun.FormatLength(vItem.Size)));
                sr.Append(_htmlUi.CreateTd(vItem.Publish));
                sr.Append(_htmlUi.CreateTd(_htmlUi.HiddenInput("id", vItem.ID) + _htmlUi.SubmitButton(_siteDat.GetLan("BtnDel"))));
                sr.Append(_htmlUi.TrFinal());
                sr.Append(_htmlUi.FormFinal());
            }
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTd(new SitePages().Make(list.Number, page, pageSize, "?act=attach&amp;mode=list&amp;page={0}"), 5, null));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TableFinal());
            sr.Append(_admUi.AdminBoxFinal());
            return sr.ToString();
        }
    }
}
