﻿using System.Collections;
using System.Text;
using isRoc.Core;
using isRoc.Core.UI;

namespace isRoc.Logic.Admin
{
    /// <summary>
    /// 缓存管理类
    /// </summary>
    public class AdminCache
    {
        private SiteFun _fun = new SiteFun();
        private SiteDat _siteDat = new SiteDat();
        private AdminUI _admUi = new AdminUI();
        private HtmlUI _htmlUi = new HtmlUI();

        /// <summary>
        /// 取得系统缓存列表窗体
        /// </summary>
        /// <returns>返回系统缓存列表代码</returns>
        public string List()
        {
            StringBuilder sr = new StringBuilder();
            if (_fun.IsPost)
            {
                bool allRemove = _fun.ToInt(_fun.Post("removeAll")) == 0 ? false : true;
                if (allRemove) { _siteDat.ClearDat(); }
                else
                {
                    string key = _fun.Post("key");
                    _siteDat.RemoveDat(key);
                }
                sr.Append(_admUi.SuccessBox(_siteDat.GetLan("MsgClearCacheSucc")));
            }
            //全部清除
            sr.Append(_admUi.AdminBoxStart(true));
            sr.Append(_htmlUi.FormStart());
            sr.Append(_htmlUi.TableStart("onCenter"));
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("ClearCache")));
            sr.Append(_htmlUi.CreateTd(_htmlUi.HiddenInput("removeAll", 1) + _htmlUi.SubmitButton(_siteDat.GetLan("BtnClear"))));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TableFinal());
            sr.Append(_htmlUi.FormFinal());
            sr.Append(_admUi.AdminBoxFinal());
            //缓存列表
            sr.Append(_admUi.AdminBoxStart(true));
            sr.Append(_htmlUi.TableStart());
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("CacheKey")));
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("CacheType")));
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("Operate")));
            sr.Append(_htmlUi.TrFinal());
            int i = 1;
            IDictionaryEnumerator cacheEnum = _siteDat.GetCacheEnumerator();
            while (cacheEnum.MoveNext())
            {
                i++;
                sr.Append(_htmlUi.FormStart());
                sr.Append(_htmlUi.TrStart(i % 2 == 0 ? " cRow" : null));
                sr.Append(_htmlUi.CreateTd(cacheEnum.Key));
                sr.Append(_htmlUi.CreateTd(_siteDat.GetDat(cacheEnum.Key.ToString()).GetType().Name));
                sr.Append(_htmlUi.CreateTd(_htmlUi.HiddenInput("key", cacheEnum.Key) + _htmlUi.SubmitButton(_siteDat.GetLan("BtnDel"))));
                sr.Append(_htmlUi.TrFinal());
                sr.Append(_htmlUi.FormFinal());
            }
            sr.Append(_htmlUi.TableFinal());
            sr.Append(_admUi.AdminBoxFinal());
            return sr.ToString();
        }
    }
}
