﻿using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using isRoc.Core;
using isRoc.Core.UI;
using isRoc.Data;
using isRoc.Data.Entity;

namespace isRoc.Logic.Admin
{
    /// <summary>
    /// 分类管理类
    /// </summary>
    public class AdminColumn
    {
        private SiteFun _fun = new SiteFun();
        private SiteDat _siteDat = new SiteDat();
        private AdminUI _admUi = new AdminUI();
        private HtmlUI _htmlUi = new HtmlUI();

        /// <summary>
        /// 清除缓存
        /// </summary>
        private void ClearCache()
        {
            SiteCache cache = new SiteCache();
            _siteDat.RemoveDat(cache.Navigation);
            _siteDat.RemoveDat(cache.Column);
        }

        /// <summary>
        /// 提交分类数据
        /// </summary>
        /// <returns>返回发布分类代码</returns>
        public string Post()
        {
            StringBuilder sr = new StringBuilder();
            int id = _fun.ToInt(_fun.Query("id"));
            string theme = new SettingData().GetTheme;
            ColumnData cateData = new ColumnData();
            //取得默认值
            ColumnItem old = cateData.GetColumn(id);
            if (old.ID == 0)
            {
                //默认显示
                old.Show = true;
            }
            if (_fun.IsPost)
            {
                ColumnItem postVal = new ColumnItem();
                postVal.ID = id;
                postVal.Name = _fun.Post("name");
                postVal.Local = _fun.Post("local");
                postVal.Target = _fun.Post("target");
                postVal.ListTemplate = _fun.Post("listTpl");
                postVal.ViewTemplate = _fun.Post("viewTpl");
                postVal.PageSize = _fun.ToInt(_fun.Post("pageSize"));
                postVal.Jump = _fun.ToInt(_fun.Post("jump")) == 0 ? false : true;
                postVal.JumpUrl = _fun.Post("jumpUrl");
                postVal.Intro = _fun.Post("intro");
                postVal.Sorting = _fun.ToInt(_fun.Post("sorting"));
                postVal.Nav = _fun.ToInt(_fun.Post("nav")) == 0 ? false : true;
                postVal.Show = _fun.ToInt(_fun.Post("show")) == 0 ? false : true;
                if (string.IsNullOrEmpty(postVal.Name)) { sr.Append(_admUi.ErrorBox(_siteDat.GetLan("MsgNoName"))); }
                else
                {
                    if (!string.IsNullOrEmpty(postVal.Local)) { postVal.Local = postVal.Local.Replace(" ", "-"); }
                    if (!string.IsNullOrEmpty(postVal.Local) && (!_fun.IsLocal(postVal.Local) || cateData.ExistsLocal(postVal.Local, postVal.ID))) { sr.Append(_admUi.ErrorBox(_siteDat.GetLan("MsgNoLocalOrExists"))); }
                    else
                    {
                        if (postVal.ID == 0)
                        {
                            cateData.InsertColumn(postVal);
                            sr.Append(_admUi.SuccessBox(_siteDat.GetLan("MsgInsertDat"), "?act=column&mode=list"));
                        }
                        else
                        {
                            cateData.UpdateColumn(postVal);
                            sr.Append(_admUi.SuccessBox(_siteDat.GetLan("MsgUpdateDat"), "?act=column&mode=list"));
                        }
                    }
                }
                ClearCache();
                old = postVal;
            }
            sr.Append(_admUi.AdminBoxStart(true));
            sr.Append(_htmlUi.FormStart());
            sr.Append(_htmlUi.TableStart("onCenter"));
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("Name")) + _htmlUi.CreateTd(_htmlUi.Input("name", 20, null, _fun.HtmlEncode(old.Name))));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TrStart());
            if (Regex.IsMatch(old.Local, @"^\d+$")) { old.Local = string.Empty; }
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("Local")) + _htmlUi.CreateTd(string.Format(SitePath.CategoryLinkFormat, null, _htmlUi.Input("local", 15, null, _fun.HtmlEncode(old.Local)))));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh() + _htmlUi.CreateTd(_htmlUi.CheckBoxInput(_siteDat.GetLan("Jump"), "jump", 1, old.Jump) + _htmlUi.Input("jumpUrl", 50, null, _fun.HtmlEncode(old.JumpUrl))));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("Intro")) + _htmlUi.CreateTd(_htmlUi.Input("intro", 50, null, _fun.HtmlEncode(old.Intro))));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("Sorting")) + _htmlUi.CreateTd(_htmlUi.Input("sorting", 5, null, old.Sorting)));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("Target")) + _htmlUi.CreateTd(_htmlUi.Input("target", 10, null, _fun.HtmlEncode(old.Target))));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("ListTpl")) + _htmlUi.CreateTd(string.Format(SitePath.ThemePathFormat, theme, _htmlUi.Input("listTpl", 15, null, _fun.HtmlEncode(old.ListTemplate)))));
            sr.Append(_htmlUi.TrFinal());
            if (!string.IsNullOrEmpty(old.ListTemplate) && !File.Exists(Path.Combine(SiteCfg.Router, string.Format(SitePath.ThemePathFormat, theme, old.ListTemplate))))
            {
                sr.Append(_htmlUi.TrStart());
                sr.Append(_htmlUi.CreateTh() + _htmlUi.CreateTd(string.Format(_siteDat.GetLan("MsgFileNotExistsFormat"), old.ListTemplate)));
                sr.Append(_htmlUi.TrFinal());
            }
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("ViewTpl")) + _htmlUi.CreateTd(string.Format(SitePath.ThemePathFormat, theme, _htmlUi.Input("viewTpl", 15, null, _fun.HtmlEncode(old.ViewTemplate)))));
            sr.Append(_htmlUi.TrFinal());
            if (!string.IsNullOrEmpty(old.ViewTemplate) && !File.Exists(Path.Combine(SiteCfg.Router, string.Format(SitePath.ThemePathFormat, theme, old.ViewTemplate))))
            {
                sr.Append(_htmlUi.TrStart());
                sr.Append(_htmlUi.CreateTh() + _htmlUi.CreateTd(string.Format(_siteDat.GetLan("MsgFileNotExistsFormat"), old.ViewTemplate)));
                sr.Append(_htmlUi.TrFinal());
            }
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("PageSize")) + _htmlUi.CreateTd(_htmlUi.Input("pageSize", 5, null, old.PageSize)));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("Virtue")) + _htmlUi.CreateTd(_htmlUi.CheckBoxInput(_siteDat.GetLan("Nav"), "nav", 1, old.Nav) + _htmlUi.CheckBoxInput(_siteDat.GetLan("Show"), "show", 1, old.Show)));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh() + _htmlUi.CreateTd(_htmlUi.SubmitButton() + _htmlUi.ResetButton()));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TableFinal());
            sr.Append(_htmlUi.FormFinal());
            sr.Append(_admUi.AdminBoxFinal());
            return sr.ToString();
        }

        /// <summary>
        /// 系统文章分类操作
        /// </summary>
        /// <returns>分类列表及操作表单</returns>
        public string List()
        {
            StringBuilder sr = new StringBuilder();
            DataList<ColumnItem> list = new ColumnData().SelectColumn(-1, -1, true);
            if (list.Count > 0)
            {
                ColumnData cData = new ColumnData();
                if (_fun.IsPost)
                {
                    //取值
                    ColumnItem postVal = new ColumnItem();
                    postVal.ID = _fun.ToInt(_fun.Post("id"));
                    postVal.Name = _fun.Post("name");
                    postVal.Sorting = _fun.ToInt(_fun.Post("sorting"));
                    postVal.Show = _fun.ToInt(_fun.Post("show")) == 0 ? false : true;
                    postVal.Nav = _fun.ToInt(_fun.Post("nav")) == 0 ? false : true;
                    //处理
                    if (string.IsNullOrEmpty(postVal.Name)) { sr.Append(_admUi.ErrorBox(_siteDat.GetLan("MsgNoName"))); }
                    else
                    {
                        if (postVal.ID > 0)
                        {
                            if (_fun.ToInt(_fun.Post("del")) == 0) { cData.UpdateColumnSome(postVal.ID, postVal.Name, postVal.Sorting, postVal.Nav, postVal.Show); sr.Append(_admUi.SuccessBox(_siteDat.GetLan("MsgUpdateDat"))); }
                            else
                            {
                                PostData pData = new PostData();
                                foreach (PostItem tmpPost in pData.SelectPost(postVal.ID, 1, int.MaxValue, null))
                                {
                                    //删除附件
                                    if (!string.IsNullOrEmpty(tmpPost.Attachments))
                                    {
                                        AttachmentData attData = new AttachmentData();
                                        foreach (AttachmentItem delAtt in attData.SelectAttachment(tmpPost.Attachments))
                                        {
                                            File.Delete(Path.Combine(SiteCfg.Router, delAtt.Path));
                                        }
                                        attData.DeleteAttachment(tmpPost.Attachments);
                                    }
                                }
                                cData.DeleteColumn(postVal.ID);
                                sr.Append(_admUi.SuccessBox(_siteDat.GetLan("MsgDelDat")));
                            }
                        }
                    }
                    ClearCache();
                }
                sr.Append(_admUi.AdminBoxStart(true));
                sr.Append(_htmlUi.TableStart());
                sr.Append(_htmlUi.TrStart());
                sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("Name")));
                sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("Article")));
                sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("Sorting")));
                sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("Nav")));
                sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("Show")));
                sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("Delete")));
                sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("Operate")));
                sr.Append(_htmlUi.TrFinal());
                int i = 1;
                foreach (ColumnItem vItem in list)
                {
                    i++;
                    sr.Append(_htmlUi.FormStart());
                    sr.Append(_htmlUi.TrStart(i % 2 == 0 ? " cRow" : null));
                    sr.Append(_htmlUi.CreateTd(_htmlUi.HiddenInput("id", vItem.ID) + _htmlUi.Input("name", 10, null, _fun.HtmlEncode(vItem.Name)) + _htmlUi.Link(_siteDat.GetLan("Edit"), string.Format("?act=column&amp;mode=post&amp;id={0}", vItem.ID))));
                    sr.Append(_htmlUi.CreateTd(vItem.PostCount));
                    sr.Append(_htmlUi.CreateTd(_htmlUi.Input("sorting", 5, null, vItem.Sorting)));
                    sr.Append(_htmlUi.CreateTd(_htmlUi.CheckBoxInput("nav", 1, vItem.Nav)));
                    sr.Append(_htmlUi.CreateTd(_htmlUi.CheckBoxInput("show", 1, vItem.Show)));
                    sr.Append(_htmlUi.CreateTd(_htmlUi.CheckBoxInput("del", 1, false)));
                    sr.Append(_htmlUi.CreateTd(_htmlUi.SubmitButton(_siteDat.GetLan("BtnSave"))));
                    sr.Append(_htmlUi.TrFinal());
                    sr.Append(_htmlUi.FormFinal());
                }
                sr.Append(_htmlUi.TableFinal());
                sr.Append(_admUi.AdminBoxFinal());
            }
            else { sr.Append(Post()); }
            return sr.ToString();
        }
    }
}
