﻿using System;
using System.Text;
using isRoc.Core;
using isRoc.Core.UI;
using isRoc.Data;
using isRoc.Data.Entity;

namespace isRoc.Logic.Admin
{
    /// <summary>
    /// 评论管路类
    /// </summary>
    public class AdminComment
    {
        private SiteFun _fun = new SiteFun();
        private SiteDat _siteDat = new SiteDat();
        private AdminUI _admUi = new AdminUI();
        private HtmlUI _htmlUi = new HtmlUI();

        /// <summary>
        /// 清除缓存
        /// </summary>
        private void ClearCache()
        {
            SiteCache cache = new SiteCache();
            _siteDat.RemoveDat(cache.NewComment);
            _siteDat.ClearDat("Comments-");
        }

        /// <summary>
        /// 取得页面列表窗体
        /// </summary>
        /// <returns>返回页面列表代码</returns>
        public string List(int pageSize)
        {
            StringBuilder sr = new StringBuilder();
            CommentData cmtData = new CommentData();
            if (_fun.IsPost)
            {
                int id = _fun.ToInt(_fun.Post("id"));
                bool verify = _fun.ToInt(_fun.Post("verify")) == 0 ? false : true;
                bool del = _fun.ToInt(_fun.Post("del")) == 0 ? false : true;
                if (del)
                {
                    cmtData.DeleteComment(id);
                    sr.Append(_admUi.SuccessBox(_siteDat.GetLan("MsgDelDat")));
                }
                else
                {
                    cmtData.UpdateCommentVerify(id, verify);
                    sr.Append(_admUi.SuccessBox(_siteDat.GetLan("MsgUpdateDat")));
                }
                ClearCache();
            }
            sr.Append(_admUi.AdminBoxStart(true));
            sr.Append(_htmlUi.TableStart());
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("Author")));
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("Content")));
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("Article")));
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("DateTime")));
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("Verify")));
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("Delete")));
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("Operate")));
            sr.Append(_htmlUi.TrFinal());
            //下面三行是分页设置
            int page = _fun.ToInt(_fun.Query("page"));
            if (page < 1) { page = 1; }
            DataList<CommentItem> list = cmtData.SelectComment(0, page, pageSize, true);
            int i = 1;
            foreach (CommentItem vItem in list)
            {
                PostItem postItem = new PostData().GetPost(vItem.PostID);
                i++;
                sr.Append(_htmlUi.FormStart());
                sr.Append(_htmlUi.TrStart(i % 2 == 0 ? " cRow" : null));
                sr.Append(_htmlUi.CreateTd(_fun.HtmlEncode(_fun.StrCut(vItem.Author, 10))));
                sr.Append(_htmlUi.CreateTd(_htmlUi.Link(_fun.HtmlEncode(_fun.StrCut(vItem.Content, 50)), string.Format("?act=comment&amp;mode=post&amp;id={0}", vItem.ID))));
                sr.Append(_htmlUi.CreateTd(_htmlUi.Link(_fun.HtmlEncode(_fun.StrCut(postItem.Title, 30)), string.Format("?act=post&amp;mode=post&amp;m=A&amp;id={0}", postItem.ID))));
                sr.Append(_htmlUi.CreateTd(vItem.Publish));
                sr.Append(_htmlUi.CreateTd(_htmlUi.CheckBoxInput("verify", 1, vItem.Verify)));
                sr.Append(_htmlUi.CreateTd(_htmlUi.CheckBoxInput("del", 1, false)));
                sr.Append(_htmlUi.CreateTd(_htmlUi.HiddenInput("id", vItem.ID) + _htmlUi.SubmitButton(_siteDat.GetLan("BtnSave"))));
                sr.Append(_htmlUi.TrFinal());
                sr.Append(_htmlUi.FormFinal());
            }
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTd(new SitePages().Make(list.Number, page, pageSize, "?act=comment&amp;mode=list&amp;page={0}"), 7, null));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TableFinal());
            sr.Append(_admUi.AdminBoxFinal());
            return sr.ToString();
        }

        /// <summary>
        /// 提交页面窗体
        /// </summary>
        /// <returns>返回发布页面控件代码</returns>
        public string Post()
        {
            StringBuilder sr = new StringBuilder();
            int id = _fun.ToInt(_fun.Query("id"));
            CommentData cmtData = new CommentData();
            CommentItem old = cmtData.GetComment(id);
            PostItem postItem = new PostData().GetPost(old.PostID);
            if (_fun.IsPost)
            {
                bool sendMail = false;
                if (_fun.ToInt(_fun.Post("sendMail")) != 0) { sendMail = true; }
                CommentItem postVal = new CommentItem();
                postVal.ID = id;
                postVal.PostID = postItem.ID;
                postVal.Author = old.Author;
                postVal.Mail = old.Mail;
                postVal.URL = old.URL;
                postVal.Title = old.Title;
                postVal.Content = old.Content;
                postVal.Reply = _fun.Post("reply");
                postVal.Trackback = _fun.ToInt(_fun.Post("isTb")) == 0 ? false : true;
                postVal.Publish = old.Publish;
                postVal.Verify = _fun.ToInt(_fun.Post("verify")) == 0 ? false : true;
                if (string.IsNullOrEmpty(postVal.Author)) { sr.Append(_admUi.ErrorBox(_siteDat.GetLan("MsgNoAuthor"))); }
                else
                {
                    if (string.IsNullOrEmpty(postVal.Mail)) { sr.Append(_admUi.ErrorBox(_siteDat.GetLan("MsgNoMail"))); }
                    else
                    {
                        if (string.IsNullOrEmpty(postVal.Content)) { sr.Append(_admUi.ErrorBox(_siteDat.GetLan("MsgNoContent"))); }
                        else
                        {
                            try
                            {
                                if (sendMail)
                                {
                                    SettingBasicItem basic = new SettingData().GetSetting().Basic;
                                    SiteMail mail = new SiteMail();
                                    mail.To = old.Mail;
                                    mail.Subject = string.Format(_siteDat.GetLan("MailTitle"), basic.Name);
                                    mail.From = basic.MailFrom;
                                    mail.Body = string.Format("<p><b>{0}: </b>{1}</p><p><b>{2}: </b>{3}</p><p><b>{4}: </b>{5}</p>", _siteDat.GetLan("Content"), _fun.ClearHtml(old.Content), _siteDat.GetLan("Reply"), _fun.ClearHtml(postVal.Reply), _siteDat.GetLan("URL"), string.Format(SitePath.ArticleLinkFormat, basic.URL, postItem.Local));
                                    mail.Host = basic.MailHost;
                                    mail.Port = basic.MailPort;
                                    mail.UserName = basic.MailUserID;
                                    mail.Password = basic.MailPassword;
                                    mail.Send();
                                }
                                sr.Append(_admUi.SuccessBox(_siteDat.GetLan("MsgSaveSucc"), "?act=comment&mode=list"));
                            }
                            catch (Exception err) { sr.Append(_admUi.ErrorBox(err.Message)); }
                            old = cmtData.GetComment(cmtData.UpdateComment(postVal));
                        }
                    }
                }
                ClearCache();
            }
            //取得默认值
            sr.Append(_admUi.AdminBoxStart(true));
            sr.Append(_htmlUi.FormStart());
            sr.Append(_htmlUi.TableStart("onCenter"));
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("Author")) + _htmlUi.CreateTd(_fun.HtmlEncode(old.Author)));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("Mail")) + _htmlUi.CreateTd(_fun.HtmlEncode(old.Mail)));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("Website")) + _htmlUi.CreateTd(_htmlUi.Link(_fun.HtmlEncode(old.URL), old.URL, null, true)));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("Article")) + _htmlUi.CreateTd(_fun.HtmlEncode(postItem.Title)));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("Content")) + _htmlUi.CreateTd(_fun.HtmlEncode(old.Content)));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("Reply")) + _htmlUi.CreateTd(_admUi.Editor("reply", _fun.HtmlEncode(old.Reply))));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("DateTime")) + _htmlUi.CreateTd(old.Publish));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("Virtue")) + _htmlUi.CreateTd(_htmlUi.CheckBoxInput(_siteDat.GetLan("Trackback"), "isTb", 1, old.Trackback) + _htmlUi.CheckBoxInput(_siteDat.GetLan("Verify"), "verify", 1, old.Verify) + _htmlUi.CheckBoxInput(_siteDat.GetLan("MailNotice"), "sendMail", 1, false)));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh() + _htmlUi.CreateTd(_htmlUi.SubmitButton() + _htmlUi.ResetButton()));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TableFinal());
            sr.Append(_htmlUi.FormFinal());
            sr.Append(_admUi.AdminBoxFinal());
            return sr.ToString();
        }
    }
}
