﻿using System.IO;
using System.Text;
using isRoc.Core;
using isRoc.Core.UI;
using isRoc.Data;
using isRoc.Data.Entity;

namespace isRoc.Logic.Admin
{
    /// <summary>
    /// 友情链接管路类
    /// </summary>
    public class AdminFellow
    {
        private SiteFun _fun = new SiteFun();
        private SiteDat _siteDat = new SiteDat();
        private AdminUI _admUi = new AdminUI();
        private HtmlUI _htmlUi = new HtmlUI();

        /// <summary>
        /// 清除缓存
        /// </summary>
        private void ClearCache()
        {
            SiteCache cache = new SiteCache();
            _siteDat.RemoveDat(cache.Fellow);
        }

        /// <summary>
        /// 取得链接列表窗体
        /// </summary>
        /// <returns>返回链接列表代码</returns>
        public string List()
        {

            StringBuilder sr = new StringBuilder();
            int selHome = _fun.ToInt(_fun.Query("home"));
            FellowData flwData = new FellowData();
            sr.Append(_admUi.AdminBoxStart(true));
            sr.Append(_htmlUi.TableStart("onCenter"));
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("SelMode")));
            sr.Append(_htmlUi.CreateTd(_htmlUi.Link(_siteDat.GetLan("IdxLink"), "?act=fellow&amp;mode=list&amp;home=1") + ", " + _htmlUi.Link(_siteDat.GetLan("NormalLink"), "?act=fellow&amp;mode=list")));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TableFinal());
            sr.Append(_admUi.AdminBoxFinal());
            if (_fun.IsPost)
            {
                int id = _fun.ToInt(_fun.Post("id"));
                bool del = _fun.ToInt(_fun.Post("del")) == 0 ? false : true;
                if (del)
                {
                    FellowItem delLink = new FellowData().GetFellow(id);
                    if (delLink.ID > 0)
                    {
                        string deleteLogoFile = Path.Combine(SiteCfg.Router, string.Format("Attach/FellowLogo/{0}.gif", delLink.ID));
                        if (File.Exists(deleteLogoFile)) { File.Delete(deleteLogoFile); }
                        flwData.DeleteFellow(id);
                        sr.Append(_admUi.SuccessBox(_siteDat.GetLan("MsgDelDat")));
                    }
                }
                else
                {
                    string name = _fun.Post("name");
                    string url = _fun.Post("url");
                    bool home = _fun.ToInt(_fun.Post("home")) == 0 ? false : true;
                    bool show = _fun.ToInt(_fun.Post("show")) == 0 ? false : true;
                    int sorting = _fun.ToInt(_fun.Post("sorting"));
                    if (string.IsNullOrEmpty(name)) { sr.Append(_admUi.ErrorBox(_siteDat.GetLan("MsgNoName"))); }
                    else
                    {
                        if (string.IsNullOrEmpty(url) || flwData.ExistsFellowUrl(url, id)) { sr.Append(_admUi.ErrorBox(_siteDat.GetLan("MsgNoUrlOrExists"))); }
                        else
                        {
                            flwData.UpdateFellowSome(id, name, url, home, show, sorting);
                            sr.Append(_admUi.SuccessBox(_siteDat.GetLan("MsgUpdateDat")));
                        }
                    }
                }
                ClearCache();
            }
            sr.Append(_admUi.AdminBoxStart(true));
            sr.Append(_htmlUi.TableStart());
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("Name")));
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("URL")));
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("Sorting")));
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("Delete")));
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("IdxLink")));
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("Show")));
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("Operate")));
            sr.Append(_htmlUi.TrFinal());
            //下面三行是分页设置
            int page = _fun.ToInt(_fun.Query("page"));
            if (page < 1) { page = 1; }
            int pageSize = 20;
            DataList<FellowItem> list = flwData.SelectFellow(page, pageSize, selHome == 0 ? false : true, true);
            int i = 1;
            foreach (FellowItem vItem in list)
            {
                i++;
                sr.Append(_htmlUi.FormStart());
                sr.Append(_htmlUi.TrStart(i % 2 == 0 ? " cRow" : null));
                sr.Append(_htmlUi.CreateTd(_htmlUi.Input("name", 15, null, _fun.HtmlEncode(vItem.Name)) + _htmlUi.Link(_siteDat.GetLan("Edit"), string.Format("?act=fellow&amp;mode=post&amp;id={0}", vItem.ID))));
                sr.Append(_htmlUi.CreateTd(_htmlUi.Input("url", 30, null, _fun.HtmlEncode(vItem.URL))));
                sr.Append(_htmlUi.CreateTd(_htmlUi.Input("sorting", 5, null, vItem.Sorting)));
                sr.Append(_htmlUi.CreateTd(_htmlUi.CheckBoxInput("del", 1, false)));
                sr.Append(_htmlUi.CreateTd(_htmlUi.CheckBoxInput("home", 1, vItem.Home)));
                sr.Append(_htmlUi.CreateTd(_htmlUi.CheckBoxInput("show", 1, vItem.Show)));
                sr.Append(_htmlUi.CreateTd(_htmlUi.HiddenInput("id", vItem.ID) + _htmlUi.SubmitButton(_siteDat.GetLan("BtnSave"))));
                sr.Append(_htmlUi.TrFinal());
                sr.Append(_htmlUi.FormFinal());
            }
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTd(new SitePages().Make(list.Number, page, pageSize, "?act=fellow&amp;mode=list&amp;home=" + selHome + "&amp;page={0}"), 7, null));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TableFinal());
            sr.Append(_admUi.AdminBoxFinal());
            return sr.ToString();
        }

        /// <summary>
        /// 提交链接数据
        /// </summary>
        /// <returns>返回发布链接代码</returns>
        public string Post()
        {
            StringBuilder sr = new StringBuilder();
            int id = _fun.ToInt(_fun.Query("id"));
            FellowData flwData = new FellowData();
            //取得默认值
            FellowItem old = flwData.GetFellow(id);
            if (_fun.IsPost)
            {
                FellowItem postVal = new FellowItem();
                postVal.ID = id;
                postVal.Name = _fun.Post("name");
                postVal.URL = _fun.Post("url");
                postVal.Logo = _fun.Post("logo");
                postVal.Explain = _fun.Post("explain");
                postVal.Style = _fun.Post("style");
                postVal.Sorting = _fun.ToInt(_fun.Post("sorting"));
                postVal.Home = _fun.ToInt(_fun.Post("home")) == 0 ? false : true;
                postVal.Show = _fun.ToInt(_fun.Post("show")) == 0 ? false : true;
                if (string.IsNullOrEmpty(postVal.URL) || flwData.ExistsFellowUrl(postVal.URL, postVal.ID)) { sr.Append(_admUi.ErrorBox(_siteDat.GetLan("MsgNoUrlOrExists"))); }
                else
                {
                    if (string.IsNullOrEmpty(postVal.Name)) { sr.Append(_admUi.ErrorBox(_siteDat.GetLan("MsgNoName"))); }
                    else
                    {
                        if (postVal.ID == 0)
                        {
                            postVal.ID = flwData.InsertFellow(postVal);
                            sr.Append(_admUi.SuccessBox(_siteDat.GetLan("MsgInsertDat"), string.Format("?act=fellow&mode=list&home={0}", postVal.Home ? 1 : 0)));
                        }
                        else
                        {
                            postVal.ID = flwData.UpdateFellow(postVal);
                            sr.Append(_admUi.SuccessBox(_siteDat.GetLan("MsgUpdateDat"), string.Format("?act=fellow&mode=list&home={0}", postVal.Home ? 1 : 0)));
                        }
                        if (!string.IsNullOrEmpty(postVal.Logo) && _fun.ToInt(_fun.Post("down")) == 1)
                        {
                            string saveLogoDir = Path.Combine(SiteCfg.Router, "Attach/FellowLogo");
                            if (!Directory.Exists(saveLogoDir)) { Directory.CreateDirectory(saveLogoDir); }
                            //LOGO的后缀还需要处理
                            string saveLogoFile = Path.Combine(saveLogoDir, postVal.ID + ".gif");
                            if (new SiteIO().RemoteDownload(postVal.Logo, saveLogoFile))
                            {
                                postVal.Logo = saveLogoFile.Replace(SiteCfg.Router, SiteCfg.Path).Replace("\\", "/");
                                flwData.UpdateFellow(postVal);
                            }
                        }
                    }
                }
                ClearCache();
                old = postVal;
            }
            sr.Append(_admUi.AdminBoxStart(true));
            sr.Append(_htmlUi.FormStart());
            sr.Append(_htmlUi.TableStart("onCenter"));
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("Name")) + _htmlUi.CreateTd(_htmlUi.Input("name", 20, null, _fun.HtmlEncode(old.Name))));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("URL")) + _htmlUi.CreateTd(_htmlUi.Input("url", 50, null, _fun.HtmlEncode(old.URL))));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("Logo")) + _htmlUi.CreateTd(_htmlUi.Input("logo", 50, null, _fun.HtmlEncode(old.Logo)) + _htmlUi.CheckBoxInput(_siteDat.GetLan("AreYouDown"), "down", 1, false)));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("Intro")) + _htmlUi.CreateTd(_htmlUi.Input("explain", 50, null, _fun.HtmlEncode(old.Explain))));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("Style")) + _htmlUi.CreateTd(_htmlUi.Input("style", 50, null, _fun.HtmlEncode(old.Style))));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("Sorting")) + _htmlUi.CreateTd(_htmlUi.Input("sorting", 5, null, old.Sorting)));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("Virtue")) + _htmlUi.CreateTd(_htmlUi.CheckBoxInput(_siteDat.GetLan("IdxLink"), "home", 1, old.Home) + _htmlUi.CheckBoxInput(_siteDat.GetLan("Show"), "show", 1, old.Show)));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh() + _htmlUi.CreateTd(_htmlUi.SubmitButton() + _htmlUi.ResetButton()));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TableFinal());
            sr.Append(_htmlUi.FormFinal());
            sr.Append(_admUi.AdminBoxFinal());
            return sr.ToString();
        }
    }
}
