﻿using System.Text;
using isRoc.Core;
using isRoc.Core.UI;
using isRoc.Data;
using isRoc.Data.Entity;

namespace isRoc.Logic.Admin
{
    /// <summary>
    /// 自定义标签管理类
    /// </summary>
    public class AdminMyTag
    {
        private SiteFun _fun = new SiteFun();
        private SiteDat _siteDat = new SiteDat();
        private AdminUI _admUi = new AdminUI();
        private HtmlUI _htmlUi = new HtmlUI();

        /// <summary>
        /// 清除缓存
        /// </summary>
        private void ClearCache()
        {
            SiteCache cache = new SiteCache();
            _siteDat.RemoveDat(cache.MyTag);
        }

        /// <summary>
        /// 取得页面列表窗体
        /// </summary>
        /// <returns>返回页面列表代码</returns>
        public string List()
        {
            StringBuilder sr = new StringBuilder();
            MyTagData mtData = new MyTagData();
            if (_fun.IsPost)
            {
                int id = _fun.ToInt(_fun.Post("id"));
                int priority = _fun.ToInt(_fun.Post("priority"));
                bool show = _fun.ToInt(_fun.Post("show")) == 0 ? false : true;
                bool del = _fun.ToInt(_fun.Post("del")) == 0 ? false : true;
                if (del)
                {
                    mtData.DeleteMyTag(id);
                    sr.Append(_admUi.SuccessBox(_siteDat.GetLan("MsgDelDat")));
                }
                else
                {
                    mtData.UpdateMyTagSome(id, priority, show);
                    sr.Append(_admUi.SuccessBox(_siteDat.GetLan("MsgUpdateDat")));
                }
                ClearCache();
            }
            sr.Append(_admUi.AdminBoxStart(true));
            sr.Append(_htmlUi.TableStart());
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("Key")));
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("Intro")));
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("DateTime")));
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("Show")));
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("Priority")));
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("Delete")));
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("Operate")));
            sr.Append(_htmlUi.TrFinal());
            //下面三行是分页设置
            int page = _fun.ToInt(_fun.Query("page"));
            if (page < 1) { page = 1; }
            int pageSize = 20;
            DataList<MyTagItem> list = mtData.SelectMyTag(page, pageSize, true);
            int i = 1;
            foreach (MyTagItem vItem in list)
            {
                i++;
                sr.Append(_htmlUi.FormStart());
                sr.Append(_htmlUi.TrStart(i % 2 == 0 ? " cRow" : null));
                sr.Append(_htmlUi.CreateTd(_htmlUi.Link(_fun.HtmlEncode(vItem.Key), string.Format("?act=myTag&amp;mode=post&amp;id={0}", vItem.ID))));
                sr.Append(_htmlUi.CreateTd(_fun.HtmlEncode(vItem.Intro)));
                sr.Append(_htmlUi.CreateTd(vItem.Publish));
                sr.Append(_htmlUi.CreateTd(_htmlUi.CheckBoxInput("show", 1, vItem.Show)));
                sr.Append(_htmlUi.CreateTd(_htmlUi.Input("priority", 5, null, vItem.Priority)));
                sr.Append(_htmlUi.CreateTd(_htmlUi.CheckBoxInput("del", 1, false)));
                sr.Append(_htmlUi.CreateTd(_htmlUi.HiddenInput("id", vItem.ID) + _htmlUi.SubmitButton(_siteDat.GetLan("BtnSave"))));
                sr.Append(_htmlUi.TrFinal());
                sr.Append(_htmlUi.FormFinal());
            }
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTd(new SitePages().Make(list.Number, page, pageSize, "?act=myTag&amp;mode=list&amp;page={0}"), 7, null));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TableFinal());
            sr.Append(_admUi.AdminBoxFinal());
            return sr.ToString();
        }

        /// <summary>
        /// 提交页面窗体
        /// </summary>
        /// <returns>返回发布页面控件代码</returns>
        public string Post()
        {
            StringBuilder sr = new StringBuilder();
            int id = _fun.ToInt(_fun.Query("id"));
            MyTagData mtData = new MyTagData();
            if (_fun.IsPost)
            {
                MyTagItem postVal = new MyTagItem();
                postVal.ID = id;
                postVal.Key = _fun.Post("key");
                postVal.Intro = _fun.Post("intro");
                postVal.Code = _fun.Post("code");
                postVal.Publish = _fun.ToDate(_fun.Post("publish"));
                postVal.Priority = _fun.ToInt(_fun.Post("priority"));
                postVal.Show = _fun.ToInt(_fun.Post("show")) == 0 ? false : true;
                if (string.IsNullOrEmpty(postVal.Key)) { sr.Append(_admUi.ErrorBox(_siteDat.GetLan("MsgNoKey"))); }
                else
                {
                    if (postVal.ID == 0) { mtData.InsertMyTag(postVal); sr.Append(_admUi.SuccessBox(_siteDat.GetLan("MsgInsertDat"), "?act=myTag&mode=list")); }
                    else { mtData.UpdateMyTag(postVal); sr.Append(_admUi.SuccessBox(_siteDat.GetLan("MsgUpdateDat"), "?act=myTag&mode=list")); }
                }
                ClearCache();
            }
            //取得默认值
            MyTagItem old = mtData.GetMyTag(id);
            sr.Append(_admUi.AdminBoxStart(true));
            sr.Append(_htmlUi.FormStart());
            sr.Append(_htmlUi.TableStart("onCenter"));
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("Key")) + _htmlUi.CreateTd(_htmlUi.Input("key", 20, null, _fun.HtmlEncode(old.Key))));
            sr.Append(_htmlUi.TrFinal());
            if (old.ID > 0)
            {
                sr.Append(_htmlUi.TrStart());
                sr.Append(_htmlUi.CreateTh() + _htmlUi.CreateTd(_fun.HtmlEncode(string.Format("<xsl:value-of select=\"/ui/myTag/{0}\" disable-output-escaping=\"yes\"/>", old.Key))));
                sr.Append(_htmlUi.TrFinal());
            }
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("Intro")) + _htmlUi.CreateTd(_htmlUi.Input("intro", 50, null, _fun.HtmlEncode(old.Intro))));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("Content")) + _htmlUi.CreateTd(_htmlUi.Textarea("code", 15, 80, _fun.HtmlEncode(old.Code))));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("DateTime")) + _htmlUi.CreateTd(_htmlUi.Input("publish", 20, null, old.Publish)));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("Priority")) + _htmlUi.CreateTd(_htmlUi.Input("priority", 5, null, old.Priority)));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("Virtue")) + _htmlUi.CreateTd(_htmlUi.CheckBoxInput(_siteDat.GetLan("Show"), "show", 1, old.Show)));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh() + _htmlUi.CreateTd(_htmlUi.SubmitButton() + _htmlUi.ResetButton()));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TableFinal());
            sr.Append(_htmlUi.FormFinal());
            sr.Append(_admUi.AdminBoxFinal());
            return sr.ToString();
        }
    }
}
