﻿using System.Collections;
using System.IO;
using System.Text;
using isRoc.Core;
using isRoc.Core.UI;
using isRoc.Data;
using isRoc.Data.Entity;

namespace isRoc.Logic.Admin
{
    /// <summary>
    /// 系统配置类
    /// </summary>
    public class AdminSetting
    {
        private SiteFun _fun = new SiteFun();
        private SiteDat _siteDat = new SiteDat();
        private AdminUI _admUi = new AdminUI();
        private HtmlUI _htmlUi = new HtmlUI();

        /// <summary>
        /// 清除缓存
        /// </summary>
        private void ClearCache()
        {
            SiteCache cache = new SiteCache();
            _siteDat.RemoveDat(cache.Setting);
        }

        /// <summary>
        /// 参数设置
        /// </summary>
        public string Parameter()
        {
            StringBuilder sr = new StringBuilder();
            SettingData setData = new SettingData();
            //取得默认值
            if (_fun.IsPost)
            {
                SettingParameterItem postVal = new SettingParameterItem();
                postVal.BokeCCID = _fun.ToInt(_fun.Post("boke"));
                postVal.WatermarkSeat = _fun.ToInt(_fun.Post("ws"));
                postVal.WatermarkPath = _fun.Post("wmPath");
                postVal.ArticleNum = _fun.ToInt(_fun.Post("artNum"));
                postVal.CommentNum = _fun.ToInt(_fun.Post("cmtNum"));
                postVal.AppendFineArticleNum = _fun.ToInt(_fun.Post("appFAN"));
                postVal.AppendRandomArticleNum = _fun.ToInt(_fun.Post("appRAN"));
                postVal.AppendHotArticleNum = _fun.ToInt(_fun.Post("appHAN"));
                postVal.AppendHotTagNum = _fun.ToInt(_fun.Post("appHTN"));
                postVal.AppendNewCommentNum = _fun.ToInt(_fun.Post("appNCN"));
                postVal.RssNum = _fun.ToInt(_fun.Post("rssNum"));
                postVal.RssMode = _fun.ToInt(_fun.Post("rssMode"));
                postVal.Key = _fun.Post("key");
                setData.UpdateSettingParameter(postVal);
                sr.Append(_admUi.SuccessBox(_siteDat.GetLan("MsgUpdateDat")));
                ClearCache();
            }
            SettingItem old = setData.GetSetting();
            sr.Append(_htmlUi.FormStart());
            sr.Append(_admUi.AdminBoxStart(true));
            sr.Append(_htmlUi.TableStart("onCenter"));
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("RssNum")) + _htmlUi.CreateTd(_htmlUi.Input("rssNum", 5, null, old.Parameter.RssNum)));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("RssMode")) + _htmlUi.CreateTd(_htmlUi.RadioInput(_siteDat.GetLan("ShowExplain"), "rssMode", 0, old.Parameter.RssMode == 0) + _htmlUi.RadioInput(_siteDat.GetLan("ShowContent"), "rssMode", 1, old.Parameter.RssMode == 1)));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TableFinal());
            sr.Append(_admUi.AdminBoxFinal());
            sr.Append(_admUi.AdminBoxStart(true));
            sr.Append(_htmlUi.TableStart("onCenter"));
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("ArtNum")) + _htmlUi.CreateTd(_htmlUi.Input("artNum", 5, null, old.Parameter.ArticleNum)));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("CmtNum")) + _htmlUi.CreateTd(_htmlUi.Input("cmtNum", 5, null, old.Parameter.CommentNum)));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TableFinal());
            sr.Append(_admUi.AdminBoxFinal());
            sr.Append(_admUi.AdminBoxStart(true));
            sr.Append(_htmlUi.TableStart("onCenter"));
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("TopArtNum")) + _htmlUi.CreateTd(_htmlUi.Input("appFAN", 5, null, old.Parameter.AppendFineArticleNum)));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TrStart()); 
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("RandomArtNum")) + _htmlUi.CreateTd(_htmlUi.Input("appRAN", 5, null, old.Parameter.AppendRandomArticleNum)));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("HotArtNum")) + _htmlUi.CreateTd(_htmlUi.Input("appHAN", 5, null, old.Parameter.AppendHotArticleNum)));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TrStart()); 
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("HotTagNum")) + _htmlUi.CreateTd(_htmlUi.Input("appHTN", 5, null, old.Parameter.AppendHotTagNum)));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("NewCmtNum")) + _htmlUi.CreateTd(_htmlUi.Input("appNCN", 5, null, old.Parameter.AppendNewCommentNum)));
            sr.Append(_htmlUi.CreateTh() + _htmlUi.CreateTd());
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TableFinal());
            sr.Append(_admUi.AdminBoxFinal());
            //水印设置
            sr.Append(_admUi.AdminBoxStart(true));
            sr.Append(_htmlUi.TableStart("onCenter"));
            sr.Append(_htmlUi.TrStart());
            ArrayList values = new ArrayList();
            for (int wmI = 0; wmI <= 9; wmI++)
            {
                values.Add(wmI);
            }
            ArrayList caps = new ArrayList();
            caps.Add(_siteDat.GetLan("Close"));
            caps.Add(_siteDat.GetLan("PTopLeft"));
            caps.Add(_siteDat.GetLan("PTopCen"));
            caps.Add(_siteDat.GetLan("PTopRight"));
            caps.Add(_siteDat.GetLan("PMdlLeft"));
            caps.Add(_siteDat.GetLan("PMdlCen"));
            caps.Add(_siteDat.GetLan("PMdlRight"));
            caps.Add(_siteDat.GetLan("PBtmLeft"));
            caps.Add(_siteDat.GetLan("PBtmCen"));
            caps.Add(_siteDat.GetLan("PBtmRight"));
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("WmPosition")));
            sr.Append(_htmlUi.CreateTd(_htmlUi.Input("wmPath", 50, null, _fun.HtmlEncode(old.Parameter.WatermarkPath)) + _htmlUi.CreateSelect("ws", values, caps, old.Parameter.WatermarkSeat)));
            sr.Append(_htmlUi.TrFinal());
            if (File.Exists(Path.Combine(SiteCfg.Router, old.Parameter.WatermarkPath)))
            {
                sr.Append(_htmlUi.CreateTh());
                sr.Append(_htmlUi.CreateTd(_htmlUi.Image(SiteCfg.Path + old.Parameter.WatermarkPath, old.Parameter.WatermarkPath)));
                sr.Append(_htmlUi.TrFinal());
            }
            sr.Append(_htmlUi.TableFinal());
            sr.Append(_admUi.AdminBoxFinal());
            //水印
            sr.Append(_admUi.AdminBoxStart(true));
            sr.Append(_htmlUi.TableStart("onCenter"));
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("BusinessKey")) + _htmlUi.CreateTd(_htmlUi.Input("key", 15, null, _fun.HtmlEncode(old.Parameter.Key))));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh() + _htmlUi.CreateTd(_htmlUi.SubmitButton() + _htmlUi.ResetButton()));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TableFinal());
            sr.Append(_admUi.AdminBoxFinal());
            sr.Append(_htmlUi.FormFinal());
            return sr.ToString();
        }

        /// <summary>
        /// 基础设置
        /// </summary>
        public string Basic()
        {
            StringBuilder sr = new StringBuilder();
            SettingData setData = new SettingData();
            //取得默认值
            if (_fun.IsPost)
            {
                SettingBasicItem postVal = new SettingBasicItem();
                postVal.Name = _fun.Post("caption");
                postVal.URL = _fun.Post("url");
                if (!string.IsNullOrEmpty(postVal.URL))
                {
                    if (!postVal.URL.EndsWith("/")) { postVal.URL += "/"; }
                }
                postVal.ICP = _fun.Post("icp");
                //postVal.Language = _fun.Post("language");
                postVal.Intro = _fun.Post("intro");
                postVal.Keywords = _fun.Post("keywords");
                postVal.Affiche = _fun.Post("affiche");
                postVal.Filter = _fun.Post("filter");
                postVal.UploadExt = _fun.Post("uploadExt");
                postVal.Mail = _fun.Post("mail");
                postVal.MailFrom = _fun.Post("mailFrom");
                postVal.MailHost = _fun.Post("mailHost");
                postVal.MailPort = _fun.ToInt(_fun.Post("mailPort"));
                postVal.MailUserID = _fun.Post("mailUid");
                postVal.MailPassword = _fun.Post("mailPwd");
                setData.UpdateSettingBasic(postVal);
                sr.Append(_admUi.SuccessBox(_siteDat.GetLan("MsgUpdateDat")));
                ClearCache();
            }
            SettingItem old = setData.GetSetting();
            sr.Append(_htmlUi.FormStart());
            sr.Append(_admUi.AdminBoxStart(true));

            sr.Append(_htmlUi.TableStart("onCenter advancedBox"));
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("SiteCap")) + _htmlUi.CreateTd(_htmlUi.Input("caption", 20, null, _fun.HtmlEncode(old.Basic.Name))));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("URL")) + _htmlUi.CreateTd(_htmlUi.Input("url", 50, null, _fun.HtmlEncode(old.Basic.URL))));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("Icp")) + _htmlUi.CreateTd(_htmlUi.Input("icp", 30, null, _fun.HtmlEncode(old.Basic.ICP))));
            sr.Append(_htmlUi.TrFinal());
            /*sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("Lang")) + _htmlUi.CreateTd(_htmlUi.Input("language", 10, null, _fun.HtmlEncode(old.Basic.Language))));
            sr.Append(_htmlUi.TrFinal());*/
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("Intro")) + _htmlUi.CreateTd(_htmlUi.Input("intro", 50, null, _fun.HtmlEncode(old.Basic.Intro))));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("Keywords")) + _htmlUi.CreateTd(_htmlUi.Input("keywords", 50, null, _fun.HtmlEncode(old.Basic.Keywords))));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("Affiche")) + _htmlUi.CreateTd(_admUi.Editor("affiche", _fun.HtmlEncode(old.Basic.Affiche))));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("Mail")) + _htmlUi.CreateTd(_htmlUi.Input("mail", 30, null, _fun.HtmlEncode(old.Basic.Mail))));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.TableFinal());
            //安全相关
            sr.Append(_htmlUi.TableStart("onCenter hidden advancedBox"));
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("IllChar")) + _htmlUi.CreateTd(_htmlUi.Textarea("filter", 10, 80, _fun.HtmlEncode(old.Basic.Filter))));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("SafeSuffix")) + _htmlUi.CreateTd(_htmlUi.Input("uploadExt", 60, null, _fun.HtmlEncode(old.Basic.UploadExt))));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TableFinal());
            //邮件服务器
            sr.Append(_htmlUi.TableStart("onCenter hidden advancedBox"));
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("MailFrom")) + _htmlUi.CreateTd(_htmlUi.Input("mailFrom", 30, null, _fun.HtmlEncode(old.Basic.MailFrom))));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("MailSvr")) + _htmlUi.CreateTd(_htmlUi.Input("mailHost", 30, null, _fun.HtmlEncode(old.Basic.MailHost))));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("MailSvrPort")) + _htmlUi.CreateTd(_htmlUi.Input("mailPort", 5, null, old.Basic.MailPort)));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("MailUserId")) + _htmlUi.CreateTd(_htmlUi.Input("mailUid", 20, null, _fun.HtmlEncode(old.Basic.MailUserID))));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("MailPwd")) + _htmlUi.CreateTd(_htmlUi.PasswordInput("mailPwd", 20, null, _fun.HtmlEncode(old.Basic.MailPassword))));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TableFinal());

            sr.Append(_htmlUi.TableStart("onCenter"));
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh() + _htmlUi.CreateTd(_htmlUi.SubmitButton() + _htmlUi.ResetButton() + _htmlUi.Button("advancedLink", _siteDat.GetLan("BtnAdvanced"))));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TableFinal());

            sr.Append(_admUi.AdminBoxFinal());
            sr.Append(_htmlUi.FormFinal());
            return sr.ToString();
        }
    }
}
