﻿using System.Text;
using isRoc.Core;
using isRoc.Core.UI;
using isRoc.Data;
using isRoc.Data.Entity;

namespace isRoc.Logic.Admin
{
    /// <summary>
    /// 分类管理类
    /// </summary>
    public class AdminTag
    {
        private SiteFun _fun = new SiteFun();
        private SiteDat _siteDat = new SiteDat();
        private AdminUI _admUi = new AdminUI();
        private HtmlUI _htmlUi = new HtmlUI();

        /// <summary>
        /// 清除缓存
        /// </summary>
        private void ClearCache()
        {
            SiteCache cache = new SiteCache();
            _siteDat.RemoveDat(cache.HotTag);
        }

        /// <summary>
        /// 系统标签操作
        /// </summary>
        /// <returns>标签列表及操作表单</returns>
        public string List()
        {
            StringBuilder sr = new StringBuilder();
            TagData tData = new TagData();
            if (_fun.IsPost)
            {
                //取值
                TagItem postVal = new TagItem();
                postVal.ID = _fun.ToInt(_fun.Post("id"));
                postVal.Key = _fun.Post("key");
                //处理
                if (string.IsNullOrEmpty(postVal.Key)) { sr.Append(_admUi.ErrorBox(_siteDat.GetLan("MsgNoKey"))); }
                else
                {
                    if (tData.ExistsKey(postVal.Key, postVal.ID)) { sr.Append(_admUi.ErrorBox(_siteDat.GetLan("MsgTagExists"))); }
                    else
                    {
                        if (postVal.ID == 0) { tData.InsertTag(postVal); sr.Append(_admUi.SuccessBox(_siteDat.GetLan("MsgInsertDat"))); }
                        else
                        {
                            if (_fun.ToInt(_fun.Post("del")) == 0) { tData.UpdateTag(postVal); sr.Append(_admUi.SuccessBox(_siteDat.GetLan("MsgUpdateDat"))); }
                            else { tData.DeleteTag(postVal.ID); sr.Append(_admUi.SuccessBox(_siteDat.GetLan("MsgDelDat"))); }
                        }
                    }
                }
                ClearCache();
            }
            sr.Append(_admUi.AdminBoxStart(true));
            sr.Append(_htmlUi.TableStart());
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("Key")));
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("Article")));
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("Delete")));
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("Operate")));
            sr.Append(_htmlUi.TrFinal());
            //下面三行是分页设置
            int page = _fun.ToInt(_fun.Query("page"));
            if (page < 1) { page = 1; }
            int pageSize = 20;
            TagList list = new TagData().SelectTag(page, pageSize);
            int i = 1;
            foreach (TagItem vItem in list)
            {
                i++;
                sr.Append(_htmlUi.FormStart());
                sr.Append(_htmlUi.TrStart(i % 2 == 0 ? " cRow" : null));
                sr.Append(_htmlUi.CreateTd(_htmlUi.HiddenInput("id", vItem.ID) + _htmlUi.Input("key", 20, null, _fun.HtmlEncode(vItem.Key))));
                sr.Append(_htmlUi.CreateTd(vItem.PostCount));
                sr.Append(_htmlUi.CreateTd(_htmlUi.CheckBoxInput("del", 1, false)));
                sr.Append(_htmlUi.CreateTd(_htmlUi.SubmitButton(_siteDat.GetLan("BtnSave"))));
                sr.Append(_htmlUi.TrFinal());
                sr.Append(_htmlUi.FormFinal());
            }
            sr.Append(_htmlUi.FormStart());
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTd(_htmlUi.Input("key", 20, null, null)));
            sr.Append(_htmlUi.CreateTd(0));
            sr.Append(_htmlUi.CreateTd());
            sr.Append(_htmlUi.CreateTd(_htmlUi.SubmitButton(_siteDat.GetLan("BtnInsert"))));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.FormFinal());
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTd(new SitePages().Make(list.Number, page, pageSize, "?act=tag&amp;mode=list&amp;page={0}"), 4, null));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TableFinal());
            sr.Append(_admUi.AdminBoxFinal());
            return sr.ToString();
        }
    }
}
