﻿using System;
using System.IO;
using System.Web;
using isRoc.Core;
using isRoc.Core.UI;
using isRoc.Data;
using System.Text;

namespace isRoc.Logic.Admin
{
    /// <summary>
    /// 主题管理类
    /// </summary>
    public class AdminTheme
    {
        private SiteFun _fun = new SiteFun();
        private SiteDat _siteDat = new SiteDat();
        private AdminUI _admUi = new AdminUI();
        private HtmlUI _htmlUi = new HtmlUI();

        /// <summary>
        /// 清除缓存
        /// </summary>
        private void ClearCache()
        {
            SiteCache cache = new SiteCache();
            _siteDat.RemoveDat(cache.Setting);
        }

        /// <summary>
        /// 选择主题包
        /// </summary>
        public string Select()
        {
            StringBuilder sr = new StringBuilder();
            SettingData setData = new SettingData();
            if (_fun.IsPost)
            {
                string postVal = _fun.Post("theme");
                if (!string.IsNullOrEmpty(postVal))
                {
                    setData.SetTheme(postVal);
                    sr.Append(_admUi.SuccessBox(_siteDat.GetLan("MsgUpdateThemeSucc")));
                }
                ClearCache();
            }
            sr.Append(_admUi.AdminBoxStart(true));
            sr.Append(_htmlUi.TableStart());
            sr.Append(_htmlUi.TrStart());
            //取得系统模板名称并循环
            string theme = setData.GetTheme;
            int count = 0;
            foreach (string dir in Directory.GetDirectories(Path.Combine(SiteCfg.Router, "Common/Theme/")))
            {
                DirectoryInfo dirInfo = new DirectoryInfo(dir);
                string innerTable = _htmlUi.FormStart();
                innerTable += _htmlUi.TableStart();
                innerTable += _htmlUi.TrStart();
                innerTable += _htmlUi.CreateTd(_htmlUi.Image(string.Format("Common/Theme/{0}/Preview.png", dirInfo.Name), dirInfo.Name, null, 300, 180));
                innerTable += _htmlUi.TrFinal();
                innerTable += _htmlUi.TrStart();
                innerTable += _htmlUi.CreateTd(_htmlUi.HiddenInput("theme", dirInfo.Name) + _htmlUi.SubmitButton(string.Format(_siteDat.GetLan("BtnThemeSel"), dirInfo.Name), (dirInfo.Name == theme ? "red" : string.Empty)));
                innerTable += _htmlUi.TrFinal();
                innerTable += _htmlUi.TableFinal();
                innerTable += _htmlUi.FormFinal();
                //开始处理
                sr.Append(_htmlUi.CreateTd(innerTable));
                count++;
                if (count % 2 == 0)
                {
                    sr.Append(_htmlUi.TrFinal());
                    sr.Append(_htmlUi.TrStart());
                }
            }
            //循环结束
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TableFinal());
            sr.Append(_admUi.AdminBoxFinal());
            return sr.ToString();
        }
    }
}
