﻿using isRoc.Core;
using isRoc.Core.UI;
using isRoc.Data;
using isRoc.Data.Entity;
using System.Text;

namespace isRoc.Logic.Admin
{
    /// <summary>
    /// 引用通告管理类
    /// </summary>
    public class AdminTrackback
    {
        private SiteFun _fun = new SiteFun();
        private SiteDat _siteDat = new SiteDat();
        private AdminUI _admUi = new AdminUI();
        private HtmlUI _htmlUi = new HtmlUI();

        /// <summary>
        /// 取得已发送引用通告列表窗体
        /// </summary>
        /// <returns>返回引用通告列表代码</returns>
        public string List()
        {
            StringBuilder sr = new StringBuilder();
            TrackbackLogData tbData = new TrackbackLogData();
            if (_fun.IsPost)
            {
                int id = _fun.ToInt(_fun.Post("id"));
                if (id > 0) { tbData.DeleteTrackbackLog(id); sr.Append(_admUi.SuccessBox(_siteDat.GetLan("MsgDelDat"))); }
            }
            sr.Append(_admUi.AdminBoxStart(true));
            sr.Append(_htmlUi.TableStart());
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("URL")));
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("Success")));
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("Result")));
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("DateTime")));
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("Operate")));
            sr.Append(_htmlUi.TrFinal());
            //下面三行是分页设置
            int page = _fun.ToInt(_fun.Query("page"));
            if (page < 1) { page = 1; }
            int pageSize = 20;
            DataList<TrackbackLogItem> list = tbData.SelectTrackbackLog(page, pageSize);
            int i = 1;
            foreach (TrackbackLogItem vItem in list)
            {
                i++;
                sr.Append(_htmlUi.FormStart());
                sr.Append(_htmlUi.TrStart(i % 2 == 0 ? " cRow" : null));
                sr.Append(_htmlUi.CreateTd(_htmlUi.Link(_fun.HtmlEncode(_fun.StrCut(vItem.URL, 50)), vItem.URL)));
                sr.Append(_htmlUi.CreateTd(vItem.Error ? _siteDat.GetLan("No") : _siteDat.GetLan("Yes")));
                sr.Append(_htmlUi.CreateTd(_fun.HtmlEncode(vItem.Message)));
                sr.Append(_htmlUi.CreateTd(vItem.Publish));
                sr.Append(_htmlUi.CreateTd(_htmlUi.HiddenInput("id", vItem.ID) + _htmlUi.SubmitButton(_siteDat.GetLan("BtnDel"))));
                sr.Append(_htmlUi.TrFinal());
                sr.Append(_htmlUi.FormFinal());
            }
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTd(new SitePages().Make(list.Number, page, pageSize, "?act=info&amp;mode=tb&amp;page={0}"), 5, null));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TableFinal());
            sr.Append(_admUi.AdminBoxFinal());
            return sr.ToString();
        }
    }
}
