﻿using System;
using System.Text;
using isRoc.Core;
using isRoc.Core.UI;
using isRoc.Logic.Upgrade;

namespace isRoc.Logic.Admin
{
    /// <summary>
    /// 更新检查类
    /// </summary>
    public class AdminUpgrade
    {
        private SiteDat _siteDat = new SiteDat();
        private AdminUI _admUi = new AdminUI();
        private HtmlUI _htmlUi = new HtmlUI();

        /// <summary>
        /// 数据状态信息
        /// </summary>
        public string OutWrite()
        {
            StringBuilder sr = new StringBuilder();
            sr.Append(_admUi.AdminBoxStart(true));
            sr.Append(_htmlUi.TableStart("onCenter"));
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("CurrVer")) + _htmlUi.CreateTd(SiteCfg.SystemVersionFull));
            sr.Append(_htmlUi.TrFinal());
            try
            {
                UpgradeCheck uc = new UpgradeCheck(SiteCfg.Version);
                sr.Append(_htmlUi.TrStart());
                if (uc.Version == SiteCfg.SystemVersionFull) { sr.Append(_htmlUi.CreateTh() + _htmlUi.CreateTd(_siteDat.GetLan("MsgIsLatestVer"))); }
                else
                {
                    sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("ToVer")) + _htmlUi.CreateTd(uc.Version));
                }
                sr.Append(_htmlUi.TrFinal());
                if (!string.IsNullOrEmpty(uc.Intro))
                {
                    sr.Append(_htmlUi.TrStart());
                    sr.Append(_htmlUi.CreateTh() + _htmlUi.CreateTd(uc.Intro));
                    sr.Append(_htmlUi.TrFinal());
                }
                sr.Append(_htmlUi.TableFinal());
                sr.Append(_admUi.AdminBoxFinal());
                sr.Append(_admUi.AdminBoxStart());
                sr.Append(_htmlUi.TableStart("onCenter"));
                int i = 0;
                foreach (UpgradeFileEntity vItem in uc.GetFileList)
                {
                    i++;
                    sr.Append(_htmlUi.TrStart());
                    sr.Append(_htmlUi.CreateTh(i == 1 ? _siteDat.GetLan("UpgradeList") : string.Empty) + _htmlUi.CreateTd(vItem.FilePath));
                    sr.Append(_htmlUi.TrFinal());
                }
                i = 0;
                foreach (UpgradeFileEntity vItem in uc.GetRemoveList)
                {
                    i++;
                    sr.Append(_htmlUi.TrStart());
                    sr.Append(_htmlUi.CreateTh(i == 1 ? _siteDat.GetLan("RemoveList") : string.Empty) + _htmlUi.CreateTd(vItem.FilePath));
                    sr.Append(_htmlUi.TrFinal());
                }
                if (uc.Version != SiteCfg.SystemVersionFull)
                {
                    string upPackUri = uc.PackFile;
                    if (!upPackUri.StartsWith("http://", StringComparison.CurrentCultureIgnoreCase)) { upPackUri = string.Format("{0}_isRoc/{1}/{2}", SiteCfg.UpdateHost, SiteCfg.Version, uc.PackFile); }
                    sr.Append(_htmlUi.TrStart());
                    sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("ManualUpdate")) + _htmlUi.CreateTd(_htmlUi.Link(_siteDat.GetLan("GetUpgradePack"), upPackUri, null, true)));
                    sr.Append(_htmlUi.TrFinal());
                    sr.Append(_htmlUi.TrStart());
                    sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("ChkToken")) + _htmlUi.CreateTd(_htmlUi.Input("upgradeToken", "upgradeToken", 20, null, null)));
                    sr.Append(_htmlUi.TrFinal());
                    sr.Append(_htmlUi.TrStart());
                    sr.Append(_htmlUi.CreateTh() + _htmlUi.CreateTd(_htmlUi.HiddenInput("upgradeVer", "upgradeVer", SiteCfg.Version) + _htmlUi.Button("upgradeBegin", _siteDat.GetLan("BtnUpgrade"))));
                    sr.Append(_htmlUi.TrFinal());
                    sr.Append(_htmlUi.TrStart());
                    sr.Append(_htmlUi.CreateTh() + _htmlUi.CreateTd("<div class=\"preBox\"><div id=\"preDemo\" class=\"preNum\" style=\"width:0%;\"></div></div><div id=\"upgradeState\"></div>"));
                    sr.Append(_htmlUi.TrFinal());
                }
            }
            catch (Exception err)
            {
                sr.Append(_htmlUi.TrStart());
                sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("GetUpgradeError")) + _htmlUi.CreateTd(err.Message));
                sr.Append(_htmlUi.TrFinal());
            }
            sr.Append(_htmlUi.TableFinal());
            sr.Append(_admUi.AdminBoxFinal());
            return sr.ToString();
        }
    }
}
