﻿using System.Text;
using isRoc.Core;
using isRoc.Core.UI;
using isRoc.Data;
using isRoc.Data.Entity;

namespace isRoc.Logic.Admin
{
    /// <summary>
    /// 用户管理类
    /// </summary>
    public class AdminUser
    {
        private SiteFun _fun = new SiteFun();
        private SiteDat _siteDat = new SiteDat();
        private AdminUI _admUi = new AdminUI();
        private HtmlUI _htmlUi = new HtmlUI();
        private _AdminCookie _ac = new _AdminCookie();

        /// <summary>
        /// 取得用户列表窗体
        /// </summary>
        /// <returns>返回用户列表代码</returns>
        public string List()
        {
            StringBuilder sr = new StringBuilder();
            UserData usrData = new UserData();
            string myUserId = _ac.Get()[0];
            if (_fun.IsPost)
            {
                int id = _fun.ToInt(_fun.Post("id"));
                if (_fun.ToInt(_fun.Post("delete")) == 0)
                {
                    bool locked = _fun.ToInt(_fun.Post("locked")) == 0 ? false : true;
                    usrData.UpdateUserLocked(id, locked);
                }
                else { usrData.DeleteUser(id); }
                sr.Append(_admUi.SuccessBox(_siteDat.GetLan("MsgUpdateDat")));
            }
            sr.Append(_admUi.AdminBoxStart(true));
            sr.Append(_htmlUi.TableStart());
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("UserId")));
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("LastIp")));
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("LastDt")));
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("Locked")));
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("Delete")));
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("Operate")));
            sr.Append(_htmlUi.TrFinal());
            //下面三行是分页设置
            int page = _fun.ToInt(_fun.Query("page"));
            if (page < 1) { page = 1; }
            int pageSize = 20;
            DataList<UserItem> list = usrData.SelectUser(page, pageSize);
            int i = 1;
            foreach (UserItem vItem in list)
            {
                i++;
                sr.Append(_htmlUi.FormStart());
                sr.Append(_htmlUi.TrStart(i % 2 == 0 ? " cRow" : null));
                sr.Append(_htmlUi.CreateTd(_htmlUi.Link(_fun.HtmlEncode(vItem.UserID), string.Format("?act=user&amp;mode=post&amp;id={0}", vItem.ID))));
                sr.Append(_htmlUi.CreateTd(_fun.HtmlEncode(vItem.LastIP)));
                sr.Append(_htmlUi.CreateTd(vItem.LastTime));
                sr.Append(_htmlUi.CreateTd(myUserId.ToUpper() == vItem.UserID.ToUpper() ? "--" : _htmlUi.CheckBoxInput("locked", 1, vItem.Locked)));
                sr.Append(_htmlUi.CreateTd(myUserId.ToUpper() == vItem.UserID.ToUpper() ? "--" : _htmlUi.CheckBoxInput("delete", 1, false)));
                sr.Append(_htmlUi.CreateTd(_htmlUi.HiddenInput("id", vItem.ID) + _htmlUi.SubmitButton(_siteDat.GetLan("BtnSave"))));
                sr.Append(_htmlUi.TrFinal());
                sr.Append(_htmlUi.FormFinal());
            }
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTd(new SitePages().Make(list.Number, page, pageSize, "?act=user&amp;mode=list&amp;page={0}"), 6, null));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TableFinal());
            sr.Append(_admUi.AdminBoxFinal());
            return sr.ToString();
        }

        /// <summary>
        /// 提交用户数据
        /// </summary>
        /// <returns>返回发布用户代码</returns>
        public string Post()
        {
            StringBuilder sr = new StringBuilder();
            int id = _fun.ToInt(_fun.Query("id"));
            UserData usrData = new UserData();
            //取得默认值
            UserItem old = usrData.GetUser(id);
            if (_fun.IsPost)
            {
                UserItem postVal = new UserItem();
                string myUserId = _ac.Get()[0];
                postVal.ID = id;
                postVal.UserID = _fun.Post("userId");
                postVal.Name = _fun.Post("name");
                postVal.Password = _fun.Encryption(_fun.Post("password"));
                postVal.LastIP = old.LastIP;
                postVal.LastTime = old.LastTime;
                if (myUserId.ToUpper() != old.UserID.ToUpper()) { postVal.Locked = _fun.ToInt(_fun.Post("locked")) == 0 ? false : true; }
                if (string.IsNullOrEmpty(postVal.Password)) { postVal.Password = old.Password; }
                if (string.IsNullOrEmpty(postVal.UserID) || usrData.ExistsUserID(postVal.UserID, postVal.ID)) { sr.Append(_admUi.ErrorBox(_siteDat.GetLan("MsgNoUserIdOrExists"))); }
                else
                {
                    if (string.IsNullOrEmpty(postVal.Password)) { sr.Append(_admUi.ErrorBox(_siteDat.GetLan("MsgNoPwd"))); }
                    else
                    {
                        if (string.IsNullOrEmpty(postVal.Name)) { sr.Append(_admUi.ErrorBox(_siteDat.GetLan("MsgNoNickName"))); }
                        else
                        {
                            if (postVal.ID == 0) { usrData.InsertUser(postVal); sr.Append(_admUi.SuccessBox(_siteDat.GetLan("MsgInsertDat"), "?act=user&mode=list")); }
                            else { usrData.UpdateUser(postVal); sr.Append(_admUi.SuccessBox(_siteDat.GetLan("MsgUpdateDat"), "?act=user&mode=list")); }
                        }
                    }
                }
                old = postVal;
            }
            sr.Append(_admUi.AdminBoxStart(true));
            sr.Append(_htmlUi.FormStart());
            sr.Append(_htmlUi.TableStart("onCenter"));
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("UserId")) + _htmlUi.CreateTd(_htmlUi.Input("userId", 15, null, _fun.HtmlEncode(old.UserID))));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("Pwd")) + _htmlUi.CreateTd(_htmlUi.PasswordInput("password", 30, null, null)));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("NickName")) + _htmlUi.CreateTd(_htmlUi.Input("name", 15, null, old.Name)));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("LastIp")) + _htmlUi.CreateTd(_fun.HtmlEncode(old.LastIP)));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("LastDt")) + _htmlUi.CreateTd(old.LastTime));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("Virtue")) + _htmlUi.CreateTd(_htmlUi.CheckBoxInput(_siteDat.GetLan("Locked"), "locked", 1, old.Locked)));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh() + _htmlUi.CreateTd(_htmlUi.SubmitButton() + _htmlUi.ResetButton()));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TableFinal());
            sr.Append(_htmlUi.FormFinal());
            sr.Append(_admUi.AdminBoxFinal());
            return sr.ToString();
        }
    }
}
