﻿using System;
using System.Diagnostics;
using System.Text;
using System.Text.RegularExpressions;
using System.Web;
using System.Xml;
using isRoc.Core;
using isRoc.Core.UI;
using isRoc.Data;

namespace isRoc.Logic.Admin
{
    /// <summary>
    /// 后台默认页面类
    /// </summary>
    public class AdminWelcome
    {
        private AdminUI _admUi = new AdminUI();
        private HtmlUI _htmlUi = new HtmlUI();

        /// <summary>
        /// 写出主要代码
        /// </summary>
        public string OutCode()
        {
            SiteFun _fun = new SiteFun();
            SiteDat _siteDat = new SiteDat();
            HttpRequest request = HttpContext.Current.Request;
            StringBuilder sr = new StringBuilder();
            if (_fun.Query("reset") == "yes")
            {
                HttpRuntime.UnloadAppDomain();
                sr.Append(_admUi.SuccessBox(_siteDat.GetLan("MsgRebootApplicationSucc")));
            }
            //快捷入口
            sr.Append(_admUi.AdminBoxStart(true));
            sr.Append(_htmlUi.TableStart());
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTd(_htmlUi.Link(_htmlUi.Image("Common/Admin/Icons/Basic.png", null) + "<br/>" + _siteDat.GetLan("AdmMenuBase"), "?act=basic&amp;mode=base")));
            sr.Append(_htmlUi.CreateTd(_htmlUi.Link(_htmlUi.Image("Common/Admin/Icons/ArticleAdd.png", null) + "<br/>" + _siteDat.GetLan("AddArt"), "?act=post&amp;mode=post&amp;m=A")));
            sr.Append(_htmlUi.CreateTd(_htmlUi.Link(_htmlUi.Image("Common/Admin/Icons/Article.png", null) + "<br/>" + _siteDat.GetLan("ArtList"), "?act=post&amp;mode=list&amp;m=A")));
            sr.Append(_htmlUi.CreateTd(_htmlUi.Link(_htmlUi.Image("Common/Admin/Icons/FellowAdd.png", null) + "<br/>" + _siteDat.GetLan("AddLink"), "?act=fellow&amp;mode=post")));
            sr.Append(_htmlUi.CreateTd(_htmlUi.Link(_htmlUi.Image("Common/Admin/Icons/Fellow.png", null) + "<br/>" + _siteDat.GetLan("LinkList"), "?act=fellow&amp;mode=list")));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTd(_htmlUi.Link(_htmlUi.Image("Common/Admin/Icons/Comment.png", null) + "<br/>" + _siteDat.GetLan("CmtList"), "?act=comment&amp;mode=list")));
            sr.Append(_htmlUi.CreateTd(_htmlUi.Link(_htmlUi.Image("Common/Admin/Icons/DbBackup.png", null) + "<br/>" + _siteDat.GetLan("DbBackup"), "?act=db&amp;mode=backup")));
            sr.Append(_htmlUi.CreateTd(_htmlUi.Link(_htmlUi.Image("Common/Admin/Icons/Sql.png", null) + "<br/>" + _siteDat.GetLan("ExeSql"), "?act=db&amp;mode=sql")));
            sr.Append(_htmlUi.CreateTd(_htmlUi.Link(_htmlUi.Image("Common/Admin/Icons/Cache.png", null) + "<br/>" + _siteDat.GetLan("CacheList"), "?act=info&amp;mode=cache")));
            sr.Append(_htmlUi.CreateTd(_htmlUi.Link(_htmlUi.Image("Common/Admin/Icons/File.png", null) + "<br/>" + _siteDat.GetLan("AttachList"), "?act=attach&amp;mode=list")));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTd(_htmlUi.Link(_htmlUi.Image("Common/Admin/Icons/Page.png", null) + "<br/>" + _siteDat.GetLan("AdmMenuPGMgr"), "?act=post&amp;mode=list&amp;m=P")));
            sr.Append(_htmlUi.CreateTd(_htmlUi.Link(_htmlUi.Image("Common/Admin/Icons/Tag.png", null) + "<br/>" + _siteDat.GetLan("AdmMenuTagMgr"), "?act=tag&amp;mode=list")));
            sr.Append(_htmlUi.CreateTd(_htmlUi.Link(_htmlUi.Image("Common/Admin/Icons/Master.png", null) + "<br/>" + _siteDat.GetLan("AdmMenuMgrControl"), "?act=user&amp;mode=list")));
            sr.Append(_htmlUi.CreateTd(_htmlUi.Link(_htmlUi.Image("Common/Admin/Icons/Upgrade.png", null) + "<br/>" + _siteDat.GetLan("AdmMenuChkUP"), "?act=upgrade&amp;mode=info")));
            sr.Append(_htmlUi.CreateTd(_htmlUi.Link(_htmlUi.Image("Common/Admin/Icons/Business.png", null) + "<br/>" + _siteDat.GetLan("AdmMenuOffi"), null)));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TableFinal());
            sr.Append(_admUi.AdminBoxFinal());
            //系统信息
            sr.Append(_admUi.AdminBoxStart(true));
            sr.Append(_htmlUi.TableStart("onCenter"));
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("CurrVer")) + _htmlUi.CreateTd(SiteCfg.SystemVersionFull));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh() + _htmlUi.CreateTd(_htmlUi.Link(_siteDat.GetLan("RebootApplication"), "?reset=yes")));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("SvrIP")) + _htmlUi.CreateTd(request.ServerVariables["LOCAL_ADDR"]));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("SvrName")) + _htmlUi.CreateTd(request.ServerVariables["SERVER_NAME"]));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("SvrSoft")) + _htmlUi.CreateTd(request.ServerVariables["SERVER_SOFTWARE"]));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("SvrPort")) + _htmlUi.CreateTd(request.ServerVariables["SERVER_PORT"]));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("SvrApplPath")) + _htmlUi.CreateTd(SiteCfg.Router));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("SvrFilePath")) + _htmlUi.CreateTd(request.ServerVariables["PATH_TRANSLATED"]));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("SvrHost")) + _htmlUi.CreateTd(request.ServerVariables["HTTP_HOST"]));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("SvrLang")) + _htmlUi.CreateTd(request.ServerVariables["HTTP_ACCEPT_LANGUAGE"]));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("SvrCLR")) + _htmlUi.CreateTd(".NET CLR v" + Environment.Version.Major + "." + Environment.Version.Minor + "." + Environment.Version.Build + "." + Environment.Version.Revision));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("SvrOS")) + _htmlUi.CreateTd(Environment.OSVersion.ToString()));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("SvrCpuType")) + _htmlUi.CreateTd(Environment.GetEnvironmentVariable("PROCESSOR_IDENTIFIER")));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("SvrCpuNum")) + _htmlUi.CreateTd(Environment.GetEnvironmentVariable("NUMBER_OF_PROCESSORS")));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("Memory")) + _htmlUi.CreateTd(_fun.FormatLength(Process.GetCurrentProcess().PeakWorkingSet64)));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TableFinal());
            sr.Append(_admUi.AdminBoxFinal());
            //最新评论
            //sr.Append(new AdminComment().List(20));
            return sr.ToString();
        }

        /// <summary>
        /// 授权中心
        /// </summary>
        public string Business()
        {
            StringBuilder sr = new StringBuilder();
            /*
            string key = new SettingData().GetSetting().Parameter.Key;
            if (Regex.IsMatch(key, @"^[A-Z0-9]{10}$"))
            {
                try
                {
                    SiteFun fun = new SiteFun();
                    int page = fun.ToInt(fun.Query("page"));
                    string domain = HttpContext.Current.Request.ServerVariables["SERVER_NAME"];
                    if (domain != null) { domain = domain.ToUpper(); }
                    SiteXml xml = new SiteXml();
                    xml.LoadOfUri(string.Format("http://127.0.0.1/Business.xml?domain={0}&amp;key={1}&amp;page={2}", domain, key, page));
                    //官网信息
                    sr.Append(_admUi.AdminBoxStart(true));
                    sr.Append(_htmlUi.TableStart("onCenter"));
                    sr.Append(_htmlUi.TrStart());
                    sr.Append(_htmlUi.CreateTh("授权域名") + _htmlUi.CreateTd(xml.GetString("/response/info/domain")));
                    sr.Append(_htmlUi.TrFinal());
                    sr.Append(_htmlUi.TrStart());
                    sr.Append(_htmlUi.CreateTh("授权密匙") + _htmlUi.CreateTd(xml.GetString("/response/info/key")));
                    sr.Append(_htmlUi.TrFinal());
                    sr.Append(_htmlUi.TrStart());
                    sr.Append(_htmlUi.CreateTh("授权期限") + _htmlUi.CreateTd(string.Format("{0} - {1}", xml.GetDate("/response/info/beginDate"), xml.GetDate("/response/info/endDate"))));
                    sr.Append(_htmlUi.TrFinal());
                    sr.Append(_htmlUi.TableFinal());
                    sr.Append(_admUi.AdminBoxFinal());
                    if (xml.GetInt("/response/info/ratify") == 1)
                    {
                        int rows = xml.GetInt("/response/data/rows");
                        int pageSize = xml.GetInt("/response/data/pageSize");
                        int currPage = xml.GetInt("/response/data/currPage");
                        foreach (XmlNode node in xml.SelecttNodes("/response/data/workOrders/item"))
                        {
                            XmlNode contentNode = node.SelectSingleNode("content");
                            if (contentNode != null)
                            {
                                sr.Append(_admUi.AdminBoxStart(true));
                                sr.Append(_htmlUi.TableStart("onCenter"));
                                sr.Append(_htmlUi.TrStart());
                                sr.Append(_htmlUi.CreateTd(contentNode.InnerText));
                                sr.Append(_htmlUi.TrFinal());
                                sr.Append(_htmlUi.TableFinal());
                                sr.Append(_admUi.AdminBoxFinal());
                                XmlNode replyNode = node.SelectSingleNode("reply");
                                if (replyNode != null)
                                {
                                    if (!string.IsNullOrEmpty(replyNode.InnerText))
                                    {
                                        sr.Append(_admUi.AdminBoxStart());
                                        sr.Append(_htmlUi.TableStart("onCenter"));
                                        sr.Append(_htmlUi.TrStart());
                                        sr.Append(_htmlUi.CreateTd(replyNode.InnerText));
                                        sr.Append(_htmlUi.TrFinal());
                                        sr.Append(_htmlUi.TableFinal());
                                        sr.Append(_admUi.AdminBoxFinal());
                                    }
                                }
                            }
                        }
                        //商业用户通知和分页
                        sr.Append(_admUi.AdminBoxStart());
                        sr.Append(_htmlUi.TableStart());
                        string msg = xml.GetString("/response/info/msg");
                        if (!string.IsNullOrEmpty(msg))
                        {
                            sr.Append(_htmlUi.TrStart());
                            sr.Append(_htmlUi.CreateTd(msg));
                            sr.Append(_htmlUi.TrFinal());
                        }
                        sr.Append(_htmlUi.TrStart());
                        sr.Append(_htmlUi.CreateTd(new SitePages().Make(rows, currPage, pageSize, "?act=info&amp;mode=business&amp;page={0}")));
                        sr.Append(_htmlUi.TrFinal());
                        sr.Append(_htmlUi.TableFinal());
                        sr.Append(_admUi.AdminBoxFinal());
                    }
                    else
                    {
                        sr.Append(_admUi.AdminBoxStart(true));
                        sr.Append(_htmlUi.TableStart());
                        sr.Append(_htmlUi.TrStart());
                        sr.Append(_htmlUi.CreateTd(_admUi.ErrorBox("您的商业帐户受限，请与官网联系。")));
                        sr.Append(_htmlUi.TrFinal());
                        sr.Append(_htmlUi.TableFinal());
                        sr.Append(_admUi.AdminBoxFinal());
                    }
                }
                catch (Exception err)
                {
                    sr.Append(_admUi.AdminBoxStart(true));
                    sr.Append(_htmlUi.TableStart());
                    sr.Append(_htmlUi.TrStart());
                    sr.Append(_htmlUi.CreateTd(_admUi.ErrorBox("授权中心正在维护，请稍后访问。【" + err.Message + "】")));
                    sr.Append(_htmlUi.TrFinal());
                    sr.Append(_htmlUi.TableFinal());
                    sr.Append(_admUi.AdminBoxFinal());
                }
            }
            else
            {
                sr.Append(_admUi.AdminBoxStart(true));
                sr.Append(_htmlUi.TableStart());
                sr.Append(_htmlUi.TrStart());
                sr.Append(_htmlUi.CreateTd(_admUi.ErrorBox("授权密匙段不存在或不正确。")));
                sr.Append(_htmlUi.TrFinal());
                sr.Append(_htmlUi.TableFinal());
                sr.Append(_admUi.AdminBoxFinal());
            }
            */
            return sr.ToString();
        }
    }
}
