﻿using System;
using System.Text;
using System.Web;
using System.Xml;
using isRoc.Core;
using isRoc.Core.UI;
using isRoc.Data;
using isRoc.Data.Entity;
using isRoc.Logic.Template;

namespace isRoc.Logic.Admin
{
    /// <summary>
    /// 后台管理基类
    /// </summary>
    public class _AdminBase
    {
        private SiteFun _fun = new SiteFun();
        private SiteDat _siteDat = new SiteDat();
        private AdminUI _admUi = new AdminUI();
        private HtmlUI _htmlUi = new HtmlUI();
        private _AdminCookie _ac = new _AdminCookie();

        /// <summary>
        /// 初始化数据库连接
        /// </summary>
        public void InitConn()
        {
            DataBase.Conn = SiteCfg.Conn;
        }

        /// <summary>
        /// 是否已经登录
        /// </summary>
        public bool IsLogin
        {
            get
            {
                string[] adminCookies = _ac.Get();
                UserItem myUser = new UserItem();
                myUser = new UserData().CheckUser(adminCookies[0], _fun.Encryption(adminCookies[1]), false);
                return myUser.ID > 0;
            }
        }

        /// <summary>
        /// 登录窗口
        /// </summary>
        /// <returns>登录代码</returns>
        public string LoginWindow()
        {
            StringBuilder sr = new StringBuilder();
            if (_fun.IsPost)
            {
                UserData userData = new UserData();
                //取得输入的值
                string[] postVal = { _fun.Post("userID"), _fun.Post("pwd"), _fun.Post("vc") };
                UserItem chkUser = userData.CheckUser(postVal[0], _fun.Encryption(postVal[1]), false);
                if (!_siteDat.CheckVerifyCode(postVal[2])) { sr.Append(_admUi.ErrorBox(_siteDat.GetLan("MsgVcErr"))); }
                else
                {
                    if (chkUser.ID == 0) { sr.Append(_admUi.ErrorBox(_siteDat.GetLan("MsgNoFindAdm"))); }
                    else
                    {
                        userData.UpdateUserIpAndTime(chkUser.ID, _fun.GetGuestIP, DateTime.Now);
                        _ac.Set(postVal[0], postVal[1]);
                        HttpContext.Current.Response.Redirect(HttpContext.Current.Request.FilePath);
                    }
                }
            }
            sr.Append(_admUi.AdminBoxStart(true));
            sr.Append(_htmlUi.FormStart());
            sr.Append(_htmlUi.TableStart("autoSize onCenter"));
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("UserId")) + _htmlUi.CreateTd(_htmlUi.Input("userID", 20, "userName", null)));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("Pwd")) + _htmlUi.CreateTd(_htmlUi.PasswordInput("pwd", 20, "password", null)));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh(_siteDat.GetLan("VCode")) + _htmlUi.CreateTd(_htmlUi.Input("vc", 4, null, null) + _htmlUi.Image("Service.aspx?act=verifyCode", _siteDat.GetLan("MsgClickReloadVc"), "javascript:this.src='Service.aspx?act=verifyCode&amp;random='+Math.random();")));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TrStart());
            sr.Append(_htmlUi.CreateTh() + _htmlUi.CreateTd(_htmlUi.SubmitButton(_siteDat.GetLan("BtnLogin")) + _htmlUi.ResetButton()));
            sr.Append(_htmlUi.TrFinal());
            sr.Append(_htmlUi.TableFinal());
            sr.Append(_htmlUi.FormFinal());
            sr.Append(_admUi.AdminBoxFinal());
            return sr.ToString();
        }

        /// <summary>
        /// 取得菜单
        /// </summary>
        public string MenuCode(string xmlContent, string bigClassCode, string classCode)
        {
            StringBuilder sr = new StringBuilder();
            //取得循环元素
            string parentMenu = bigClassCode;
            string menuItem = classCode;
            //开始处理
            XmlDocument menuXml = new XmlDocument();
            menuXml.LoadXml(xmlContent);
            XmlNodeList parents = menuXml.SelectNodes("/root/parent");
            foreach (XmlNode node in parents)
            {
                string itemsCode = string.Empty;
                XmlNodeList items = node.SelectNodes("item");
                foreach (XmlNode itemNode in items)
                {
                    FileTemplate ift = new FileTemplate();
                    ift.LoadCode(menuItem);
                    ift.SetTag("Caption", itemNode.Attributes["name"].Value);
                    ift.SetTag("Link", itemNode.Attributes["link"].Value);
                    if (string.IsNullOrEmpty(itemNode.Attributes["icon"].Value)) { ift.SetTag("Icon", string.Empty); }
                    else { ift.SetTag("Icon", string.Format("<img src=\"Common/Images/Icons/{0}\" width=\"16\" height=\"16\"/>", itemNode.Attributes["icon"].Value)); }
                    itemsCode += ift.Code;
                }
                //全局处理
                FileTemplate ft = new FileTemplate();
                ft.LoadCode(parentMenu);
                ft.SetTag("Caption", node.Attributes["name"].Value);
                ft.SetTag("Rel", node.Attributes["rel"].Value);
                ft.SetTag("ID", node.Attributes["id"].Value);
                ft.SetTag("ItemList", itemsCode);
                sr.Append(ft.Code);
            }
            return sr.ToString();
        }
    }
}
