﻿using System;
using System.IO;
using isRoc.Core;
using isRoc.Logic.Template;

namespace isRoc.Logic
{
    /// <summary>
    /// 错误处理类
    /// </summary>
    public class MyError : IMyError
    {
        private string Pre(string text)
        {
            if (!string.IsNullOrEmpty(text))
            {
                text = text.Replace("\n", "<br/>").Replace("  ", "　");
            }
            return text;
        }

        /// <summary>
        /// 打印错误内容
        /// </summary>
        /// <param name="err">错误对象</param>
        public void PrintError(Exception err)
        {
            if (string.IsNullOrEmpty(err.HelpLink)) { err.HelpLink = SiteCfg.WebSite; }
            FileTemplate tpl = new FileTemplate();
            tpl.LoadFile(Path.Combine(SiteCfg.Router, "Common/Theme/Error.htm"));
            tpl.SetTag("HelpLink", Pre(err.HelpLink));
            tpl.SetTag("Message", Pre(err.Message));
            tpl.SetTag("Source", Pre(err.Source));
            tpl.SetTag("StackTrace", Pre(err.StackTrace));
            tpl.Print();
        }
    }
}
