﻿using System.Web;
using isRoc.Core;
using isRoc.Data;
using isRoc.Data.Entity;
using isRoc.Logic.Web;

namespace isRoc.Logic.Service
{
    /// <summary>
    /// 评论处理类
    /// </summary>
    public class ServiceComment
    {
        private SiteFun _fun = new SiteFun();
        private SiteDat _siteDat = new SiteDat();
        private _WebCookie _wc = new _WebCookie();

        /// <summary>
        /// 向浏览器打印代码
        /// </summary>
        public void OutWrite()
        {
            switch (_fun.Query("mode"))
            {
                case "post": { OutWritePost(); break; }
                default: { OutWriteList(); break; }
            }
        }

        /// <summary>
        /// 发表评论过程
        /// </summary>
        private void OutWritePost()
        {
            string msg = string.Empty;
            SettingItem setting = new SettingData().GetSetting();
            //取值和设置
            PostItem postItem = new PostData().GetPost(_fun.ToInt(_fun.Query("artId")));
            CommentItem postVal = new CommentItem();
            postVal.PostID = postItem.ID;
            postVal.Author = _fun.Post("author");
            postVal.Mail = _fun.Post("mail");
            postVal.URL = _fun.FormatUrl(_fun.Post("url"));
            postVal.Content = _fun.Post("content");
            postVal.Verify = postItem.AutoVerifyComment;
            //设置Cookie
            _wc.Set(postVal.Author, postVal.Mail, postVal.URL);
            //开始判断并发布
            if (postItem.ID > 0 && postItem.SwitchComment)
            {
                if (string.IsNullOrEmpty(postVal.Author)) { msg = _siteDat.GetLan("MsgNoNickName"); }
                else
                {
                    if (string.IsNullOrEmpty(postVal.Mail)) { msg = _siteDat.GetLan("MsgNoMail"); }
                    else
                    {
                        if (string.IsNullOrEmpty(postVal.Content)) { msg = _siteDat.GetLan("MsgNoContent"); }
                        else
                        {
                            if (postVal.Content.Length > 255) { msg = _siteDat.GetLan("MsgContLenMax"); }
                            else
                            {
                                bool haveFilter = false;
                                string[] filters = setting.Basic.Filter.Split(',');
                                foreach (string filter in filters)
                                {
                                    if (postVal.Content.Contains(filter)) { haveFilter = true; break; }
                                }
                                if (haveFilter) { msg = _siteDat.GetLan("MsgFilterTxt"); }
                                else
                                {
                                    new CommentData().InsertComment(postVal);
                                    SiteCache cache = new SiteCache();
                                    _siteDat.RemoveDat(cache.NewComment);
                                    _siteDat.RemoveDat(cache.RandomPost);
                                    _siteDat.ClearDat(string.Format("Comments-{0}-", postItem.ID));
                                }
                            }
                        }
                    }
                }
            }
            else { msg = _siteDat.GetLan("MsgArtNotExistsOrLocked"); }
            PrintList(msg, postItem.ID);
        }

        /// <summary>
        /// 打印评论列表
        /// </summary>
        private void OutWriteList()
        {
            int artID = _fun.ToInt(_fun.Query("artId"));
            PrintList(null, artID);
        }

        /// <summary>
        /// 取得评论列表
        /// </summary>
        /// <param name="msg">返回消息</param>
        /// <param name="artID">文章编号</param>
        private void PrintList(string msg, int artID)
        {
            //初始化引擎
            SettingItem setting = new SettingData().GetSetting();
            int page = _fun.ToInt(_fun.Query("page"));
            int pageSize = setting.Parameter.CommentNum;
            string listHtml = new CommentUI().GetCommentList(artID, page, pageSize);
            string xmlInner = string.Format("\t\t<html>{0}</html>", _fun.CDATA(listHtml));
            string xml = new _ServiceBaseXml().OutBaseXml(msg, xmlInner);
            //输出
            HttpContext.Current.Response.ContentType = "text/xml";
            HttpContext.Current.Response.Write(xml);
        }
    }
}
