﻿using System;
using System.IO;
using System.Text;
using System.Web;
using isRoc.Core;
using isRoc.Data;
using isRoc.Data.Entity;
using isRoc.Logic.Admin;

namespace isRoc.Logic.Service
{
    /// <summary>
    /// 文章异步处理类
    /// </summary>
    public class ServicePost
    {
        private SiteFun _fun = new SiteFun();
        private SiteDat _siteDat = new SiteDat();
        private _AdminCookie _ac = new _AdminCookie();

        /// <summary>
        /// 取得密码文章内容
        /// </summary>
        public void OutWriteOfPasswordArticle()
        {
            //初始化引擎
            string msg = string.Empty;
            int error = 1;
            string cont = string.Empty;
            int artId = _fun.ToInt(_fun.Post("artId"));
            //0-阐述,1-内容
            int result = _fun.ToInt(_fun.Post("isContent"));
            PostItem art = new PostData().GetPost(artId);
            if (art.ID > 0 && art.Show)
            {
                if (art.Password == _fun.Post("pwd"))
                {
                    error = 0;
                    cont = result == 0 ? art.Explain : art.Content;
                }
                else { msg = _siteDat.GetLan("MsgPwdErr"); }
            }
            else { msg = _siteDat.GetLan("MsgArtNotExists"); }
            StringBuilder xml = new StringBuilder();
            xml.AppendFormat("\t\t<error>{0}</error>\n", error);
            xml.AppendFormat("\t\t<result>{0}</result>\n", _fun.CDATA(cont));
            xml.Append(new _ServiceBaseXml().OutBaseXml(msg, xml.ToString()));
            HttpContext.Current.Response.ContentType = "text/xml";
            HttpContext.Current.Response.Write(xml);
        }

        /// <summary>
        /// 投票
        /// </summary>
        public void OutWriteVote()
        {
            int artId = _fun.ToInt(_fun.Post("artId"));
            HttpContext.Current.Response.Write(new PostData().AddPostVote(artId));
        }

        /// <summary>
        /// 取得未保存文章内容
        /// </summary>
        public void OutRePostContent()
        {
            //开始
            string content = string.Empty;
            string[] usrInfo = _ac.Get();
            if (new UserData().CheckUser(usrInfo[0], _fun.Encryption(usrInfo[1]), false).ID > 0)
            {
                try
                {
                    string filePath = Path.Combine(SiteCfg.Router, "Common/Temp/post_cache.tmp");
                    content = File.ReadAllText(filePath);
                    //File.Delete(filePath);
                }
                catch { }
            }
            HttpContext.Current.Response.ContentType = "text/xml";
            HttpContext.Current.Response.Write(new _ServiceBaseXml().OutBaseXml(null, string.Format("\t\t<result>{0}</result>", _fun.CDATA(content))));
        }

        /// <summary>
        /// 自动保存内容
        /// </summary>
        public void OutAutoSavePost()
        {
            //开始
            string msg = string.Empty;
            string[] usrInfo = _ac.Get();
            if (new UserData().CheckUser(usrInfo[0], _fun.Encryption(usrInfo[1]), false).ID == 0) { msg = _siteDat.GetLan("MsgNotAnAdm"); }
            else
            {
                string content = _fun.Post("content");
                try
                {
                    File.WriteAllText(Path.Combine(SiteCfg.Router, "Common/Temp/post_cache.tmp"), content);
                    msg = _siteDat.GetLan("MsgSaveSucc");
                }
                catch (Exception err) { msg = err.Message; }
            }
            HttpContext.Current.Response.ContentType = "text/xml";
            HttpContext.Current.Response.Write(new _ServiceBaseXml().OutBaseXml(msg, null));
        }
    }
}
