﻿using System.Text;
using System.Web;
using isRoc.Core;
using isRoc.Data;
using isRoc.Data.Entity;

namespace isRoc.Logic.Service
{
    /// <summary>
    /// RSS 处理类
    /// </summary>
    public class ServiceRss
    {
        private SiteFun _fun = new SiteFun();
        private SiteDat _siteDat = new SiteDat();

        /// <summary>
        /// 写出引用通告处理状态
        /// </summary>
        public void OutWrite()
        {
            //取值
            int cid = _fun.ToInt(_fun.Query("cid"));
            SettingItem set = new SettingData().GetSetting();
            //处理和返回
            StringBuilder xml = new StringBuilder();
            xml.Append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
            xml.Append("<rss version=\"2.0\">\n");
            xml.Append("<channel>\n");
            xml.AppendFormat("<title>{0}</title>\n", _fun.CDATA(set.Basic.Name));
            xml.AppendFormat("<link>{0}</link>\n", _fun.CDATA(set.Basic.URL));
            xml.AppendFormat("<description>{0}</description>\n", _fun.CDATA(set.Basic.Intro));
            xml.AppendFormat("<language>{0}</language>\n", _fun.CDATA(set.Basic.Language));
            xml.AppendFormat("<copyright>{0}</copyright>\n", _fun.CDATA("Copyright " + set.Basic.Name));
            xml.AppendFormat("<webMaster>{0}</webMaster>\n", _fun.CDATA(set.Basic.Mail));
            xml.AppendFormat("<generator>{0}</generator>\n", _fun.CDATA(SiteCfg.SystemVersionFull));
            xml.Append("<image>\n");
            xml.AppendFormat("\t<title>{0}</title>\n", _fun.CDATA(set.Basic.Name));
            xml.AppendFormat("\t<url>{0}</url>\n", _fun.CDATA(set.Basic.URL + "Common/Images/Logo.png"));
            xml.AppendFormat("\t<link>{0}</link>\n", _fun.CDATA(set.Basic.URL));
            xml.AppendFormat("\t<description>{0}</description>\n", _fun.CDATA(set.Basic.Intro));
            xml.Append("</image>\n");
            foreach (PostItem vItem in new PostData().SelectPost(cid, null, null, 1, set.Parameter.RssNum, 0, "A", false))
            {
                xml.Append("<item>\n");
                xml.AppendFormat("\t<link>{0}</link>\n", _fun.CDATA(string.Format(SitePath.ArticleLinkFormat, set.Basic.URL, vItem.Local)));
                xml.AppendFormat("\t<title>{0}</title>\n", _fun.CDATA(vItem.Title));
                xml.AppendFormat("\t<author>{0}</author>\n", _fun.CDATA(vItem.Author));
                xml.AppendFormat("\t<category>{0}</category>\n", _fun.CDATA(new ColumnData().GetColumn(vItem.ColumnID).Name));
                xml.AppendFormat("\t<pubDate>{0}</pubDate>\n", vItem.Publish);
                xml.AppendFormat("\t<guid>{0}</guid>\n", _fun.CDATA(string.Format(SitePath.ArticleLinkFormat, set.Basic.URL, vItem.Local)));
                xml.AppendFormat("\t<description>{0}</description>\n", _fun.CDATA(string.IsNullOrEmpty(vItem.Password) ? (set.Parameter.RssMode == 0 ? vItem.Explain : vItem.Content) : _siteDat.GetLan("MsgEncContent")));
                xml.Append("</item>\n");
            }
            xml.Append("</channel>\n");
            xml.Append("</rss>");
            HttpContext.Current.Response.ContentType = "text/xml";
            HttpContext.Current.Response.Write(xml);
        }
    }
}
