﻿using System.Text;
using System.Web;
using isRoc.Core;
using isRoc.Data;
using isRoc.Data.Entity;
using isRoc.Logic.Admin;

namespace isRoc.Logic.Service
{
    /// <summary>
    /// 获取相关标签类
    /// </summary>
    public class ServiceTag
    {
        private SiteFun _fun = new SiteFun();
        private _AdminCookie _ac = new _AdminCookie();

        /// <summary>
        /// 获取匹配的关键字列表
        /// </summary>
        /// <returns>返回匹配成功的关键字列表</returns>
        public void GetMatchTags()
        {
            StringBuilder result = new StringBuilder();
            string[] usrInfo = _ac.Get();
            if (new UserData().CheckUser(usrInfo[0], _fun.Encryption(usrInfo[1]), false).ID > 0)
            {
                TagList list = new TagData().SelectTag(1, 200, "[PostCount]", "DESC");
                foreach (TagItem vItem in list)
                {
                    result.AppendFormat("<a rel=\"tags\">{0}</a>\r\n", vItem.Key);
                }
            }
            HttpContext.Current.Response.ContentType = "text/xml";
            HttpContext.Current.Response.Write(new _ServiceBaseXml().OutBaseXml(null, string.Format("\t\t<result>{0}</result>", _fun.CDATA(result.ToString()))));
        }
    }
}
