﻿using System.Text;
using System.Web;
using isRoc.Core;
using isRoc.Data;
using isRoc.Data.Entity;

namespace isRoc.Logic.Service
{
    /// <summary>
    /// 引用通告接收类
    /// </summary>
    public class ServiceTrackback
    {
        private SiteFun _fun = new SiteFun();
        private SiteDat _siteDat = new SiteDat();

        /// <summary>
        /// 写出引用通告处理状态
        /// </summary>
        public void OutWrite()
        {
            //取值
            PostItem postItem = new PostData().GetPost(_fun.ToInt(_fun.Query("id")));
            CommentItem value = new CommentItem();
            value.PostID = postItem.ID;
            value.Author = _fun.Post("blog_name");
            value.Content = _fun.Post("excerpt");
            value.Title = _fun.Post("title");
            value.Trackback = true;
            value.URL = _fun.FormatUrl(_fun.Post("url"));
            value.Verify = postItem.AutoVerifyTrackback;
            //错误状态和返回信息
            int error = 1;
            string msg = string.Empty;
            if (postItem.ID > 0 && postItem.Show)
            {
                if (postItem.SwitchTrackback)
                {
                    if (string.IsNullOrEmpty(value.Content)) { msg = _siteDat.GetLan("MsgNoContent"); }
                    else
                    {
                        if (value.Content.Length > 255) { value.Content = value.Content.Substring(0, 252) + "..."; }
                        if (string.IsNullOrEmpty(value.Author)) { msg = _siteDat.GetLan("MsgNoName"); }
                        else
                        {
                            bool haveFilter = false;
                            string[] filters = new SettingData().GetSetting().Basic.Filter.Split(',');
                            foreach (string filter in filters)
                            {
                                if (value.Content.Contains(filter)) { haveFilter = true; }
                            }
                            if (haveFilter) { msg = _siteDat.GetLan("MsgFilterTxt"); }
                            else
                            {
                                new CommentData().InsertComment(value);
                                msg = _siteDat.GetLan("MsgSaveSucc");
                                error = 0;
                            }
                        }
                    }
                }
                else { msg = _siteDat.GetLan("MsgArtAllowedSendTb"); }
            }
            else { msg = _siteDat.GetLan("MsgArtNotExists"); }
            //处理和返回
            StringBuilder xml = new StringBuilder();
            xml.Append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
            xml.Append("<response>\n");
            xml.AppendFormat("\t<error>0</error>\n", error);
            xml.AppendFormat("\t<message>{0}</message>\n", _fun.CDATA(msg));
            xml.Append("</response>");
            HttpContext.Current.Response.ContentType = "text/xml";
            HttpContext.Current.Response.Write(xml);
        }
    }
}
