﻿using System.Diagnostics;
using System.IO;
using System.Text;
using System.Web;
using System.Xml;
using System.Xml.Xsl;
using isRoc.Core;

namespace isRoc.Logic.Template
{
    /// <summary>
    /// XSLT 模板引擎类
    /// </summary>
    public class XsltTemplate
    {
        private string _code;
        private string _path;
        private string _xml;
        private XsltArgumentList _argList;
        Stopwatch watch = new Stopwatch();

        /// <summary>
        /// 析构函数
        /// </summary>
        public XsltTemplate()
        {
            watch.Start();
            _argList = new XsltArgumentList();
            _argList.AddExtensionObject("roclog:function", new _ALFun());
            _argList.AddExtensionObject("sys:fun", new _ALFun());
            //扩展部分
            foreach (object type in new SiteExpand().GetTypes(typeof(ITemplateFun).FullName))
            {
                ITemplateFun iae = ((ITemplateFun)type);
                _argList.AddExtensionObject(string.Format("expand:{0}", iae.URI), iae);
            }
        }

        /// <summary>
        /// 析构函数
        /// </summary>
        /// <param name="path">模板文件地址</param>
        public void LoadXslt(string path)
        {
            this._path = path;
        }

        /// <summary>
        /// 从文本XML绑定数据
        /// </summary>
        /// <param name="xmlStr">XML内容</param>
        public void BindXml(string xmlStr)
        {
            _xml = xmlStr;
            XslTransform xsl = new XslTransform();
            //XslCompiledTransform xsl = new XslCompiledTransform(false);
            xsl.Load(_path);
            //处理部分
            XmlDocument xmlDoc = new XmlDocument();
            xmlDoc.LoadXml(xmlStr);
            StringBuilder strBuilder = new StringBuilder();
            xsl.Transform(xmlDoc, _argList, new StringWriter(strBuilder));
            _code = strBuilder.ToString();
        }

        /// <summary>
        /// 强制设置输出类型
        /// </summary>
        public void SetContentTypeHtml()
        {
            HttpContext.Current.Response.ContentType = "text/html";
        }

        /// <summary>
        /// 强制设置输出类型
        /// </summary>
        public void SetContentTypeXml()
        {
            HttpContext.Current.Response.ContentType = "text/xml";
        }

        /// <summary>
        /// 取得当前代码
        /// </summary>
        public string Code
        {
            get { return this._code; }
        }

        /// <summary>
        /// 取得当前XML代码
        /// </summary>
        public string XML
        {
            get { return this._xml; }
        }

        /// <summary>
        /// 直接向浏览器打印当前代码（已包含转换输出类型）
        /// </summary>
        /// <param name="isXml">是否是XML文件</param>
        public void Print(bool isXml)
        {
            if (isXml) { SetContentTypeXml(); } else { SetContentTypeHtml(); }
            string debug = string.Empty;
            if (SiteCfg.Debug)
            {
                debug += "<!--调试器-->\n<div class=\"sysDebugXMLBox\"><div class=\"sysDebugXMLBoxTop\">XML</div><div class=\"sysDebugXMLBoxContent\"><pre class=\"sysDebugXML\">" + HttpContext.Current.Server.HtmlEncode(this._xml) + "</pre></div></div>\n";
                debug += "<div class=\"sysDebugTimer\"><div class=\"sysDebugTimerInner\">Timer:<b>" + watch.Elapsed.TotalSeconds.ToString("0.0000") + "</b>s</div></div>\n<!--调试完毕-->\n";
            }
            _code = _code.Replace("<roclog.debug />", debug).Replace("<sys.debug />", debug);
            HttpContext.Current.Response.Write(_code);
        }

        /// <summary>
        /// 直接向浏览器打印当前代码（已包含转换输出类型）
        /// </summary>
        public void Print()
        {
            Print(false);
        }
    }
}
