﻿using System;
using System.IO;
using System.Text;
using isRoc.Core;
using isRoc.Data;
using isRoc.Data.Entity;

namespace isRoc.Logic.Web
{
    /// <summary>
    /// 友情链接展示类
    /// </summary>
    public class WebFellows
    {
        private SiteFun _fun = new SiteFun();
        private SiteDat _siteDat = new SiteDat();

        private SettingItem _setting;
        private string _theme;

        /// <summary>
        /// 析构过程
        /// </summary>
        public WebFellows()
        {
            SettingData setData = new SettingData();
            this._setting = setData.GetSetting();
            this._theme = setData.GetTheme;
        }

        /// <summary>
        /// 获取网站配置
        /// </summary>
        public SettingItem OutSetting
        {
            get
            {
                return this._setting;
            }
        }

        /// <summary>
        /// 获取网站主题
        /// </summary>
        public string OutTheme
        {
            get
            {
                return this._theme;
            }
        }

        /// <summary>
        /// 向浏览器打印完整XML内容
        /// </summary>
        public string OutWrite()
        {
            //本页XML处理
            StringBuilder xml = new StringBuilder();
            xml.Append("\t\t<fellows>\n");
            DataList<FellowItem> fellows = new FellowData().SelectFellow(1, int.MaxValue, false, false);
            foreach (FellowItem vItem in fellows)
            {
                xml.Append("\t\t\t<item>\n");
                xml.AppendFormat("\t\t\t\t<id>{0}</id>\n", vItem.ID);
                xml.AppendFormat("\t\t\t\t<name>{0}</name>\n", _fun.CDATA(vItem.Name));
                xml.AppendFormat("\t\t\t\t<url>{0}</url>\n", _fun.CDATA(vItem.URL));
                xml.AppendFormat("\t\t\t\t<logo>{0}</logo>\n", _fun.CDATA(vItem.Logo));
                xml.AppendFormat("\t\t\t\t<explain>{0}</explain>\n", _fun.CDATA(vItem.Explain));
                xml.AppendFormat("\t\t\t\t<style>{0}</style>\n", _fun.CDATA(vItem.Style));
                xml.Append("\t\t\t</item>\n");
            }
            xml.Append("\t\t</fellows>\n");
            //绑定XML并写出
            return new _WebBaseXml().OutBaseXml(_siteDat.GetLan("Fellow"), xml.ToString());
        }
    }
}
