﻿using System;
using System.IO;
using System.Text;
using isRoc.Core;
using isRoc.Data;
using isRoc.Data.Entity;

namespace isRoc.Logic.Web
{
    /// <summary>
    /// 独立页面展示类
    /// </summary>
    public class WebPage
    {
        private SiteFun _fun = new SiteFun();
        private SettingItem _setting;
        private string _theme;

        /// <summary>
        /// 析构过程
        /// </summary>
        public WebPage()
        {
            SettingData setData = new SettingData();
            this._setting = setData.GetSetting();
            this._theme = setData.GetTheme;
        }

        /// <summary>
        /// 获取网站配置
        /// </summary>
        public SettingItem OutSetting
        {
            get
            {
                return this._setting;
            }
        }

        /// <summary>
        /// 获取网站主题
        /// </summary>
        public string OutTheme
        {
            get
            {
                return this._theme;
            }
        }
        /// <summary>
        /// 向浏览器完整XML内容
        /// </summary>
        public string OutWrite(int id, string local)
        {
            SettingItem setting = this._setting;
            SiteDat siteDat = new SiteDat();
            SiteCache siteCache = new SiteCache();
            //获取页面数据
            PostItem pg = new PostItem();
            if (id > 0)
            {
                if (siteDat.GetDat(string.Format(siteCache.PostFormat, id)) == null)
                {
                    siteDat.SetDat(string.Format(siteCache.PostFormat, id), new PostData().GetPost(id));
                }
                pg = (PostItem)siteDat.GetDat(string.Format(siteCache.PostFormat, id));
            }
            else
            {
                if (siteDat.GetDat(string.Format(siteCache.PostFormat, local)) == null)
                {
                    siteDat.SetDat(string.Format(siteCache.PostFormat, local), new PostData().GetPost(local));
                }
                pg = (PostItem)siteDat.GetDat(string.Format(siteCache.PostFormat, local));
            }
            //本页XML处理
            StringBuilder xml = new StringBuilder();
            xml.Append("\t\t<page>\n");
            xml.AppendFormat("\t\t\t<link>{0}</link>\n", _fun.CDATA(string.Format(SitePath.PageLinkFormat, SiteCfg.Path, _fun.UrlEncode(pg.Local))));
            xml.AppendFormat("\t\t\t<id>{0}</id>\n", pg.ID);
            xml.AppendFormat("\t\t\t<local>{0}</local>\n", _fun.CDATA(pg.Local));
            xml.AppendFormat("\t\t\t<title>{0}</title>\n", _fun.CDATA(pg.Title));
            xml.AppendFormat("\t\t\t<content>{0}</content>\n", _fun.CDATA(pg.Content));
            xml.AppendFormat("\t\t\t<publish>{0}</publish>\n", pg.Publish);
            xml.Append("\t\t</page>\n");
            //绑定XML并写出
            string title = string.Empty;
            if (pg.ID > 0) { title = string.Format("{0} - {1}", pg.Title, setting.Basic.Name); }
            return new _WebBaseXml().OutBaseXml(title, xml.ToString());
        }
    }
}
