﻿using System.Text;
using System.Web;
using isRoc.Core;
using isRoc.Data;
using isRoc.Data.Entity;

namespace isRoc.Logic.Web
{
    /// <summary>
    /// 前台数据提供基类
    /// </summary>
    public class _WebBaseXml
    {
        private SiteFun _fun = new SiteFun();
        private SiteDat _siteDat = new SiteDat();

        /// <summary>
        /// 获取 XML 内容
        /// </summary>
        /// <param name="title">标题</param>
        /// <param name="thisXmlText">本页单独的 XML 内容</param>
        /// <returns>返回完整的 XML 内容</returns>
        public string OutBaseXml(string title, string thisXmlText)
        {
            SiteCache cache = new SiteCache();
            //开始
            StringBuilder xml = new StringBuilder();
            xml.Append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
            xml.Append("<ui>\n");
            //配置数据
            xml.Append("\t<config>\n");
            xml.AppendFormat("\t\t<path>{0}</path>\n", _fun.CDATA(SiteCfg.Path));
            xml.AppendFormat("\t\t<system>{0}</system>\n", _fun.CDATA(SiteCfg.System));
            xml.AppendFormat("\t\t<version>{0}</version>\n", _fun.CDATA(SiteCfg.Version));
            xml.AppendFormat("\t\t<fullVersion>{0}</fullVersion>\n", _fun.CDATA(SiteCfg.SystemVersionFull));
            xml.AppendFormat("\t\t<powered>{0}</powered>\n", _fun.CDATA(SiteCfg.Powered));
            xml.Append("\t</config>\n");
            //设置数据
            SettingData setData = new SettingData();
            if (_siteDat.GetDat(cache.Setting) == null)
            {
                _siteDat.SetDat(cache.Setting, setData.GetSetting());
            }
            SettingItem setting = (SettingItem)_siteDat.GetDat(cache.Setting);
            string theme = setData.GetTheme;
            xml.Append("\t<setting>\n");
            xml.AppendFormat("\t\t<theme>{0}</theme>\n", _fun.CDATA(theme));
            xml.AppendFormat("\t\t<language>{0}</language>\n", _fun.CDATA(setting.Basic.Language));
            xml.AppendFormat("\t\t<name>{0}</name>\n", _fun.CDATA(setting.Basic.Name));
            xml.AppendFormat("\t\t<url>{0}</url>\n", _fun.CDATA(setting.Basic.URL));
            xml.AppendFormat("\t\t<intro>{0}</intro>\n", _fun.CDATA(setting.Basic.Intro));
            xml.AppendFormat("\t\t<keywords>{0}</keywords>\n", _fun.CDATA(setting.Basic.Keywords));
            xml.AppendFormat("\t\t<icp>{0}</icp>\n", _fun.CDATA(setting.Basic.ICP));
            xml.AppendFormat("\t\t<affiche>{0}</affiche>\n", _fun.CDATA(setting.Basic.Affiche));
            xml.Append("\t</setting>\n");
            //导航
            xml.Append("\t<navigations>\n");
            xml.Append("\t\t<item>\n");
            xml.AppendFormat("\t\t\t<link>{0}</link>\n", _fun.CDATA(SiteCfg.Path));
            xml.AppendFormat("\t\t\t<name>{0}</name>\n", _fun.CDATA(_siteDat.GetLan("HomePage")));
            xml.AppendFormat("\t\t\t<intro>{0}</intro>\n", _fun.CDATA(setting.Basic.Name));
            xml.AppendFormat("\t\t\t<target>{0}</target>\n", _fun.CDATA("_self"));
            xml.AppendFormat("\t\t\t<current>{0}</current>\n", string.IsNullOrEmpty(HttpContext.Current.Request.Url.Query));
            xml.Append("\t\t</item>\n");
            if (_siteDat.GetDat(cache.Navigation) == null)
            {
                _siteDat.SetDat(cache.Navigation, new ColumnData().SelectColumn(1, -1, false));
            }
            foreach (ColumnItem vItem in (DataList<ColumnItem>)_siteDat.GetDat(cache.Navigation))
            {
                string itemLink = string.Format(SitePath.CategoryLinkFormat, SiteCfg.Path, _fun.UrlEncode(vItem.Local));
                xml.Append("\t\t<item>\n");
                xml.AppendFormat("\t\t\t<link>{0}</link>\n", _fun.CDATA(vItem.Jump ? vItem.JumpUrl : itemLink));
                xml.AppendFormat("\t\t\t<name>{0}</name>\n", _fun.CDATA(vItem.Name));
                xml.AppendFormat("\t\t\t<intro>{0}</intro>\n", _fun.CDATA(vItem.Intro));
                xml.AppendFormat("\t\t\t<target>{0}</target>\n", _fun.CDATA(vItem.Target));
                xml.AppendFormat("\t\t\t<current>{0}</current>\n", string.Format((_fun.ToInt(vItem.Local) > 0 ? "?act=defa&cid={0}" : "?act=defa&clocal={1}"), vItem.ID, _fun.UrlEncode(vItem.Local)).ToLower() == HttpContext.Current.Request.Url.Query.ToLower());
                xml.Append("\t\t</item>\n");
            }
            xml.Append("\t</navigations>\n");
            //分类
            xml.Append("\t<categorys>\n");
            if (_siteDat.GetDat(cache.Column) == null)
            {
                _siteDat.SetDat(cache.Column, new ColumnData().SelectColumn(-1, 0, false));
            }
            foreach (ColumnItem vItem in (DataList<ColumnItem>)_siteDat.GetDat(cache.Column))
            {
                xml.Append("\t\t<item>\n");
                xml.AppendFormat("\t\t\t<link>{0}</link>\n", _fun.CDATA(string.Format(SitePath.CategoryLinkFormat, SiteCfg.Path, _fun.UrlEncode(vItem.Local))));
                xml.AppendFormat("\t\t\t<id>{0}</id>\n", vItem.ID);
                xml.AppendFormat("\t\t\t<name>{0}</name>\n", _fun.CDATA(vItem.Name));
                xml.AppendFormat("\t\t\t<intro>{0}</intro>\n", _fun.CDATA(vItem.Intro));
                xml.AppendFormat("\t\t\t<local>{0}</local>\n", _fun.CDATA(vItem.Local));
                xml.AppendFormat("\t\t\t<postCount>{0}</postCount>\n", vItem.PostCount);
                xml.Append("\t\t</item>\n");
            }
            xml.Append("\t</categorys>\n");
            //随机文章
            xml.Append("\t<randomArticles>\n");
            if (_siteDat.GetDat(cache.RandomPost) == null)
            {
                _siteDat.SetDat(cache.RandomPost, new PostData().SelectPost(0, null, null, 1, setting.Parameter.AppendRandomArticleNum, 4, "A", false));
            }
            foreach (PostItem vItem in (DataList<PostItem>)_siteDat.GetDat(cache.RandomPost))
            {
                ColumnItem columnItem = new ColumnItem();
                if (_siteDat.GetDat(string.Format(cache.ColumnFormat, vItem.ColumnID)) == null)
                {
                    _siteDat.SetDat(string.Format(cache.ColumnFormat, vItem.ColumnID), new ColumnData().GetColumn(vItem.ColumnID));
                }
                columnItem = (ColumnItem)_siteDat.GetDat(string.Format(cache.ColumnFormat, vItem.ColumnID));
                xml.Append("\t\t<item>\n");
                xml.AppendFormat("\t\t\t<link>{0}</link>\n", _fun.CDATA(string.Format(SitePath.ArticleLinkFormat, SiteCfg.Path, _fun.UrlEncode(vItem.Local))));
                xml.AppendFormat("\t\t\t<id>{0}</id>\n", vItem.ID);
                xml.AppendFormat("\t\t\t<title>{0}</title>\n", _fun.CDATA(vItem.Title));
                xml.AppendFormat("\t\t\t<tags>{0}</tags>\n", _fun.CDATA(vItem.Tags));
                xml.AppendFormat("\t\t\t<local>{0}</local>\n", _fun.CDATA(vItem.Local));
                xml.AppendFormat("\t\t\t<author>{0}</author>\n", _fun.CDATA(vItem.Author));
                xml.AppendFormat("\t\t\t<postCount>{0}</postCount>\n", vItem.PostCount);
                xml.AppendFormat("\t\t\t<reader>{0}</reader>\n", vItem.Reader);
                xml.AppendFormat("\t\t\t<vote>{0}</vote>\n", vItem.Vote);
                xml.AppendFormat("\t\t\t<fine>{0}</fine>\n", vItem.Fine);
                xml.AppendFormat("\t\t\t<publish>{0}</publish>\n", vItem.Publish);
                xml.Append("\t\t\t<category>\n");
                xml.AppendFormat("\t\t\t\t<link>{0}</link>\n", _fun.CDATA(string.Format(SitePath.CategoryLinkFormat, SiteCfg.Path, _fun.UrlEncode(columnItem.Local))));
                xml.AppendFormat("\t\t\t\t<id>{0}</id>\n", columnItem.ID);
                xml.AppendFormat("\t\t\t\t<local>{0}</local>\n", _fun.CDATA(columnItem.Local));
                xml.AppendFormat("\t\t\t\t<name>{0}</name>\n", _fun.CDATA(columnItem.Name));
                xml.AppendFormat("\t\t\t\t<intro>{0}</intro>\n", _fun.CDATA(columnItem.Intro));
                xml.AppendFormat("\t\t\t\t<postCount>{0}</postCount>\n", columnItem.PostCount);
                xml.Append("\t\t\t</category>\n");
                xml.Append("\t\t</item>\n");
            }
            xml.Append("\t</randomArticles>\n");
            //热门文章
            xml.Append("\t<hotArticles>\n");
            if (_siteDat.GetDat(cache.HotPost) == null)
            {
                _siteDat.SetDat(cache.HotPost, new PostData().SelectPost(0, null, null, 1, setting.Parameter.AppendHotArticleNum, 2, "A", false));
            }
            foreach (PostItem vItem in (DataList<PostItem>)_siteDat.GetDat(cache.HotPost))
            {
                ColumnItem columnItem = new ColumnItem();
                if (_siteDat.GetDat(string.Format(cache.ColumnFormat, vItem.ColumnID)) == null)
                {
                    _siteDat.SetDat(string.Format(cache.ColumnFormat, vItem.ColumnID), new ColumnData().GetColumn(vItem.ColumnID));
                }
                columnItem = (ColumnItem)_siteDat.GetDat(string.Format(cache.ColumnFormat, vItem.ColumnID));
                xml.Append("\t\t<item>\n");
                xml.AppendFormat("\t\t\t<link>{0}</link>\n", _fun.CDATA(string.Format(SitePath.ArticleLinkFormat, SiteCfg.Path, _fun.UrlEncode(vItem.Local))));
                xml.AppendFormat("\t\t\t<id>{0}</id>\n", vItem.ID);
                xml.AppendFormat("\t\t\t<title>{0}</title>\n", _fun.CDATA(vItem.Title));
                xml.AppendFormat("\t\t\t<tags>{0}</tags>\n", _fun.CDATA(vItem.Tags));
                xml.AppendFormat("\t\t\t<local>{0}</local>\n", _fun.CDATA(vItem.Local));
                xml.AppendFormat("\t\t\t<author>{0}</author>\n", _fun.CDATA(vItem.Author));
                xml.AppendFormat("\t\t\t<postCount>{0}</postCount>\n", vItem.PostCount);
                xml.AppendFormat("\t\t\t<reader>{0}</reader>\n", vItem.Reader);
                xml.AppendFormat("\t\t\t<vote>{0}</vote>\n", vItem.Vote);
                xml.AppendFormat("\t\t\t<fine>{0}</fine>\n", vItem.Fine);
                xml.AppendFormat("\t\t\t<publish>{0}</publish>\n", vItem.Publish);
                xml.Append("\t\t\t<category>\n");
                xml.AppendFormat("\t\t\t\t<link>{0}</link>\n", _fun.CDATA(string.Format(SitePath.CategoryLinkFormat, SiteCfg.Path, _fun.UrlEncode(columnItem.Local))));
                xml.AppendFormat("\t\t\t\t<id>{0}</id>\n", columnItem.ID);
                xml.AppendFormat("\t\t\t\t<local>{0}</local>\n", _fun.CDATA(columnItem.Local));
                xml.AppendFormat("\t\t\t\t<name>{0}</name>\n", _fun.CDATA(columnItem.Name));
                xml.AppendFormat("\t\t\t\t<intro>{0}</intro>\n", _fun.CDATA(columnItem.Intro));
                xml.AppendFormat("\t\t\t\t<postCount>{0}</postCount>\n", columnItem.PostCount);
                xml.Append("\t\t\t</category>\n");
                xml.Append("\t\t</item>\n");
            }
            xml.Append("\t</hotArticles>\n");
            //好文章
            xml.Append("\t<fineArticles>\n");
            if (_siteDat.GetDat(cache.FinePost) == null)
            {
                _siteDat.SetDat(cache.FinePost, new PostData().SelectPost(0, null, null, 1, setting.Parameter.AppendFineArticleNum, 3, "A", false));
            }
            foreach (PostItem vItem in (DataList<PostItem>)_siteDat.GetDat(cache.FinePost))
            {
                ColumnItem columnItem = new ColumnItem();
                if (_siteDat.GetDat(string.Format(cache.ColumnFormat, vItem.ColumnID)) == null)
                {
                    _siteDat.SetDat(string.Format(cache.ColumnFormat, vItem.ColumnID), new ColumnData().GetColumn(vItem.ColumnID));
                }
                columnItem = (ColumnItem)_siteDat.GetDat(string.Format(cache.ColumnFormat, vItem.ColumnID));
                xml.Append("\t\t<item>\n");
                xml.AppendFormat("\t\t\t<link>{0}</link>\n", _fun.CDATA(string.Format(SitePath.ArticleLinkFormat, SiteCfg.Path, _fun.UrlEncode(vItem.Local))));
                xml.AppendFormat("\t\t\t<id>{0}</id>\n", vItem.ID);
                xml.AppendFormat("\t\t\t<title>{0}</title>\n", _fun.CDATA(vItem.Title));
                xml.AppendFormat("\t\t\t<tags>{0}</tags>\n", _fun.CDATA(vItem.Tags));
                xml.AppendFormat("\t\t\t<local>{0}</local>\n", _fun.CDATA(vItem.Local));
                xml.AppendFormat("\t\t\t<author>{0}</author>\n", _fun.CDATA(vItem.Author));
                xml.AppendFormat("\t\t\t<postCount>{0}</postCount>\n", vItem.PostCount);
                xml.AppendFormat("\t\t\t<reader>{0}</reader>\n", vItem.Reader);
                xml.AppendFormat("\t\t\t<vote>{0}</vote>\n", vItem.Vote);
                xml.AppendFormat("\t\t\t<fine>{0}</fine>\n", vItem.Fine);
                xml.AppendFormat("\t\t\t<publish>{0}</publish>\n", vItem.Publish);
                xml.Append("\t\t\t<category>\n");
                xml.AppendFormat("\t\t\t\t<link>{0}</link>\n", _fun.CDATA(string.Format(SitePath.CategoryLinkFormat, SiteCfg.Path, _fun.UrlEncode(columnItem.Local))));
                xml.AppendFormat("\t\t\t\t<id>{0}</id>\n", columnItem.ID);
                xml.AppendFormat("\t\t\t\t<local>{0}</local>\n", _fun.CDATA(columnItem.Local));
                xml.AppendFormat("\t\t\t\t<name>{0}</name>\n", _fun.CDATA(columnItem.Name));
                xml.AppendFormat("\t\t\t\t<intro>{0}</intro>\n", _fun.CDATA(columnItem.Intro));
                xml.AppendFormat("\t\t\t\t<postCount>{0}</postCount>\n", columnItem.PostCount);
                xml.Append("\t\t\t</category>\n");
                xml.Append("\t\t</item>\n");
            }
            xml.Append("\t</fineArticles>\n");
            //最新评论
            xml.Append("\t<newComments>\n");
            if (_siteDat.GetDat(cache.NewComment) == null)
            {
                _siteDat.SetDat(cache.NewComment, new CommentData().SelectComment(0, 1, setting.Parameter.AppendNewCommentNum, false));
            }
            foreach (CommentItem vItem in (DataList<CommentItem>)_siteDat.GetDat(cache.NewComment))
            {
                PostItem postItem = new PostData().GetPost(vItem.PostID);
                ColumnItem columnItem = new ColumnItem();
                if (_siteDat.GetDat(string.Format(cache.ColumnFormat, postItem.ColumnID)) == null)
                {
                    _siteDat.SetDat(string.Format(cache.ColumnFormat, postItem.ColumnID), new ColumnData().GetColumn(postItem.ColumnID));
                }
                xml.Append("\t\t<item>\n");
                xml.AppendFormat("\t\t\t<id>{0}</id>\n", vItem.ID);
                xml.AppendFormat("\t\t\t<author>{0}</author>\n", _fun.CDATA(vItem.Author));
                xml.AppendFormat("\t\t\t<title>{0}</title>\n", _fun.CDATA(vItem.Title));
                xml.AppendFormat("\t\t\t<content>{0}</content>\n", _fun.CDATA(vItem.Content));
                xml.AppendFormat("\t\t\t<reply>{0}</reply>\n", _fun.CDATA(vItem.Reply));
                xml.AppendFormat("\t\t\t<mail>{0}</mail>\n", _fun.CDATA(vItem.Mail));
                xml.AppendFormat("\t\t\t<url>{0}</url>\n", _fun.CDATA(vItem.URL));
                xml.AppendFormat("\t\t\t<publish>{0}</publish>\n", vItem.Publish);
                xml.AppendFormat("\t\t\t<trackback>{0}</trackback>\n", vItem.Trackback);
                xml.Append("\t\t\t<article>\n");
                xml.AppendFormat("\t\t\t\t<link>{0}</link>\n", _fun.CDATA(string.Format(SitePath.ArticleLinkFormat, SiteCfg.Path, _fun.UrlEncode(postItem.Local))));
                xml.AppendFormat("\t\t\t\t<id>{0}</id>\n", postItem.ID);
                xml.AppendFormat("\t\t\t\t<title>{0}</title>\n", _fun.CDATA(postItem.Title));
                xml.AppendFormat("\t\t\t\t<tags>{0}</tags>\n", _fun.CDATA(postItem.Tags));
                xml.AppendFormat("\t\t\t\t<local>{0}</local>\n", _fun.CDATA(postItem.Local));
                xml.AppendFormat("\t\t\t\t<author>{0}</author>\n", _fun.CDATA(postItem.Author));
                xml.AppendFormat("\t\t\t\t<postCount>{0}</postCount>\n", postItem.PostCount);
                xml.AppendFormat("\t\t\t\t<reader>{0}</reader>\n", postItem.Reader);
                xml.AppendFormat("\t\t\t\t<vote>{0}</vote>\n", postItem.Vote);
                xml.AppendFormat("\t\t\t\t<fine>{0}</fine>\n", postItem.Fine);
                xml.AppendFormat("\t\t\t\t<publish>{0}</publish>\n", postItem.Publish);
                xml.Append("\t\t\t\t<category>\n");
                xml.AppendFormat("\t\t\t\t\t<link>{0}</link>\n", _fun.CDATA(string.Format(SitePath.CategoryLinkFormat, SiteCfg.Path, _fun.UrlEncode(columnItem.Local))));
                xml.AppendFormat("\t\t\t\t\t<id>{0}</id>\n", columnItem.ID);
                xml.AppendFormat("\t\t\t\t\t<local>{0}</local>\n", _fun.CDATA(columnItem.Local));
                xml.AppendFormat("\t\t\t\t\t<name>{0}</name>\n", _fun.CDATA(columnItem.Name));
                xml.AppendFormat("\t\t\t\t\t<intro>{0}</intro>\n", _fun.CDATA(columnItem.Intro));
                xml.AppendFormat("\t\t\t\t\t<postCount>{0}</postCount>\n", columnItem.PostCount);
                xml.Append("\t\t\t\t</category>\n");
                xml.Append("\t\t\t</article>\n");
                xml.Append("\t\t</item>\n");
            }
            xml.Append("\t</newComments>\n");
            //单页面
            xml.Append("\t<pages>\n");
            if (_siteDat.GetDat(cache.Page) == null)
            {
                _siteDat.SetDat(cache.Page, new PostData().SelectPost(0, null, null, 1, 999, 0, "P", false));
            }
            foreach (PostItem vItem in (DataList<PostItem>)_siteDat.GetDat(cache.Page))
            {
                xml.Append("\t\t<item>\n");
                xml.AppendFormat("\t\t\t<link>{0}</link>\n", _fun.CDATA(string.Format(SitePath.PageLinkFormat, SiteCfg.Path, _fun.UrlEncode(vItem.Local))));
                xml.AppendFormat("\t\t\t<id>{0}</id>\n", vItem.ID);
                xml.AppendFormat("\t\t\t<title>{0}</title>\n", _fun.CDATA(vItem.Title));
                xml.AppendFormat("\t\t\t<local>{0}</local>\n", _fun.CDATA(vItem.Local));
                xml.AppendFormat("\t\t\t<publish>{0}</publish>\n", vItem.Publish);
                xml.Append("\t\t</item>\n");
            }
            xml.Append("\t</pages>\n");
            //热门标签
            xml.Append("\t<tags>\n");
            if (_siteDat.GetDat(cache.HotTag) == null)
            {
                _siteDat.SetDat(cache.HotTag, new TagData().SelectTag(1, setting.Parameter.AppendHotTagNum, "PostCount", "DESC"));
            }
            foreach (TagItem vItem in (TagList)_siteDat.GetDat(cache.HotTag))
            {
                xml.Append("\t\t<item>\n");
                xml.AppendFormat("\t\t\t<link>{0}</link>\n", _fun.CDATA(string.Format(SitePath.TagLinkFormat, SiteCfg.Path, _fun.UrlEncode(vItem.Key))));
                xml.AppendFormat("\t\t\t<id>{0}</id>\n", vItem.ID);
                xml.AppendFormat("\t\t\t<key>{0}</key>\n", _fun.CDATA(vItem.Key));
                xml.AppendFormat("\t\t\t<postCount>{0}</postCount>\n", vItem.PostCount);
                xml.Append("\t\t</item>\n");
            }
            xml.Append("\t</tags>\n");
            //首页链接
            xml.Append("\t<fellows>\n");
            if (_siteDat.GetDat(cache.Fellow) == null)
            {
                _siteDat.SetDat(cache.Fellow, new FellowData().SelectFellow(1, int.MaxValue, true, false));
            }
            DataList<FellowItem> fellows = (DataList<FellowItem>)_siteDat.GetDat(cache.Fellow);
            foreach (FellowItem vItem in fellows)
            {
                xml.Append("\t\t<item>\n");
                xml.AppendFormat("\t\t\t<id>{0}</id>\n", vItem.ID);
                xml.AppendFormat("\t\t\t<name>{0}</name>\n", _fun.CDATA(vItem.Name));
                xml.AppendFormat("\t\t\t<url>{0}</url>\n", _fun.CDATA(vItem.URL));
                xml.AppendFormat("\t\t\t<logo>{0}</logo>\n", _fun.CDATA(vItem.Logo));
                xml.AppendFormat("\t\t\t<explain>{0}</explain>\n", _fun.CDATA(_fun.HtmlMatch(vItem.Explain)));
                xml.AppendFormat("\t\t\t<style>{0}</style>\n", _fun.CDATA(vItem.Style));
                xml.Append("\t\t</item>\n");
            }
            xml.Append("\t</fellows>\n");
            //自定义标签
            xml.Append("\t<myTag>\n");
            if (_siteDat.GetDat(cache.MyTag) == null)
            {
                _siteDat.SetDat(cache.MyTag, new MyTagData().SelectMyTag(1, int.MaxValue, false));
            }
            foreach (MyTagItem vItem in (DataList<MyTagItem>)_siteDat.GetDat(cache.MyTag))
            {
                xml.AppendFormat("\t\t<{0}>{1}</{0}>\n", vItem.Key, _fun.CDATA(vItem.Code));
            }
            xml.Append("\t</myTag>\n");
            //单页数据
            xml.Append("\t<this>\n");
            xml.AppendFormat("\t\t<title>{0}</title>\n", _fun.CDATA(title));
            xml.Append(thisXmlText);
            xml.Append("\t</this>\n");
            //扩展部分
            xml.Append("\t<expand>\n");
            foreach (object type in new SiteExpand().GetTypes(typeof(IWebExpandXml).FullName))
            {
                IWebExpandXml iae = ((IWebExpandXml)type);
                xml.Append(iae.OutXML());
            }
            xml.Append("\t</expand>\n");
            xml.Append("</ui>\n");
            return xml.ToString();
        }
    }
}
