﻿using System;
using System.IO;
using System.Text;
using isRoc.Core;
using isRoc.Data;
using isRoc.Data.Entity;
using isRoc.Logic;
using isRoc.Logic.Template;
using isRoc.Logic.Web;

namespace isRoc.Web
{
    /// <summary>
    /// 主显示基类
    /// </summary>
    public partial class Default : System.Web.UI.Page
    {
        private SiteFun _fun = new SiteFun();

        /// <summary>
        /// 显示内容
        /// </summary>
        /// <param name="sender">基类对象</param>
        /// <param name="e">事件对象</param>
        protected void Page_Load(object sender, EventArgs e)
        {
            try
            {
                XsltTemplate tpl = new XsltTemplate();
                //初始化全局页面类库
                _WebBase wb = new _WebBase();
                wb.InitConn();
                //开始执行
                switch (_fun.Query("act"))
                {
                    case "page":
                        {
                            int id = _fun.ToInt(_fun.Query("id"));
                            string local = _fun.Query("local");
                            WebPage webPg = new WebPage();
                            tpl.LoadXslt(Path.Combine(SiteCfg.Router, string.Format(SitePath.ThemePathFormat, webPg.OutTheme, "Page.View")));
                            tpl.BindXml(webPg.OutWrite(id, local));
                            break;
                        }
                    case "tags":
                        {
                            WebTags webTags = new WebTags();
                            tpl.LoadXslt(Path.Combine(SiteCfg.Router, string.Format(SitePath.ThemePathFormat, webTags.OutTheme, "Tag.List")));
                            tpl.BindXml(webTags.OutWrite());
                            break;
                        }
                    case "fellows":
                        {
                            WebFellows webFlw = new WebFellows();
                            tpl.LoadXslt(Path.Combine(SiteCfg.Router, string.Format(SitePath.ThemePathFormat, webFlw.OutTheme, "Fellow.List")));
                            tpl.BindXml(webFlw.OutWrite());
                            break;
                        }
                    case "expand":
                        {
                            foreach (object type in new SiteExpand().GetTypes(typeof(IWebExpand).FullName))
                            {
                                IWebExpand iae = ((IWebExpand)type);
                                if (iae.Key == _fun.Query("key"))
                                {
                                    StringBuilder xml = new StringBuilder();
                                    xml.Append("\t\t<expand>\n");
                                    xml.AppendFormat("\t\t\t<css>{0}</css>\n", _fun.CDATA(iae.Css));
                                    xml.AppendFormat("\t\t\t<html>{0}</html>\n", _fun.CDATA(iae.OutHtml()));
                                    xml.Append("\t\t</expand>\n");
                                    tpl.LoadXslt(Path.Combine(SiteCfg.Router, string.Format(SitePath.ThemePathFormat, iae.OutTheme, "Expand.View")));
                                    tpl.BindXml(new _WebBaseXml().OutBaseXml(iae.Name, xml.ToString()));
                                    break;
                                }
                            }
                            break;
                        }
                    default:
                        {
                            WebArticle webArt = new WebArticle();
                            switch (_fun.Query("mode"))
                            {
                                case "view":
                                    {
                                        int id = _fun.ToInt(_fun.Query("id"));
                                        string local = _fun.Query("local");
                                        string pwd = _fun.Post("pwd");
                                        int page = _fun.ToInt(_fun.Query("page"));
                                        int pageSize = webArt.OutSetting.Parameter.CommentNum;
                                        string tplFile = "Article.View";
                                        PostItem postItem = new PostData().GetPost(id);
                                        ColumnItem columnItem = new ColumnData().GetColumn(postItem.ColumnID);
                                        if (postItem.ID == 0) { postItem = new PostData().GetPost(local); }
                                        if (!string.IsNullOrEmpty(columnItem.ViewTemplate) && File.Exists(Path.Combine(SiteCfg.Router, string.Format(SitePath.ThemePathFormat, webArt.OutTheme, columnItem.ViewTemplate)))) { tplFile = columnItem.ViewTemplate; }
                                        tpl.LoadXslt(Path.Combine(SiteCfg.Router, string.Format(SitePath.ThemePathFormat, webArt.OutTheme, tplFile)));
                                        tpl.BindXml(webArt.OutWriteView(id, local, pwd, page, pageSize));
                                        break;
                                    }
                                default:
                                    {
                                        int cid = _fun.ToInt(_fun.Query("cid"));
                                        string clocal = _fun.Query("clocal");
                                        string tag = _fun.Query("tag");
                                        string key = _fun.Query("key");
                                        int page = _fun.ToInt(_fun.Query("page"));
                                        int pageSize = webArt.OutSetting.Parameter.ArticleNum;
                                        string tplFile = "Article.List";
                                        //开始处理
                                        ColumnItem column = new ColumnData().GetColumn(cid);
                                        if (column.ID == 0) { column = new ColumnData().GetColumn(clocal); }
                                        if (column.ID == 0 && string.IsNullOrEmpty(tag) && string.IsNullOrEmpty(key) && page == 0 && File.Exists(Path.Combine(SiteCfg.Router, string.Format(SitePath.ThemePathFormat, webArt.OutTheme, "Index")))) { tplFile = "Index"; }
                                        else
                                        {
                                            if (column.ID > 0)
                                            {
                                                if (!string.IsNullOrEmpty(column.ListTemplate) && File.Exists(Path.Combine(SiteCfg.Router, string.Format(SitePath.ThemePathFormat, webArt.OutTheme, column.ListTemplate)))) { tplFile = column.ListTemplate; }
                                                if (column.PageSize > 0) { pageSize = column.PageSize; }
                                            }
                                        }
                                        tpl.LoadXslt(Path.Combine(SiteCfg.Router, string.Format(SitePath.ThemePathFormat, webArt.OutTheme, tplFile)));
                                        tpl.BindXml(webArt.OutWriteList(cid, clocal, tag, key, page, pageSize));
                                        break;
                                    }
                            }
                            break;
                        }
                }
                tpl.Print();
            }
            catch (Exception err)
            {
                IMyError exeError = new MyError();
                foreach (IMyError myError in new SiteExpand().GetTypes(typeof(IMyError).FullName))
                {
                    exeError = myError;
                    break;
                }
                exeError.PrintError(err);
            }
        }
    }
}
