﻿using System;
using isRoc.Core;
using isRoc.Logic;
using isRoc.Logic.Service;

namespace isRoc.Web
{
    /// <summary>
    /// 异步操作基类
    /// </summary>
    public partial class Service : System.Web.UI.Page
    {
        private SiteFun _fun = new SiteFun();

        /// <summary>
        /// 显示内容
        /// </summary>
        /// <param name="sender">基类对象</param>
        /// <param name="e">事件对象</param>
        protected void Page_Load(object sender, EventArgs e)
        {
            try
            {
                _ServiceBase sb = new _ServiceBase();
                sb.InitConn();
                //开始执行
                switch (_fun.Query("act"))
                {
                    case "comment":
                        {
                            new ServiceComment().OutWrite();
                            break;
                        }
                    case "passwordArticle":
                        {
                            new ServicePost().OutWriteOfPasswordArticle();
                            break;
                        }
                    case "rss":
                        {
                            new ServiceRss().OutWrite();
                            break;
                        }
                    case "autoSave":
                        {
                            new ServicePost().OutAutoSavePost();
                            break;
                        }
                    case "rePostContent":
                        {
                            new ServicePost().OutRePostContent();
                            break;
                        }
                    case "artVote":
                        {
                            new ServicePost().OutWriteVote();
                            break;
                        }
                    case "matchTags":
                        {
                            new ServiceTag().GetMatchTags();
                            break;
                        }
                    case "trackback":
                        {
                            new ServiceTrackback().OutWrite();
                            break;
                        }
                    case "verifyCode":
                        {
                            new ServiceVerifyCode().Display();
                            break;
                        }
                    case "getTime":
                        {
                            new ServiceTime().OutWrite();
                            break;
                        }
                    case "expand":
                        {
                            foreach (object type in new SiteExpand().GetTypes(typeof(IServiceExpand).FullName))
                            {
                                IServiceExpand iae = ((IServiceExpand)type);
                                if (iae.Key == _fun.Query("key"))
                                {
                                    iae.OutWrite();
                                    break;
                                }
                            }
                            break;
                        }
                }
            }
            catch (Exception err)
            {
                IMyError exeError = new MyError();
                foreach (IMyError myError in new SiteExpand().GetTypes(typeof(IMyError).FullName))
                {
                    exeError = myError;
                    break;
                }
                exeError.PrintError(err);
            }
        }
    }
}
