<?php
namespace app\components;

use Yii;
use yii\web\Cookie;
use app\models\User;
use app\models\Config;
use app\models\Resour_leader;
use app\models\Specialty_leader;
use app\components\AuthcodeHelper;

class AccessControl{
	
	//用户登录
	//参数：用户名，密码
	//返回值：登录成功返回用户id，否则返回小于等于0的数字(0用户名不存在，-1密码错误，-2用户被禁止登录)
	public static function Login($username, $password, $remember){
		$cookiekey = Yii::$app->params["user_cookiekey"];
		$cookiename = Yii::$app->params["user_cookiename"];
		$user = User::find()->where("username='". $username ."' or stdnumber='". $username ."'")->one();
		$logintime = date("Y-m-d H:i:s");
		$loginip = Yii::$app->request->userIP;
		if(empty($user)){
			return 0;
		}
		if(md5($password . $user->salt)!=$user->password){
			return -1;
		}
		if($user->isactive!=1){
			return -2;
		}
		if($user->islocked==1){
			return -3;
		}
		$user->logintime = $logintime;
		$user->loginip = $loginip;
		$user->save();
		$serialkeyok = "failed";
		$userarr = [
			"id" => $user->id,
			"roleid" => $user->roleid,
			"groupid" => $user->groupid,
			"username" => $user->username,
			"realname" => $user->realname,
			"stdnumber" => $user->stdnumber,
			"logo" => $user->logo,
			"xzclassid" => $user->xzclassid,
			"specialid" => $user->specialid,
			"specialpath" => $user->specialpath,
			"leadspecialids" => trim($user->leadspecialids, ","),
			"leadcourseidszyk" => trim($user->leadcourseidszyk, ","),
			"serialkeyok" => $serialkeyok
		];
		$cookievalue = json_encode($userarr);
		$cookievalue = AuthcodeHelper::authcode($cookievalue, "", $cookiekey, 0);
		$cookie = new Cookie();
		$cookie->name = $cookiename;
		$cookie->value = $cookievalue;
		if($remember==1){
			$cookie->expire = time()+60*60*12;
		}
		Yii::$app->response->cookies->add($cookie);
		return $user->id;
	}
	
	//用户登出
	//参数：无
	//返回值：无
	public static function Logout(){
		$cookiename = Yii::$app->params["user_cookiename"];
		Yii::$app->response->cookies->remove($cookiename);
	}
	
	//判断用户是否登录
	//参数：无
	//返回值：已登录返回用户信息对象，否则返回空
	public static function isLogin(){
		$cookiekey = Yii::$app->params["user_cookiekey"];
		$cookiename = Yii::$app->params["user_cookiename"];
		$cookies = Yii::$app->request->cookies;
		if(empty($cookies[$cookiename])){
			return "";	
		}else{
			$cookievalue = $cookies[$cookiename]->value;
			$cookievalue = AuthcodeHelper::authcode($cookievalue, "DECODE", $cookiekey, 0);
			$userobj = json_decode($cookievalue);
			if(empty($userobj->logo)){
				$userobj->logo = Yii::$app->params["user_logo"];
			}
			return $userobj;
		}
	}

	//修改个人资料后刷新Cookie
	//参数：用户id
	//返回值：刷新成功返回用户id，否则返回0
	public static function RefreshCookie($userid){
		$cookiekey = Yii::$app->params["user_cookiekey"];
		$cookiename = Yii::$app->params["user_cookiename"];
		$user = User::find()->where("id=". $userid)->one();
		if(empty($user)){
			return 0;
		}
		$serialkeyok = "failed";
		$userarr = [
			"id" => $user->id,
			"roleid" => $user->roleid,
			"groupid" => $user->groupid,
			"username" => $user->username,
			"realname" => $user->realname,
			"stdnumber" => $user->stdnumber,
			"logo" => $user->logo,
			"xzclassid" => $user->xzclassid,
			"specialid" => $user->specialid,
			"specialpath" => $user->specialpath,
			"leadspecialids" => trim($user->leadspecialids, ","),
			"leadcourseidszyk" => trim($user->leadcourseidszyk, ","),
			"serialkeyok" => $serialkeyok
		];
		$cookievalue = json_encode($userarr);
		$cookievalue = AuthcodeHelper::authcode($cookievalue, "", $cookiekey, 0);
		$cookie = new Cookie();
		$cookie->name = $cookiename;
		$cookie->value = $cookievalue;
		if($remember==1){
			$cookie->expire = time()+60*60*12;
		}
		Yii::$app->response->cookies->add($cookie);
		return $user->id;
	}
	
}
?>