<?php
namespace app\components;

use Yii;
use app\models\Resour_course;
use app\models\Doexam;
use app\models\Doexam_answer;
use app\models\Exam;
use app\models\Exam_option;
use app\models\Exam_stem;
use app\models\User;

class ExamHelper{

	//显示课程名称
	public static function showCourseName($courseid){
		$msg = "";
		$course = Resour_course::find()->where("id=". $courseid)->one();
		if(!empty($course)){
			$msg = $course->name;
		}
		return $msg;
	}

	//计算考试已提交人数、未提交人数
	//计算考试正确率和错误率
	public static function CalcExamRatioRight($exam, $classid){
		$msg = array("tijiao_done"=>0,"tijiao_notyet"=>0,"ratio_right"=>0,"ratio_wrong"=>0,"done_right"=>0,"done_wrong"=>0);
		if(empty($exam)){
			return $msg;
		}
		//已提交人数、未提交人数
		$total_student = $exam->persons;
		$condition = "examid=". $exam->id;
		if(!empty($classid) && is_numeric($classid)==true){
			$condition .= " and userid in (select id from user where xzclassid=". $classid .")";
			$total_student = User::find()->where("xzclassid=". $classid)->count();
		}
		$tijiao_done = Doexam::find()->where($condition ." and isdone>=2")->count();
		$tijiao_notyet = $total_student-$tijiao_done;
		//正确率和错误率
		$condition = "examid=". $exam->id;
		if(!empty($classid) && is_numeric($classid)==true){
			$condition .= " and userid in (select id from user where xzclassid=". $classid .")";
		}
		$stemnum_stddone = Doexam_answer::find()->where($condition)->count();
		$stemnum_stdright = Doexam_answer::find()->where($condition ." and points>0")->count();
		if(empty($stemnum_stddone) || $stemnum_stddone==0){
			$ratio_right = 0;
			$ratio_wrong = 0;
			$done_right = 0;
			$done_wrong = 0;
		}else{
			$ratio_right = $stemnum_stdright/$stemnum_stddone;
			$ratio_wrong = 1-$ratio_right;
			$done_right = $stemnum_stdright;
			$done_wrong = $stemnum_stddone-$stemnum_stdright;
		}
		//平均分
		$dbh = Yii::$app->db;
		$sql = "select avg(points) as pingjunfen from doexam where ". $condition;
		$cmd = $dbh->createCommand($sql);
		$row = $cmd->queryOne();
		$pingjunfen = $row["pingjunfen"];
		if(empty($pingjunfen)){$pingjunfen = 0;}
		$pingjunfen = round($pingjunfen, 2);
		$msg = array("tijiao_done"=>$tijiao_done,"tijiao_notyet"=>$tijiao_notyet,"ratio_right"=>$ratio_right,"ratio_wrong"=>$ratio_wrong,"done_right"=>$done_right,"done_wrong"=>$done_wrong,"pingjunfen"=>$pingjunfen);
		return $msg;
	}
	
	//计算某一道题目的正确率和错误率
	public static function CalcQuestionRatioRight($onestem, $classid){
		$msg = array("ratio_right"=>0,"ratio_wrong"=>0,"done_right"=>0,"done_wrong"=>0);
		if(empty($onestem)){
			return $msg;
		}
		//正确率和错误率
		$condition = "examid=". $onestem->examid ." and stemid=". $onestem->id;
		if(!empty($classid) && is_numeric($classid)==true){
			$condition .= " and userid in (select id from user where xzclassid=". $classid .")";
		}
		$stemnum_stddone = Doexam_answer::find()->where($condition)->count();
		$stemnum_stdright = Doexam_answer::find()->where($condition ." and points>0")->count();
		if(empty($stemnum_stddone) || $stemnum_stddone==0){
			$ratio_right = 0;
			$ratio_wrong = 0;
			$done_right = 0;
			$done_wrong = 0;
		}else{
			$ratio_right = $stemnum_stdright/$stemnum_stddone;
			$ratio_wrong = 1-$ratio_right;
			$done_right = $stemnum_stdright;
			$done_wrong = $stemnum_stddone-$stemnum_stdright;
		}
		$msg = array("ratio_right"=>$ratio_right,"ratio_wrong"=>$ratio_wrong,"done_right"=>$done_right,"done_wrong"=>$done_wrong);
		return $msg;
	}

	//计算考试的得分统计
	public static function CalcScoreStages($exam, $classid){
		$msg = array("0-59"=>0,"60-69"=>0,"70-79"=>0,"80-89"=>0,"90-100"=>0);
		if(empty($exam)){
			return $msg;
		}
		$condition = "examid=". $exam->id;
		if(!empty($classid) && is_numeric($classid)==true){
			$condition .= " and userid in (select id from user where xzclassid=". $classid .")";
		}
		$number1 = Doexam::find()->where($condition ." and points<=59")->count();
		$number2 = Doexam::find()->where($condition ." and points>=60 and points<=69")->count();
		$number3 = Doexam::find()->where($condition ." and points>=70 and points<=79")->count();
		$number4 = Doexam::find()->where($condition ." and points>=80 and points<=89")->count();
		$number5 = Doexam::find()->where($condition ." and points>=90")->count();
		$msg = array("59以下"=>$number1,"60-69"=>$number2,"70-79"=>$number3,"80-89"=>$number4,"90以上"=>$number5);
		return $msg;
	}
		
}
?>