<?php
namespace app\components;

class SafetyHelper{
	
	private static $dangerlist = "iframe,script,select,delete,drop,insert,update,select,where,concat,database,union";
	
	//过滤危险字符串
	public static function KillDangerCode($content){
		if(empty($content) || is_numeric($content)==true){
			return $content;
		}
		//$content = str_ireplace(";", ".", $content);
		$content = str_ireplace("'", ".", $content);
		$dangerarr = explode(",", self::$dangerlist);
		foreach($dangerarr as $onedanger){
			$onechararr = str_split($onedanger);
			$replacedstr = implode(".", $onechararr);
			$content = str_ireplace($onedanger, $replacedstr, $content);
		}
		return $content;
	}
	
	//过滤GET,POST的数据
	public static function FireWallWorks(){
		foreach($_GET as $onekey => $onevalue){
			if(!is_array($onevalue)){
				$_GET[$onekey] = self::KillDangerCode($onevalue);
			}
		}
		foreach($_POST as $onekey => $onevalue){
			if(!is_array($onevalue)){
				$_POST[$onekey] = self::KillDangerCode($onevalue);
			}
		}
	}
	
}
?>