<?php
namespace app\components;

use Yii;
use app\models\User;
use app\models\Role;
use app\models\Specialty;
use app\models\Resour_leader;
use app\models\Specialty_leader;

class UserHelper{

	//显示用户角色
	public static function showRolename($roleid){
		$msg = "未知";
		if(empty($roleid) || !is_numeric($roleid)){
			return $msg;
		}
		$role = Role::find()->where("id=". $roleid)->one();
		if(!empty($role)){
			$msg = $role->name;
		}
		return $msg;
	}

	//显示用户性别
	public static function showMalename($male){
		$msg = "保密";
		if(empty($male) || !is_numeric($male)){
			return $msg;
		}
		if($male==1){
			$msg = "男";
		}elseif($male==2){
			$msg = "女";
		}
		return $msg;
	}
	
	//显示院系专业
	public static function showSpecialpathname($pathids){
		$msg = "";
		if(empty($pathids)){
			return $msg;
		}
		$pathids = trim($pathids, ",");
		$specials = Specialty::find()->select("id,name")->where("id in (". $pathids .")")->orderby("nodetype asc")->all();
		foreach($specials as $onespecial){
			$msg .= $onespecial->name ."-";
		}
		$msg = trim($msg, "-");
		return $msg;
	}

	//获取用户基本信息
	public static function basicInfoarr($userid){
		$msg = ["id"=>0, "username"=>"0", "nicename"=>"0", "logo"=>Yii::$app->params["user_logo"]];
		if(empty($userid) || !is_numeric($userid)){
			return $msg;
		}
		$visitor = User::find()->where("id=". $userid)->one();
		if(!empty($visitor)){
			$msg = ["id"=>$visitor->id, "username"=>$visitor->username, "nicename"=>$visitor->nicename, "logo"=>$visitor->logo];
			if(empty($msg["logo"])){ $msg["logo"] = Yii::$app->params["user_logo"]; }
		}
		return $msg;
	}

	//用户名验证
	public static function sameUsername($username, $userid){
		if(empty($username)){
			$result = ["code"=>"failed","msg"=>"用户名不能为空","url"=>""];
			return json_encode($result);
		}
		if(!preg_match("/^[a-zA-Z0-9_]{4,20}$/", $username)){
			$result = ["code"=>"failed","msg"=>"用户名格式错误","url"=>""];
			return json_encode($result);
		}
		$regiforbid = file_get_contents(WEBROOT ."/upfiles/config/regiforbid.txt");
		$forbidarr = explode(",", $regiforbid);
		$canregis = 1;
		foreach ($forbidarr as $oneforbid) {
			if(stripos($oneforbid, $username)===false && stripos($username, $oneforbid)===false){
				//do nothing
			}else{
				$canregis = 0;
				break;
			}
		}
		if($canregis==0){
			$result = ["code"=>"failed","msg"=>"用户名禁止注册","url"=>""];
			return json_encode($result);
		}
		$condition = "username='". $username ."'";
		if(!empty($userid) && is_numeric($userid)){
			$condition .= " and id<>". $userid;
		}
		$sameuser = User::find()->where($condition)->one();
		if(!empty($sameuser)){
			$result = ["code"=>"failed","msg"=>"用户名已被占用","url"=>""];
			return json_encode($result);
		}
		$result = ["code"=>"success","msg"=>"可以使用","url"=>""];
		return json_encode($result);
	}
	
	//学号验证
	public static function sameStdnumber($stdnumber, $userid){
		if(empty($stdnumber)){
			$result = ["code"=>"failed","msg"=>"学号不能为空","url"=>""];
			return json_encode($result);
		}
		if(!preg_match("/^[a-zA-Z0-9_]{4,20}$/", $stdnumber)){
			$result = ["code"=>"failed","msg"=>"学号格式错误","url"=>""];
			return json_encode($result);
		}
		$regiforbid = file_get_contents(WEBROOT ."/upfiles/config/regiforbid.txt");
		$forbidarr = explode(",", $regiforbid);
		$canregis = 1;
		foreach ($forbidarr as $oneforbid) {
			if(stripos($oneforbid, $stdnumber)===false && stripos($stdnumber, $oneforbid)===false){
				//do nothing
			}else{
				$canregis = 0;
				break;
			}
		}
		if($canregis==0){
			$result = ["code"=>"failed","msg"=>"学号禁止注册","url"=>""];
			return json_encode($result);
		}
		$condition = "stdnumber='". $stdnumber ."'";
		if(!empty($userid) && is_numeric($userid)){
			$condition .= " and id<>". $userid;
		}
		$sameuser = User::find()->where($condition)->one();
		if(!empty($sameuser)){
			$result = ["code"=>"failed","msg"=>"学号已被占用","url"=>""];
			return json_encode($result);
		}
		$result = ["code"=>"success","msg"=>"可以使用","url"=>""];
		return json_encode($result);
	}

	//昵称验证
	public static function sameNicename($nicename, $userid){
		if(empty($nicename)){
			$result = ["code"=>"failed","msg"=>"昵称不能为空","url"=>""];
			return json_encode($result);
		}
		if(!preg_match("/([\x{4e00}-\x{9fa5}a-zA-Z0-9_]){2,20}/u", $nicename)){
			$result = ["code"=>"failed","msg"=>"昵称格式错误","url"=>""];
			return json_encode($result);
		}
		$condition = "nicename='". $nicename ."'";
		if(!empty($userid) && is_numeric($userid)){
			$condition .= " and id<>". $userid;
		}
		$samenice = User::find()->where($condition)->one();
		if(!empty($samenice)){
			$result = ["code"=>"failed","msg"=>"昵称已被占用","url"=>""];
			return json_encode($result);
		}
		$result = ["code"=>"success","msg"=>"可以使用","url"=>""];
		return json_encode($result);
	}

	//邮箱验证
	public static function sameEmailbox($email, $userid){
		if(empty($email)){
			$result = ["code"=>"failed","msg"=>"邮箱不能为空","url"=>""];
			return json_encode($result);
		}
		if(!preg_match("/\w+([-+.]\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*/", $email)){
			$result = ["code"=>"failed","msg"=>"邮箱格式错误","url"=>""];
			return json_encode($result);
		}
		$condition = "email='". $email ."'";
		if(!empty($userid) && is_numeric($userid)){
			$condition .= " and id<>". $userid;
		}
		$sameemail = User::find()->where($condition)->one();
		if(!empty($sameemail)){
			$result = ["code"=>"failed","msg"=>"邮箱已被占用","url"=>""];
			return json_encode($result);
		}
		$result = ["code"=>"success","msg"=>"可以使用","url"=>""];
		return json_encode($result);
	}

	//手机号验证
	public static function sameCellphone($cellphone, $userid){
		if(empty($cellphone)){
			$result = ["code"=>"failed","msg"=>"手机号不能为空","url"=>""];
			return json_encode($result);
		}
		if(!preg_match("/^((13[0-9])|147|(15[0-35-9])|180|182|(18[5-9]))[0-9]{8}$/", $cellphone)){
			$result = ["code"=>"failed","msg"=>"手机号格式错误","url"=>""];
			return json_encode($result);
		}
		$condition = "cellphone='". $cellphone ."'";
		if(!empty($userid) && is_numeric($userid)){
			$condition .= " and id<>". $userid;
		}
		$samephone = User::find()->where($condition)->one();
		if(!empty($samephone)){
			$result = ["code"=>"failed","msg"=>"手机号已被占用","url"=>""];
			return json_encode($result);
		}
		$result = ["code"=>"success","msg"=>"可以使用","url"=>""];
		return json_encode($result);
	}

	//我参与的专业
	public static function getLeadSpecialIds($userid){
		$msg = "0";
		if(empty($userid) || !is_numeric($userid)){
			return $msg;
		}
		$leaders = Specialty_leader::find()->where("userid=". $userid)->all();
		foreach ($leaders as $oneleader) {
			$msg .= ",". $oneleader->specialid;
		}
		$msg = trim($msg, ",");
		return $msg;
	}

	//我参与的资源库课程
	public static function getLeadCourseIds_zyk($userid){
		$msg = "0";
		if(empty($userid) || !is_numeric($userid)){
			return $msg;
		}
		$leaders = Resour_leader::find()->where("userid=". $userid)->all();
		foreach ($leaders as $oneleader) {
			$msg .= ",". $oneleader->courseid;
		}
		$msg = trim($msg, ",");
		return $msg;
	}
	
}
?>