<?php
namespace app\components;

use Yii;
use app\models\User;
use app\models\User_logs;
use app\models\Visits_type;

class VisitorHelper{
	
	//判断访问设备
	public static function visitorEquipment($agent){
		if(empty($agent)){
			$agent = strtolower($_SERVER['HTTP_USER_AGENT']);
		}
		if(stripos($agent, 'windows nt')){
			$platform = 'windows';
		}elseif(stripos($agent, 'macintosh')){
			$platform = 'mac';
		}elseif(stripos($agent, 'ipod')){
			$platform = 'ipod';
		}elseif(stripos($agent, 'ipad')){
			$platform = 'ipad';
		}elseif(stripos($agent, 'iphone')){
			$platform = 'iphone';
		}elseif (stripos($agent, 'android')){
			$platform = 'android';
		}elseif(stripos($agent, 'unix')){
			$platform = 'unix';
		}elseif(stripos($agent, 'linux')){
			$platform = 'linux';
		}else{
			$platform = 'other';
		}
		return $platform;
	}

	//判断搜索引擎蜘蛛
	public static function visitorComeSpider($agent){
		$msg = "";
		if(empty($agent)){ return $msg; }
		$spiderarr = Yii::$app->params["spiders"];
		foreach ($spiderarr as $spiderkey => $spidername) {
			if(stripos($agent, $spiderkey)!==false){
				$msg = $spiderkey;
				break;
			}
		}
		return $msg;
	}

	//显示蜘蛛名称
	public static function visitorSpiderName($spider){
		$msg = "";
		if(empty($spider)){ return $msg; }
		$spiderarr = Yii::$app->params["spiders"];
		if($spiderarr[$spider]){ $msg = $spiderarr[$spider]; }
		return $msg;
	}

	//显示访问类型
	public static function visitTargetType($typeid){
		$msg = "未知";
		if(empty($typeid) || !is_numeric($typeid)){
			return $msg;
		}
		$visittype = Visits_type::find()->where("id=". $typeid)->one();
		if(!empty($visittype)){
			$msg = $visittype->name;
		}
		return $msg;
	}

	//显示用户名称
	public static function visitorNiceName($userid){
		$msg = "匿名";
		if(empty($userid) || !is_numeric($userid)){
			return $msg;
		}
		$visitor = User::find()->where("id=". $userid)->one();
		if(!empty($visitor)){
			$msg = $visitor->nicename;
		}
		return $msg;
	}

	//记录用户日志
	public static function visitorThingLogs($userid, $username, $type, $code, $msg){
		$onelog = new User_logs();
		$onelog->userid = $userid;
		$onelog->username = $username;
		$onelog->type = $type;
		$onelog->comeyear = date("Y");
		$onelog->comemonth = date("m");
		$onelog->comedate = date("Y-m-d");
		$onelog->cometime = date("Y-m-d H:i:s");
		$onelog->code = $code;
		$onelog->msg = $msg;
		$onelog->userip = Yii::$app->request->userIP;
		$onelog->useros = $_SERVER['HTTP_USER_AGENT'];
		$onelog->userequip = self::visitorEquipment($onelog->useros);
		$onelog->spider = self::visitorComeSpider($onelog->useros);
		if(empty($onelog->userip)){
			$onelog->country = "未知";
		}elseif(substr($onelog->userip,0,7)=="192.168"){
			$onelog->country = "未分配或者内网IP";
		}else{
			$remoteurl = "http://ip.taobao.com/service/getIpInfo.php?ip=". $onelog->userip;
			$ch = curl_init();
			curl_setopt($ch, CURLOPT_URL, $remoteurl);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
			curl_setopt($ch, CURLOPT_TIMEOUT, 60);
			$json = curl_exec($ch);
			curl_close($ch);
			if(!empty($json)){
				$iplocal = json_decode($json);
				if($iplocal->code==0){
					$onelog->country = $iplocal->data->country;
					$onelog->area = $iplocal->data->area;
					$onelog->region = $iplocal->data->region;
					$onelog->city = $iplocal->data->city;
					$onelog->county = $iplocal->data->county;
					$onelog->isp = $iplocal->data->isp;
					if(empty($onelog->country)){$onelog->country = "";}
					if(empty($onelog->area)){$onelog->area = "";}
					if(empty($onelog->region)){$onelog->region = "";}
					if(empty($onelog->city)){$onelog->city = "";}
					if(empty($onelog->county)){$onelog->county = "";}
					if(empty($onelog->isp)){$onelog->isp = "";}
				}else{
					$onelog->country = "未知";
				}
			}else{
				$onelog->country = "未知";
			}
		}
		$onelog->save();
	}
	
}
?>