<?php

$params = require(__DIR__ . '/params.php');

$config = [
    'id' => 'basic',
    'basePath' => dirname(__DIR__),
    'bootstrap' => ['log'],
    'components' => [
        'request' => [
            // !!! insert a secret key in the following (if it is empty) - this is required by cookie validation
            'cookieValidationKey' => 'deed170cc3027b417298c03ae8fc6f8f',
        ],
        'user' => [
            'identityClass' => 'app\models\User',
            'enableAutoLogin' => true,
        ],
        'errorHandler' => [
            'errorAction' => 'site/error',
        ],
        'mailer' => [
            'class' => 'yii\swiftmailer\Mailer',
			'useFileTransport' => true,
        ],
        /*'log' => [
            'traceLevel' => YII_DEBUG ? 3 : 0,
            'targets' => [
                [
                    'class' => 'yii\log\FileTarget',
                    'levels' => ['error', 'warning'],
                ],
            ],
        ],*/
        'db' => require(__DIR__ . '/db.php'),
        'urlManager' => [
            'enablePrettyUrl' => true,
            'showScriptName' => false,
			'enableStrictParsing' => false,
            'rules' => [
                '/glnotice/basic/<id:\d+>' => '/glnotice/basic/index',
                '/notice/<id:\d+>' => '/notice/index',
                '/gluser/basic/<id:\d+>' => '/gluser/basic/index',
                '/glspecial/chapter/<id:\d+>' => '/glspecial/chapter/index',
                '/glspecial/section/<id:\d+>-<parentid:\d+>' => '/glspecial/section/index',
                '/glspecial/knowled/<id:\d+>-<parentid:\d+>' => '/glspecial/knowled/index',
                '/glspecial/leader/<id:\d+>' => '/glspecial/leader/index',
                '/glquesti/special/<id:\d+>' => '/glquesti/special/index',
                '/glquesti/tree/<id:\d+>' => '/glquesti/tree/index',
                '/glquesti/list/<id:\d+>' => '/glquesti/list/index',
                '/glquesti/resourlist/<id:\d+>' => '/glquesti/resource/index',
                '/glquesti/preview/<id:\d+>' => '/glquesti/preview/index',
                '/glquesti/basic1/<id:\d+>' => '/glquesti/basic1/index',
                '/glquesti/basic2/<id:\d+>' => '/glquesti/basic2/index',
                '/glquesti/basic3/<id:\d+>' => '/glquesti/basic3/index',
                '/glquesti/basic4/<id:\d+>' => '/glquesti/basic4/index',
                '/glquesti/basic5/<id:\d+>' => '/glquesti/basic5/index',
                '/lequesti/tree/<id:\d+>' => '/lequesti/tree/index',
                '/lequesti/list/<id:\d+>' => '/lequesti/list/index',
                '/lequesti/resourlist/<id:\d+>' => '/lequesti/resource/index',
                '/lequesti/preview/<id:\d+>' => '/lequesti/preview/index',
                '/glexam/basic/<id:\d+>' => '/glexam/basic/index',
                '/glexam/question/<id:\d+>' => '/glexam/question/index',
                '/glexam/onekeyrule/<id:\d+>' => '/glexam/onekeyrule/index',
                '/glexam/pigai/<id:\d+>' => '/glexam/pigai/index',
                '/glexam/pigaichou/<id:\d+>' => '/glexam/pigaichou/index',
                '/glexam/preview/<id:\d+>' => '/glexam/preview/index',
                '/glexam/tongji/<id:\d+>' => '/glexam/tongji/index',
                '/glexam/result/<id:\d+>' => '/glexam/result/index',
                '/glexam/export/<id:\d+>' => '/glexam/export/index',
                '/glexam/exportpaper/<id:\d+>' => '/glexam/exportpaper/index',
                '/glexam/exportperson/<id:\d+>' => '/glexam/exportperson/index',
                '/glqcourse/special/<id:\d+>' => '/glqcourse/special/index',
                '/glqcourse/tree/<id:\d+>' => '/glqcourse/tree/index',
                '/glqcourse/list/<id:\d+>' => '/glqcourse/list/index',
                '/glqcourse/chapter/<id:\d+>' => '/glqcourse/chapter/index',
                '/glqcourse/section/<id:\d+>-<parentid:\d+>' => '/glqcourse/section/index',
                '/glqcourse/knowled/<id:\d+>-<parentid:\d+>' => '/glqcourse/knowled/index',
                '/glqcourse/leader/<id:\d+>' => '/glqcourse/leader/index',
                '/doexam/question/<id:\d+>' => '/doexam/question/index',
                '/doexam/result/<id:\d+>' => '/doexam/result/index',
                '/doexam/questionchou/<id:\d+>' => '/doexam/questionchou/index',
                '/doexam/resultchou/<id:\d+>' => '/doexam/resultchou/index',
                '/glxzclass/student/<id:\d+>' => '/glxzclass/student/index',
            ],
        ],
        'cache' => [
            'class' => 'yii\caching\FileCache',
            'cachePath' => '@runtime/cache',
        ],
    ],
	'modules' => [
        'glconfig' => [
            'class' => 'app\modules\glconfig\Module',
        ],
        'glexam' => [
            'class' => 'app\modules\glexam\Module',
        ],
        'glnotice' => [
            'class' => 'app\modules\glnotice\Module',
        ],
        'glqcourse' => [
            'class' => 'app\modules\glqcourse\Module',
        ],
        'glquesti' => [
            'class' => 'app\modules\glquesti\Module',
        ],
        'glspecial' => [
            'class' => 'app\modules\glspecial\Module',
        ],
        'gluser' => [
            'class' => 'app\modules\gluser\Module',
        ],
        'glxzclass' => [
            'class' => 'app\modules\glxzclass\Module',
        ],
        'doexam' => [
            'class' => 'app\modules\doexam\Module',
        ],
        'lequesti' => [
            'class' => 'app\modules\lequesti\Module',
        ],
        'gltongji' => [
            'class' => 'app\modules\gltongji\Module',
        ],
        'user' => [
            'class' => 'app\modules\user\Module',
        ],
        'secret' => [
            'class' => 'app\modules\secret\Module',
        ],
        'helper' => [
            'class' => 'app\modules\helper\Module',
        ],
        'lespecial' => [
            'class' => 'app\modules\lespecial\Module',
        ],
        'yidong' => [
            'class' => 'app\modules\yidong\Module',
        ]
    ],
    'params' => $params,
];

if (YII_ENV_DEV) {
    // configuration adjustments for 'dev' environment
    $config['bootstrap'][] = 'debug';
    $config['modules']['debug'] = [
        'class' => 'yii\debug\Module',
        'allowedIPs' => ['127.0.0.1','192.168.1.150']
    ];

    $config['bootstrap'][] = 'gii';
    $config['modules']['gii'] = [
        'class' => 'yii\gii\Module',
    ];
}

return $config;

?>