<?php
namespace app\controllers;

use Yii;
use yii\web\Controller;
use yii\web\Cookie;
use app\models\Config;
use app\components\SafetyHelper;
use app\components\AccessControl;
use app\components\AuthcodeHelper;

class LoginController extends Controller
{
	private $userobj; //用户登录信息
	private $request; //Yii::$app->request对象
	public $layout = "@app/views/layouts/main";
	
    public function init(){
		$this->request = Yii::$app->request;
		SafetyHelper::FireWallWorks();
	}
	
	public function beforeAction($action) {
		$this->view->params["navicode"] = "login";
		$this->view->params["meta_title"] = "用户登录 - ";
		return true;
	}
	
	//登录页面
	public function actionIndex(){
		$config = Config::find()->where("id=1")->one();
		return $this->render("index", ["config"=>$config]);
	}
	
	//登录验证(ajax)
	public function actionLoginok(){
		$csrfok = 	Yii::$app->getRequest()->validateCsrfToken();
		if(!$csrfok){
			$result = ["code"=>"failed","msg"=>"无权访问","url"=>""];
			echo json_encode($result);
			die();
		}
		$username = $this->request->post("username");
		$username = htmlspecialchars(strip_tags(trim($username)));
		if(empty($username)){
			$result = ["code"=>"failed","msg"=>"用户名不能为空","url"=>""];
			echo json_encode($result);
			die();
		}
		$password = $this->request->post("password");
		$password = htmlspecialchars(strip_tags(trim($password)));
		if(empty($password)){
			$result = ["code"=>"failed","msg"=>"密码不能为空","url"=>""];
			echo json_encode($result);
			die();
		}
		$remember = $this->request->post("remember");
		$remember = htmlspecialchars(strip_tags(trim($remember)));
		if(empty($remember) || is_numeric($remember)==false){
			$remember = 0;
		}
		$verifycode = $this->request->post("verifycode");
		$verifycode = htmlspecialchars(strip_tags(trim($verifycode)));
		if(empty($verifycode)){
			$result = ["code"=>"failed","msg"=>"验证码不能为空","url"=>""];
			echo json_encode($result);
			die();
		}
		$cookiekey = Yii::$app->params["verify_cookiekey"];
		$cookiename = Yii::$app->params["verify_cookiename"];
		$cookies = Yii::$app->request->cookies;
		if(empty($cookies[$cookiename])){
			$result = ["code"=>"failed","msg"=>"系统错误，请刷新后重试","url"=>""];
			echo json_encode($result);
			die();
		}
		$cookievalue = $cookies[$cookiename]->value;
		$cookievalue = AuthcodeHelper::authcode($cookievalue, "DECODE", $cookiekey, 0);
		if(strtolower($verifycode)!=strtolower($cookievalue)){
			$result = ["code"=>"failed","msg"=>"验证码错误","url"=>""];
			echo json_encode($result);
			die();
		}
		$userid = AccessControl::Login($username, $password, $remember);
		if($userid>0){
			$result = ["code"=>"success","msg"=>"成功","url"=>Yii::$app->params["user_home"]];
		}elseif($userid==0){
			$result = ["code"=>"failed","msg"=>"用户不存在","url"=>""];
		}elseif($userid==-1){
			$result = ["code"=>"failed","msg"=>"密码错误","url"=>""];
		}elseif($userid==-2){
			$result = ["code"=>"failed","msg"=>"您的账户尚未审核，请联系管理员","url"=>""];
		}elseif($userid==-3){
			$result = ["code"=>"failed","msg"=>"您的账户已被锁定，请联系管理员","url"=>""];
		}else{
			$result = ["code"=>"failed","msg"=>"发生未知错误","url"=>""];
		}
		echo json_encode($result);
	}
	
}
?>