<?php
namespace app\controllers;

use Yii;
use yii\web\Controller;
use app\components\AccessControl;
use app\components\VisitorHelper;

class LogoutController extends Controller
{
	
	private $userobj; //用户登录信息
	public $layout = "@app/views/layouts/main";

    public function init(){
		$this->userobj = AccessControl::isLogin();
	}
	
	public function beforeAction($action) {
		$this->view->params["meta_title"] = "用户注销 - ";
		return true;
	}
	
	//用户退出
	public function actionIndex(){
		AccessControl::Logout();
		$result = ["code"=>"success","msg"=>"您已退出...","url"=>"/"];
		return $this->render("index", ["result"=>$result]);
	}
		
}
?>