<?php
namespace app\controllers;

use Yii;
use yii\web\Controller;
use app\models\Config;
use app\models\Notice;
use app\components\AccessControl;
use app\components\WarningHelper;

class NoticeController extends Controller
{
	private $userobj; //用户登录信息
	private $request; //Yii::$app->request对象
	public $layout = "@app/views/layouts/main";
	
	public function init(){
		$this->userobj = AccessControl::isLogin();
		$this->request = Yii::$app->request;
	}
	
	public function beforeAction($action) {
		$this->view->params["navicode"] = "notice";
		$this->view->params["meta_title"] = "系统公告 - ";
		$this->view->params["meta_keywords"] = "";
		$this->view->params["meta_description"] = "";
		return true;
	}
	
	//公告详情
	public function actionIndex(){
		$noticeid = $this->request->get("id");
		$noticeid = htmlspecialchars(strip_tags(trim($noticeid)));
		if(empty($noticeid) || is_numeric($noticeid)==false){
			WarningHelper::warning("参数错误",""); die();
		}else{
			$notice = Notice::find()->where("id=". $noticeid)->one();
			if(empty($notice)){
				WarningHelper::warning("公告不存在",""); die();
			}
		}
		if($notice->missing==1 && $this->userobj->roleid!=1){
			WarningHelper::warning("公告已被删除",""); die();
		}
		return $this->render("index", ["notice"=>$notice]);
	}
	
}
?>