<?php
namespace app\controllers;

use Yii;
use yii\web\Controller;
use app\models\Config;
use app\models\User;
use app\models\Role;
use app\models\Schoolclass;
use app\models\Specialty;
use app\components\SafetyHelper;
use app\components\AccessControl;
use app\components\UserHelper;
use app\components\SpecialtyHelper;
use app\components\WarningHelper;

class RegisterController extends Controller
{
	private $userobj; //用户登录信息
	private $request; //Yii::$app->request对象
	public $layout = "@app/views/layouts/main";
	
    public function init(){
		$this->request = Yii::$app->request;
		SafetyHelper::FireWallWorks();
	}
	
	public function beforeAction($action) {
		$this->view->params["navicode"] = "register";
		$this->view->params["meta_title"] = "用户注册 - ";
		return true;
	}
	
	//注册页面
	public function actionIndex(){
		$config = Config::find()->where("id=1")->one();
		if($config->isregist!=1){
			WarningHelper::warning("注册已关闭", "/");
			die();
		}
		$roles = Role::find()->where("id in (3,4,5,6)")->all();
		$colleges = SpecialtyHelper::getCollegelistall();
		return $this->render("index", ["roles"=>$roles, "colleges"=>$colleges]);
	}
	
	//注册验证(ajax)
	public function actionBasicok(){
		$csrfok = 	Yii::$app->getRequest()->validateCsrfToken();
		if(!$csrfok){
			$result = ["code"=>"failed","msg"=>"无权访问"];
			echo json_encode($result);
			die();
		}
		$config = Config::find()->where("id=1")->one();
		if($config->isregist!=1){
			$result = ["code"=>"failed","msg"=>"注册已关闭"];
			echo json_encode($result);
			die();
		}
		$userid = 0;
		$roleid = $this->request->post("roleid");
		$roleid = htmlspecialchars(strip_tags(trim($roleid)));
		$specialid = $this->request->post("specialid");
		$specialid = htmlspecialchars(strip_tags(trim($specialid)));
		$xzclassid = $this->request->post("xzclassid");
		$xzclassid = htmlspecialchars(strip_tags(trim($xzclassid)));
		$username = $this->request->post("username");
		$username = htmlspecialchars(strip_tags(trim($username)));
		$password = $this->request->post("password");
		$password = htmlspecialchars(strip_tags(trim($password)));
		$realname = $this->request->post("realname");
		$realname = htmlspecialchars(strip_tags(trim($realname)));
		$stdnumber = $this->request->post("stdnumber");
		$stdnumber = htmlspecialchars(strip_tags(trim($stdnumber)));
		$male = $this->request->post("male");
		$male = htmlspecialchars(strip_tags(trim($male)));
		$email = $this->request->post("email");
		$email = htmlspecialchars(strip_tags(trim($email)));

		if(empty($username)){
			echo json_encode(["code"=>"failed", "msg"=>"用户名不能为空"]);
			die();
		}
		$json = UserHelper::sameUsername($username, $userid);
		$result = json_decode($json);
		if($result->code!="success"){
			echo json_encode(["code"=>"failed", "msg"=>$result->msg]);
			die();
		}
		if(empty($password)){
			echo json_encode(["code"=>"failed", "msg"=>"密码不能为空"]);
			die();
		}
		if(empty($realname)){
			echo json_encode(["code"=>"failed", "msg"=>"姓名不能为空"]);
			die();
		}
		if(empty($stdnumber)){
			echo json_encode(["code"=>"failed", "msg"=>"学号不能为空"]);
			die();
		}
		$json = UserHelper::sameStdnumber($stdnumber, $userid);
		$result = json_decode($json);
		if($result->code!="success"){
			echo json_encode(["code"=>"failed", "msg"=>$result->msg]);
			die();
		}
		if(empty($logo)){
			$logo = "";
		}
		if($male==1 || $male==2){
			//do nothing
		}else{
			$male = 0;
		}
		if(!empty($email)){
			$json = UserHelper::sameEmailbox($email, $userid);
			$result = json_decode($json);
			if($result->code!="success"){
				echo json_encode(["code"=>"failed", "msg"=>$result->msg]);
				die();
			}
		}
		if(!empty($specialid) && is_numeric($specialid)){
			$specialty = Specialty::find()->where("nodetype=3 and id=". $specialid)->one();
			if(empty($specialty)){
				echo json_encode(["code"=>"failed", "msg"=>"所属专业错误"]);
				die();
			}
			$specialpath = $specialty->nodepath;
		}else{
			$specialid = 0;
			$specialpath = "";
		}
		if(empty($xzclassid) || is_numeric($xzclassid)==false){
			$xzclassid = 0;
		}
		if($roleid==3 || $roleid==4 || $roleid==5 || $roleid==6){
			//...
		}else{
			echo json_encode(["code"=>"failed", "msg"=>"角色错误"]);
			die();
		}
		$user = new User();
		$user->roleid = $roleid;
		$user->groupid = $roleid;
		$user->salt = md5(uniqid(md5(microtime(true)),true));
		$user->regtime = date("Y-m-d H:i:s");
		$user->regip = $this->request->getUserIP();
		$user->isactive = 0;
		$user->token = md5(uniqid(md5(microtime(true)),true));
		$user->username = $username;
		$user->realname = $realname;
		$user->stdnumber = $stdnumber;
		$user->password = md5($password . $user->salt);
		$user->male = $male;
		$user->email = $email;
		$user->specialid = $specialid;
		$user->specialpath = $specialpath;
		$user->xzclassid = $xzclassid;
		$user->leadspecialids = ",0,";
		$user->leadcourseidszyk = ",0,";
		$user->save();
		echo json_encode(["code"=>"success","msg"=>"成功"]);
	}
	
	//根据专业切换班级
	public function actionXzclasslist(){
		$specialid = $this->request->post("specialid");
		$xzclassid = $this->request->post("xzclassid");
		if(empty($specialid) || !is_numeric($specialid)){
			echo '<option>参数错误</option>';
			die();
		}
		$html = '<option>请选择</option>';
		$xzclasses = Schoolclass::find()->select("id,name")->where("find_in_set('". $specialid ."',specialpath)")->orderby("spelling asc")->all();
		foreach ($xzclasses as $oneclass) {
			$html .= '<option value="'. $oneclass->id .'"';
			if($xzclassid==$oneclass->id){
				$html .= ' selected';
			}
			$html .= '>'. $oneclass->name .'</option>';
		}
		echo $html;
	}

	//注册成功
	public function actionWaiting(){
		return $this->render("waiting");
	}

}
?>