<?php
namespace app\controllers;

use Yii;
use yii\web\Controller;
use app\models\Config;
use app\models\Resour;
use app\models\Notice;
use app\models\Friendlink;
use app\components\AccessControl;

class SiteController extends Controller
{
	private $userobj; //用户登录信息
	private $request; //Yii::$app->request对象
	public $layout = "@app/views/layouts/main";
	
	public function init(){
		$this->userobj = AccessControl::isLogin();
		$this->request = Yii::$app->request;
	}
	
	public function beforeAction($action) {
		$this->view->params["navicode"] = "home";
		$this->view->params["meta_title"] = "";
		return true;
	}
	
	//首页
	public function actionIndex(){
		$config = Config::find()->where("id=1")->one();
		return $this->render("index", ["config"=>$config, "userobj"=>$this->userobj]);
	}
	
	//错误页
	public function actionError(){
		$this->view->params["navicode"] = "error";
		return $this->render("error");
	}
	
}
?>