/*
Navicat MySQL Data Transfer

Source Server         : localhost
Source Server Version : 50520
Source Host           : localhost:4406
Source Database       : yuexam_empty

Target Server Type    : MYSQL
Target Server Version : 50520
File Encoding         : 65001

Date: 2019-03-02 18:49:40
*/

SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for config
-- ----------------------------
DROP TABLE IF EXISTS `config`;
CREATE TABLE `config` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `code` varchar(50) NOT NULL DEFAULT '' COMMENT '配置代码',
  `name` varchar(100) NOT NULL DEFAULT '' COMMENT '网站名称',
  `domain` varchar(100) NOT NULL DEFAULT '' COMMENT '网站域名',
  `icpno` varchar(100) NOT NULL DEFAULT '' COMMENT 'icp备案号',
  `logo` varchar(500) NOT NULL DEFAULT '' COMMENT '网站图标',
  `keywords` varchar(100) NOT NULL DEFAULT '' COMMENT '网站关键词',
  `description` varchar(500) NOT NULL DEFAULT '' COMMENT '网站描述',
  `serialkey` varchar(100) NOT NULL DEFAULT '' COMMENT '序列号',
  `copyright` varchar(100) DEFAULT '' COMMENT '版权所有',
  `isregist` tinyint(2) NOT NULL DEFAULT '0' COMMENT '开放注册:1是0否',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='系统配置参数';

-- ----------------------------
-- Records of config
-- ----------------------------
INSERT INTO `config` VALUES ('1', 'main', '鱼知凡考试管理系统', 'http://oa.iefeel.com', '豫ICP备17013669号-1', '/public/images/logo.png', '', '', '', 'oa.iefeel.com', '1');

-- ----------------------------
-- Table structure for doexam
-- ----------------------------
DROP TABLE IF EXISTS `doexam`;
CREATE TABLE `doexam` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `userid` int(10) NOT NULL DEFAULT '0' COMMENT '学生id',
  `examid` int(10) NOT NULL DEFAULT '0' COMMENT '考试id',
  `specialid` int(10) NOT NULL DEFAULT '0' COMMENT '专业id',
  `courseid` int(10) NOT NULL DEFAULT '0' COMMENT '课程id',
  `isdone` tinyint(2) NOT NULL DEFAULT '0' COMMENT '状态:0未做,1保存进度,2已提交,3已批改',
  `howlong` int(10) DEFAULT '0' COMMENT '用多长时间完成的试卷，单位分钟',
  `cometime` datetime DEFAULT NULL COMMENT '做考试时间',
  `points` double NOT NULL DEFAULT '0' COMMENT '考试得分',
  `checkerid` int(10) NOT NULL DEFAULT '0' COMMENT '批改人id',
  `checktime` datetime DEFAULT NULL COMMENT '批改时间',
  `remark` mediumtext COMMENT '评语',
  `username` varchar(50) DEFAULT '' COMMENT '学生用户名',
  `stdnumber` varchar(50) DEFAULT '' COMMENT '学生学号',
  `realname` varchar(100) DEFAULT '' COMMENT '学生姓名',
  `xzclassid` int(10) NOT NULL DEFAULT '0' COMMENT '行政班级id',
  `isarchived` int(10) NOT NULL DEFAULT '0' COMMENT '是否已存档,大于0表示年份',
  `trychouti` int(10) NOT NULL DEFAULT '0' COMMENT '抽题重试次数',
  PRIMARY KEY (`id`),
  KEY `doexam_index_userid` (`userid`),
  KEY `doexam_index_examid` (`examid`),
  KEY `doexam_index_specialid` (`specialid`),
  KEY `doexam_index_courseid` (`courseid`),
  KEY `doexam_index_isdone` (`isdone`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='学生考试';

-- ----------------------------
-- Records of doexam
-- ----------------------------

-- ----------------------------
-- Table structure for doexam_answer
-- ----------------------------
DROP TABLE IF EXISTS `doexam_answer`;
CREATE TABLE `doexam_answer` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `userid` int(10) NOT NULL DEFAULT '0' COMMENT '学生id',
  `examid` int(10) NOT NULL DEFAULT '0' COMMENT '考试id',
  `stemid` int(10) NOT NULL DEFAULT '0' COMMENT '题干id',
  `points` double NOT NULL DEFAULT '0' COMMENT '题目得分',
  `qbank_stemid` int(10) DEFAULT '0' COMMENT '试题库题目id',
  `answer` mediumtext COMMENT '我的答案',
  PRIMARY KEY (`id`),
  KEY `doexam_answer_index_userid` (`userid`),
  KEY `doexam_answer_index_examid` (`examid`),
  KEY `doexam_answer_index_stemid` (`stemid`),
  KEY `doexam_answer_index_qbank_stemid` (`qbank_stemid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='学生考试答案';

-- ----------------------------
-- Records of doexam_answer
-- ----------------------------

-- ----------------------------
-- Table structure for doexam_attache
-- ----------------------------
DROP TABLE IF EXISTS `doexam_attache`;
CREATE TABLE `doexam_attache` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `examid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '考试id',
  `userid` int(10) NOT NULL DEFAULT '0' COMMENT '用户id',
  `title` varchar(100) DEFAULT '' COMMENT '附件名称',
  `filepath` varchar(500) NOT NULL DEFAULT '' COMMENT '附件地址',
  `fileext` varchar(50) DEFAULT '' COMMENT '文件格式',
  `filesize` double NOT NULL DEFAULT '0' COMMENT '文件大小',
  `cometime` datetime DEFAULT NULL COMMENT '上传时间',
  `filemd5` varchar(50) DEFAULT '' COMMENT '文件Md5',
  `logo` varchar(500) NOT NULL DEFAULT '' COMMENT '封面图片',
  `isconverted` tinyint(2) NOT NULL DEFAULT '0' COMMENT '转换状态:0未转换,1成功,2失败,3转换中',
  `swfpath` varchar(500) NOT NULL DEFAULT '' COMMENT '转换后的文件路径',
  `totalpage` int(10) NOT NULL DEFAULT '0' COMMENT '转换后的图片数量',
  `convert2ext` varchar(50) NOT NULL DEFAULT '' COMMENT '转换后的文件格式',
  PRIMARY KEY (`id`),
  KEY `doexam_attache_index_examid` (`examid`),
  KEY `doexam_attache_index_userid` (`userid`),
  KEY `doexam_attache_index_isconverted` (`isconverted`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='学生考试附件';

-- ----------------------------
-- Records of doexam_attache
-- ----------------------------

-- ----------------------------
-- Table structure for exam
-- ----------------------------
DROP TABLE IF EXISTS `exam`;
CREATE TABLE `exam` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `userid` int(10) NOT NULL DEFAULT '0' COMMENT '用户id',
  `specialid` int(10) NOT NULL DEFAULT '0' COMMENT '专业id',
  `courseid` int(10) NOT NULL DEFAULT '0' COMMENT '课程id',
  `typeid` tinyint(1) NOT NULL DEFAULT '1' COMMENT '考试类型:1试题,2附件',
  `title` varchar(100) NOT NULL DEFAULT '' COMMENT '考试名称',
  `points` double DEFAULT '0' COMMENT '总分数',
  `cometime` datetime DEFAULT NULL COMMENT '创建时间',
  `begintime` datetime DEFAULT NULL COMMENT '开始时间',
  `endtime` datetime DEFAULT NULL COMMENT '截止时间',
  `forclass` varchar(500) DEFAULT '' COMMENT '适用班级:,1,2,3,...',
  `persons` int(10) NOT NULL DEFAULT '0' COMMENT '总人数',
  `finished` int(10) NOT NULL DEFAULT '0' COMMENT '已经提交的数量',
  `ispublish` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否发布:0未发布,1已发布',
  `ischecked` int(10) NOT NULL DEFAULT '0' COMMENT '试卷状态:0未批改,1批改中,2已批改',
  `questway` tinyint(4) NOT NULL DEFAULT '0' COMMENT '组卷方式:0题库选取,1随机组卷,2学生抽题',
  `questnum` int(10) NOT NULL DEFAULT '0' COMMENT '题目总数量',
  `quest1num` int(10) NOT NULL DEFAULT '0' COMMENT '单选题数量',
  `quest2num` int(10) NOT NULL DEFAULT '0' COMMENT '多选题数量',
  `quest3num` int(10) NOT NULL DEFAULT '0' COMMENT '判断题数量',
  `quest4num` int(10) NOT NULL DEFAULT '0' COMMENT '填空题数量',
  `quest5num` int(10) NOT NULL DEFAULT '0' COMMENT '问答题数量',
  `quest1points` double NOT NULL DEFAULT '0' COMMENT '单选题总分',
  `quest2points` double NOT NULL DEFAULT '0' COMMENT '多选题总分',
  `quest3points` double NOT NULL DEFAULT '0' COMMENT '判断题总分',
  `quest4points` double NOT NULL DEFAULT '0' COMMENT '填空题总分',
  `quest5points` double NOT NULL DEFAULT '0' COMMENT '问答题总分',
  `pigaioknum` int(10) NOT NULL DEFAULT '0' COMMENT '已批改的数量',
  `pigainonum` int(10) NOT NULL DEFAULT '0' COMMENT '未批改的数量',
  `specialpath` varchar(200) DEFAULT '' COMMENT '专业节点路径',
  `descrip` mediumtext COMMENT '考试说明',
  `isarchived` int(10) NOT NULL DEFAULT '0' COMMENT '是否已存档,大于0表示年份',
  `isfreed` tinyint(2) NOT NULL DEFAULT '0' COMMENT '是否释放题目:1是0否',
  `maxchouti` int(10) NOT NULL DEFAULT '0' COMMENT '抽题重试次数',
  `chouti_courseid` int(10) NOT NULL DEFAULT '0' COMMENT '随机组卷范围(课程id)',
  `chouti_coursename` varchar(100) DEFAULT '' COMMENT '随机组卷范围(课程名称)',
  `chouti_treeid` int(10) NOT NULL DEFAULT '0' COMMENT '随机组卷范围(章节id)',
  `chouti_treename` varchar(100) DEFAULT '' COMMENT '随机组卷范围(章节名称)',
  `qtypejson` text COMMENT '组卷题型和数量',
  PRIMARY KEY (`id`),
  KEY `exam_index_userid` (`userid`),
  KEY `exam_index_specialid` (`specialid`),
  KEY `exam_index_courseid` (`courseid`),
  KEY `exam_index_ispublish` (`ispublish`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='考试';

-- ----------------------------
-- Records of exam
-- ----------------------------

-- ----------------------------
-- Table structure for exam_attache
-- ----------------------------
DROP TABLE IF EXISTS `exam_attache`;
CREATE TABLE `exam_attache` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `examid` int(10) NOT NULL DEFAULT '0' COMMENT '考试id',
  `title` varchar(100) DEFAULT '' COMMENT '附件名称',
  `filepath` varchar(500) NOT NULL DEFAULT '' COMMENT '附件地址',
  `fileext` varchar(50) DEFAULT '' COMMENT '文件格式',
  `filesize` double NOT NULL DEFAULT '0' COMMENT '文件大小',
  `cometime` datetime DEFAULT NULL COMMENT '上传时间',
  `filemd5` varchar(100) DEFAULT '' COMMENT '文件Md5',
  `logo` varchar(500) NOT NULL DEFAULT '' COMMENT '封面图片',
  `isconverted` tinyint(2) NOT NULL DEFAULT '0' COMMENT '转换状态:0未转换,1成功,2失败,3转换中',
  `swfpath` varchar(500) NOT NULL DEFAULT '' COMMENT '转换后的文件路径',
  `totalpage` int(10) NOT NULL DEFAULT '0' COMMENT '转换后的图片数量',
  `convert2ext` varchar(50) NOT NULL DEFAULT '' COMMENT '转换后的文件格式',
  PRIMARY KEY (`id`),
  KEY `exam_attache_index_examid` (`examid`),
  KEY `exam_attache_index_isconverted` (`isconverted`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='考试附件';

-- ----------------------------
-- Records of exam_attache
-- ----------------------------

-- ----------------------------
-- Table structure for exam_onekey
-- ----------------------------
DROP TABLE IF EXISTS `exam_onekey`;
CREATE TABLE `exam_onekey` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `specialid` int(10) NOT NULL DEFAULT '0' COMMENT '专业id',
  `courseid` int(10) NOT NULL DEFAULT '0' COMMENT '课程id',
  `examid` int(10) NOT NULL DEFAULT '0' COMMENT '考试id',
  `score_lower` double DEFAULT '0' COMMENT '得分区间下限',
  `score_upper` double DEFAULT '0' COMMENT '得分区间上限',
  `remark` text COMMENT '评语',
  `cometime` datetime DEFAULT NULL COMMENT '添加时间',
  PRIMARY KEY (`id`),
  KEY `exam_onekey_index_examid` (`examid`),
  KEY `exam_onekey_index_specialid` (`specialid`),
  KEY `exam_onekey_index_courseid` (`courseid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='考试一键批改规则';

-- ----------------------------
-- Records of exam_onekey
-- ----------------------------

-- ----------------------------
-- Table structure for exam_option
-- ----------------------------
DROP TABLE IF EXISTS `exam_option`;
CREATE TABLE `exam_option` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `specialid` int(10) NOT NULL DEFAULT '0' COMMENT '专业id',
  `courseid` int(10) NOT NULL DEFAULT '0' COMMENT '课程id',
  `examid` int(10) NOT NULL DEFAULT '0' COMMENT '考试id',
  `stemid` int(10) NOT NULL DEFAULT '0' COMMENT '题干id',
  `code` varchar(10) NOT NULL DEFAULT '' COMMENT '选项字母编号',
  `content` mediumtext COMMENT '选项内容',
  `isanswer` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否是正确答案,0:否，1：是',
  PRIMARY KEY (`id`),
  KEY `exam_option_index_stemid` (`stemid`),
  KEY `exam_option_index_examid` (`examid`),
  KEY `exam_option_index_courseid` (`courseid`),
  KEY `exam_option_index_specialid` (`specialid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='考试题目选项';

-- ----------------------------
-- Records of exam_option
-- ----------------------------

-- ----------------------------
-- Table structure for exam_stem
-- ----------------------------
DROP TABLE IF EXISTS `exam_stem`;
CREATE TABLE `exam_stem` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `specialid` int(10) NOT NULL DEFAULT '0' COMMENT '专业id',
  `courseid` int(10) NOT NULL DEFAULT '0' COMMENT '课程id',
  `treeid` int(10) NOT NULL DEFAULT '0' COMMENT '知识点id',
  `examid` int(10) NOT NULL DEFAULT '0' COMMENT '考试id',
  `typeid` int(10) NOT NULL DEFAULT '0' COMMENT '题目类型',
  `levels` smallint(2) DEFAULT '1' COMMENT '难度系数',
  `points` double NOT NULL DEFAULT '0' COMMENT '题目分数',
  `optionnum` int(10) NOT NULL DEFAULT '0' COMMENT '选项数量',
  `qbank_stemid` int(10) DEFAULT '0' COMMENT '试题库题目id',
  `content` mediumtext COMMENT '题干内容',
  `answer` mediumtext COMMENT '正确答案',
  `explains` mediumtext COMMENT '题目解析',
  `typechild` int(10) NOT NULL DEFAULT '0' COMMENT '题目子类型',
  PRIMARY KEY (`id`),
  KEY `exam_stem_index_examid` (`examid`),
  KEY `exam_stem_index_courseid` (`courseid`),
  KEY `exam_stem_index_specialid` (`specialid`),
  KEY `exam_stem_index_qbank_stemid` (`qbank_stemid`),
  KEY `exam_stem_index_typechild` (`typechild`),
  KEY `exam_stem_index_typeid` (`typeid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='考试题目题干';

-- ----------------------------
-- Records of exam_stem
-- ----------------------------

-- ----------------------------
-- Table structure for friendlink
-- ----------------------------
DROP TABLE IF EXISTS `friendlink`;
CREATE TABLE `friendlink` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `userid` int(10) NOT NULL DEFAULT '0' COMMENT '用户id',
  `name` varchar(100) NOT NULL DEFAULT '' COMMENT '名称',
  `linkurl` varchar(200) NOT NULL DEFAULT '' COMMENT '链接地址',
  `logo` varchar(500) NOT NULL DEFAULT '' COMMENT '网站图标',
  `sortid` int(10) NOT NULL DEFAULT '0' COMMENT '排序,正序',
  `isseen` int(10) NOT NULL DEFAULT '0' COMMENT '显示方式:1文字,2图标',
  `color` varchar(50) NOT NULL DEFAULT '' COMMENT '颜色编码',
  `cometime` datetime DEFAULT NULL COMMENT '创建时间',
  `starttime` datetime DEFAULT NULL COMMENT '有效期起始',
  `stoptime` datetime DEFAULT NULL COMMENT '有效期截止',
  `missing` int(10) NOT NULL DEFAULT '0' COMMENT '是否被删除:1是0否',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='友情链接';

-- ----------------------------
-- Records of friendlink
-- ----------------------------

-- ----------------------------
-- Table structure for mediatype
-- ----------------------------
DROP TABLE IF EXISTS `mediatype`;
CREATE TABLE `mediatype` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `name` varchar(50) NOT NULL DEFAULT '' COMMENT '类型名称',
  `sortid` int(10) NOT NULL DEFAULT '0' COMMENT '排序(升序)',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 COMMENT='系统内置媒体类型';

-- ----------------------------
-- Records of mediatype
-- ----------------------------
INSERT INTO `mediatype` VALUES ('1', '文本类', '10');
INSERT INTO `mediatype` VALUES ('2', '图形/图像类', '20');
INSERT INTO `mediatype` VALUES ('3', '音频类', '30');
INSERT INTO `mediatype` VALUES ('4', '视频类', '40');
INSERT INTO `mediatype` VALUES ('5', '动画类', '50');
INSERT INTO `mediatype` VALUES ('6', '虚拟仿真类', '55');
INSERT INTO `mediatype` VALUES ('7', '其他素材', '90');
INSERT INTO `mediatype` VALUES ('8', 'PPT演示文稿', '60');
INSERT INTO `mediatype` VALUES ('9', '网页课件', '70');
INSERT INTO `mediatype` VALUES ('10', '富媒体', '80');

-- ----------------------------
-- Table structure for notice
-- ----------------------------
DROP TABLE IF EXISTS `notice`;
CREATE TABLE `notice` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `userid` int(10) NOT NULL DEFAULT '0' COMMENT '用户id',
  `title` varchar(200) NOT NULL DEFAULT '' COMMENT '标题',
  `cometime` datetime DEFAULT NULL COMMENT '创建时间',
  `starttime` datetime DEFAULT NULL COMMENT '有效期起始',
  `stoptime` datetime DEFAULT NULL COMMENT '有效期截止',
  `linkurl` varchar(500) NOT NULL DEFAULT '' COMMENT '链接地址',
  `linktarget` varchar(20) NOT NULL DEFAULT '' COMMENT '链接是否新窗口打开',
  `views` int(10) NOT NULL DEFAULT '0' COMMENT '点击次数',
  `missing` int(10) NOT NULL DEFAULT '0' COMMENT '是否被删除:1是0否',
  `color` varchar(50) NOT NULL DEFAULT '' COMMENT '颜色编码',
  `forclass` varchar(500) DEFAULT '' COMMENT '适用班级:,1,2,3,...',
  `content` text COMMENT '公告内容',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='系统公告';

-- ----------------------------
-- Records of notice
-- ----------------------------

-- ----------------------------
-- Table structure for person_option
-- ----------------------------
DROP TABLE IF EXISTS `person_option`;
CREATE TABLE `person_option` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `specialid` int(10) NOT NULL DEFAULT '0' COMMENT '专业id',
  `courseid` int(10) NOT NULL DEFAULT '0' COMMENT '课程id',
  `examid` int(10) NOT NULL DEFAULT '0' COMMENT '考试id',
  `stemid` int(10) NOT NULL DEFAULT '0' COMMENT '题干id',
  `code` varchar(10) NOT NULL DEFAULT '' COMMENT '选项字母编号',
  `content` mediumtext COMMENT '选项内容',
  `isanswer` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否是正确答案,0:否，1：是',
  `studentid` int(10) NOT NULL DEFAULT '0' COMMENT '学生id',
  PRIMARY KEY (`id`),
  KEY `person_option_index_stemid` (`stemid`),
  KEY `person_option_index_examid` (`examid`),
  KEY `person_option_index_courseid` (`courseid`),
  KEY `person_option_index_specialid` (`specialid`),
  KEY `person_option_index_studentid` (`studentid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='考试题目选项(学生抽题)';

-- ----------------------------
-- Records of person_option
-- ----------------------------

-- ----------------------------
-- Table structure for person_stem
-- ----------------------------
DROP TABLE IF EXISTS `person_stem`;
CREATE TABLE `person_stem` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `specialid` int(10) NOT NULL DEFAULT '0' COMMENT '专业id',
  `courseid` int(10) NOT NULL DEFAULT '0' COMMENT '课程id',
  `treeid` int(10) NOT NULL DEFAULT '0' COMMENT '知识点id',
  `examid` int(10) NOT NULL DEFAULT '0' COMMENT '考试id',
  `typeid` int(10) NOT NULL DEFAULT '0' COMMENT '题目类型',
  `levels` smallint(2) DEFAULT '1' COMMENT '难度系数',
  `points` double NOT NULL DEFAULT '0' COMMENT '题目分数',
  `optionnum` int(10) NOT NULL DEFAULT '0' COMMENT '选项数量',
  `qbank_stemid` int(10) DEFAULT '0' COMMENT '试题库题目id',
  `content` mediumtext COMMENT '题干内容',
  `answer` mediumtext COMMENT '正确答案',
  `explains` mediumtext COMMENT '题目解析',
  `studentid` int(10) NOT NULL DEFAULT '0' COMMENT '学生id',
  `typechild` int(10) NOT NULL DEFAULT '0' COMMENT '题目子类型',
  PRIMARY KEY (`id`),
  KEY `person_stem_index_examid` (`examid`),
  KEY `person_stem_index_courseid` (`courseid`),
  KEY `person_stem_index_specialid` (`specialid`),
  KEY `person_stem_index_qbank_stemid` (`qbank_stemid`),
  KEY `person_stem_index_typechild` (`typechild`),
  KEY `person_stem_index_typeid` (`typeid`),
  KEY `person_stem_index_studentid` (`studentid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='考试题目题干(学生抽题)';

-- ----------------------------
-- Records of person_stem
-- ----------------------------

-- ----------------------------
-- Table structure for questi_option
-- ----------------------------
DROP TABLE IF EXISTS `questi_option`;
CREATE TABLE `questi_option` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `userid` int(11) NOT NULL DEFAULT '0' COMMENT '用户id',
  `typeid` int(11) NOT NULL DEFAULT '0' COMMENT '题目类型',
  `specialid` int(11) NOT NULL DEFAULT '0' COMMENT '专业id',
  `courseid` int(11) NOT NULL DEFAULT '0' COMMENT '课程id,表resour_course中的',
  `treeid` int(11) NOT NULL DEFAULT '0' COMMENT '知识树节点id,表resour_tree中的',
  `treepath` varchar(100) NOT NULL DEFAULT '' COMMENT '知识树节点路径',
  `stemid` int(11) NOT NULL DEFAULT '0' COMMENT '题干id',
  `code` varchar(10) NOT NULL DEFAULT '' COMMENT '选项字母编号',
  `isanswer` tinyint(4) NOT NULL DEFAULT '0' COMMENT '是否是答案:1是0否',
  `content` mediumtext COMMENT '选项内容',
  `typechild` int(10) NOT NULL DEFAULT '0' COMMENT '题目子类型',
  PRIMARY KEY (`id`),
  KEY `questi_option_index_stemid` (`stemid`),
  KEY `questi_option_index_specialid` (`specialid`),
  KEY `questi_option_index_courseid` (`courseid`),
  KEY `questi_option_index_treeid` (`treeid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='题库题目选项';

-- ----------------------------
-- Records of questi_option
-- ----------------------------

-- ----------------------------
-- Table structure for questi_stem
-- ----------------------------
DROP TABLE IF EXISTS `questi_stem`;
CREATE TABLE `questi_stem` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `userid` int(11) NOT NULL DEFAULT '0' COMMENT '用户id',
  `typeid` int(11) NOT NULL DEFAULT '0' COMMENT '题目类型',
  `specialid` int(11) NOT NULL DEFAULT '0' COMMENT '专业id',
  `courseid` int(11) NOT NULL DEFAULT '0' COMMENT '课程id,表resour_course中的',
  `treeid` int(11) NOT NULL DEFAULT '0' COMMENT '知识树节点id,表resour_tree中的',
  `treepath` varchar(200) NOT NULL DEFAULT '' COMMENT '知识树节点路径',
  `optionnum` int(11) NOT NULL DEFAULT '0' COMMENT '选项个数',
  `points` double NOT NULL DEFAULT '10' COMMENT '分数',
  `levels` tinyint(4) NOT NULL DEFAULT '0' COMMENT '难度系数',
  `sortid` int(11) NOT NULL DEFAULT '0' COMMENT '排序,升序',
  `citednum` int(11) NOT NULL DEFAULT '0' COMMENT '被引用次数',
  `totaldone` int(10) DEFAULT '0' COMMENT '总使用次数',
  `cometime` datetime DEFAULT NULL COMMENT '创建时间',
  `content` mediumtext COMMENT '题干内容',
  `contenttext` mediumtext COMMENT '题干文本',
  `answer` mediumtext COMMENT '正确答案',
  `explains` mediumtext COMMENT '题目解析',
  `schoolid` int(10) DEFAULT '0' COMMENT '学校id',
  `originid` varchar(50) DEFAULT '' COMMENT '导入的原始id',
  `reusage` int(10) NOT NULL DEFAULT '0' COMMENT '允许重复使用次数',
  `islocked` tinyint(2) NOT NULL DEFAULT '0' COMMENT '是否禁用:1是0否',
  `maxreusage` int(10) NOT NULL DEFAULT '0' COMMENT '最大重复使用次数,即表resour_course中的reusage',
  `typechild` int(10) NOT NULL DEFAULT '0' COMMENT '题目子类型',
  PRIMARY KEY (`id`),
  KEY `questi_stem_index_typeid` (`typeid`),
  KEY `questi_stem_index_specialid` (`specialid`),
  KEY `questi_stem_index_courseid` (`courseid`),
  KEY `questi_stem_index_treeid` (`treeid`),
  KEY `questi_stem_index_islocked` (`islocked`),
  KEY `questi_stem_index_levels` (`levels`),
  KEY `questi_stem_index_typechild` (`typechild`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='题库题目题干';

-- ----------------------------
-- Records of questi_stem
-- ----------------------------

-- ----------------------------
-- Table structure for questi_type
-- ----------------------------
DROP TABLE IF EXISTS `questi_type`;
CREATE TABLE `questi_type` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `name` varchar(50) NOT NULL DEFAULT '' COMMENT '名称',
  `sortid` int(11) NOT NULL DEFAULT '0' COMMENT '排序,升序',
  `parentid` int(10) NOT NULL DEFAULT '0' COMMENT '父级id',
  PRIMARY KEY (`id`),
  KEY `questi_type_index_parentid` (`parentid`)
) ENGINE=MyISAM AUTO_INCREMENT=13 DEFAULT CHARSET=utf8 COMMENT='题库题目类型';

-- ----------------------------
-- Records of questi_type
-- ----------------------------
INSERT INTO `questi_type` VALUES ('1', '单选', '10', '0');
INSERT INTO `questi_type` VALUES ('2', '多选', '20', '0');
INSERT INTO `questi_type` VALUES ('3', '判断', '30', '0');
INSERT INTO `questi_type` VALUES ('4', '填空', '40', '0');
INSERT INTO `questi_type` VALUES ('5', '问答', '50', '0');
INSERT INTO `questi_type` VALUES ('6', '单选', '10', '1');
INSERT INTO `questi_type` VALUES ('7', '多选', '20', '2');
INSERT INTO `questi_type` VALUES ('8', '判断', '30', '3');
INSERT INTO `questi_type` VALUES ('9', '填空', '40', '4');
INSERT INTO `questi_type` VALUES ('10', '名词解释', '50', '5');
INSERT INTO `questi_type` VALUES ('11', '简答题', '60', '5');
INSERT INTO `questi_type` VALUES ('12', '论述题', '70', '5');

-- ----------------------------
-- Table structure for resour
-- ----------------------------
DROP TABLE IF EXISTS `resour`;
CREATE TABLE `resour` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `userid` int(11) NOT NULL DEFAULT '0' COMMENT '用户id',
  `specialid` int(11) NOT NULL DEFAULT '0' COMMENT '专业id',
  `courseid` int(11) NOT NULL DEFAULT '0' COMMENT '课程id',
  `mediaid` int(11) NOT NULL DEFAULT '0' COMMENT '媒体类型id',
  `applicaid` int(11) NOT NULL DEFAULT '0' COMMENT '应用类型id',
  `treeid` int(11) NOT NULL DEFAULT '0' COMMENT '知识树节点id',
  `treepath` varchar(200) NOT NULL DEFAULT '' COMMENT '知识树节点路径',
  `name` varchar(100) NOT NULL DEFAULT '' COMMENT '资源名称',
  `filepath` varchar(500) NOT NULL DEFAULT '' COMMENT '原始文件路径',
  `filename` varchar(100) NOT NULL DEFAULT '' COMMENT '原始文件名',
  `fileext` varchar(50) NOT NULL DEFAULT '' COMMENT '原始文件后缀',
  `filesize` double NOT NULL DEFAULT '0' COMMENT '原始文件大小(字节)',
  `folder` varchar(50) NOT NULL DEFAULT '' COMMENT '每个素材一个文件夹',
  `logo` varchar(500) NOT NULL DEFAULT '' COMMENT '封面图',
  `isconverted` tinyint(4) NOT NULL DEFAULT '0' COMMENT '转换状态:0未转换,1成功,2失败',
  `previewpath` varchar(500) NOT NULL DEFAULT '' COMMENT '预览文件路径',
  `previewname` varchar(100) NOT NULL DEFAULT '' COMMENT '预览文件名',
  `previewext` varchar(50) NOT NULL DEFAULT '' COMMENT '预览文件后缀',
  `previewpages` int(11) NOT NULL DEFAULT '0' COMMENT '预览图片数量(针对word,ppt,excel,pdf)',
  `sortid` int(11) NOT NULL DEFAULT '0' COMMENT '排序(升序)',
  `views` int(11) NOT NULL DEFAULT '0' COMMENT '浏览量',
  `shares` int(11) NOT NULL DEFAULT '0' COMMENT '分享次数',
  `discuss` int(11) NOT NULL DEFAULT '0' COMMENT '评论次数',
  `score` float NOT NULL DEFAULT '0' COMMENT '评分',
  `missing` int(11) NOT NULL DEFAULT '0' COMMENT '是否被删除:1是0否',
  `cometime` datetime DEFAULT NULL COMMENT '创建时间',
  `keywords` varchar(200) NOT NULL DEFAULT '' COMMENT '关键词',
  `schoolid` int(10) DEFAULT '0' COMMENT '学校id',
  `originid` varchar(50) DEFAULT '' COMMENT '导入的原始id',
  PRIMARY KEY (`id`),
  KEY `resour_index_specialid` (`specialid`),
  KEY `resour_index_courseid` (`courseid`),
  KEY `resour_index_mediaid` (`mediaid`),
  KEY `resour_index_treeid` (`treeid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='资源库素材';

-- ----------------------------
-- Records of resour
-- ----------------------------

-- ----------------------------
-- Table structure for resour_course
-- ----------------------------
DROP TABLE IF EXISTS `resour_course`;
CREATE TABLE `resour_course` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `userid` int(11) NOT NULL DEFAULT '0' COMMENT '用户id',
  `specialid` int(11) NOT NULL DEFAULT '0' COMMENT '专业id',
  `name` varchar(100) NOT NULL DEFAULT '' COMMENT '课程名称',
  `spelling` varchar(500) NOT NULL DEFAULT '' COMMENT '拼音',
  `firstletter` varchar(10) NOT NULL DEFAULT 'Z' COMMENT '首字母',
  `sortid` int(11) NOT NULL DEFAULT '0' COMMENT '排序(升序)',
  `cometime` datetime DEFAULT NULL COMMENT '创建时间',
  `views` int(11) NOT NULL DEFAULT '0' COMMENT '浏览量',
  `missing` int(11) NOT NULL DEFAULT '0' COMMENT '是否被删除:1是0否',
  `logo` varchar(500) NOT NULL DEFAULT '' COMMENT '封面图',
  `resournum` int(11) NOT NULL DEFAULT '0' COMMENT '资源数量',
  `questinum` int(11) NOT NULL DEFAULT '0' COMMENT '题目数量',
  `schoolid` int(10) DEFAULT '0' COMMENT '学校id',
  `originid` varchar(50) DEFAULT '' COMMENT '导入的原始id',
  `isopen` tinyint(2) NOT NULL DEFAULT '0' COMMENT '是否对学生公开:1是,0否',
  `specialpath` varchar(200) DEFAULT '' COMMENT '专业节点路径',
  `reusage` int(10) NOT NULL DEFAULT '0' COMMENT '允许题目重复使用次数',
  PRIMARY KEY (`id`),
  KEY `resour_course_index_specialid` (`specialid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='资源库课程';

-- ----------------------------
-- Records of resour_course
-- ----------------------------

-- ----------------------------
-- Table structure for resour_leader
-- ----------------------------
DROP TABLE IF EXISTS `resour_leader`;
CREATE TABLE `resour_leader` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `specialid` int(10) NOT NULL DEFAULT '0' COMMENT '专业id',
  `courseid` int(10) NOT NULL DEFAULT '0' COMMENT '课程id',
  `userid` int(10) NOT NULL DEFAULT '0' COMMENT '用户id',
  `leadertype` tinyint(2) NOT NULL DEFAULT '1' COMMENT '类型:1负责人,2普通成员',
  `username` varchar(50) DEFAULT '' COMMENT '用户名',
  `stdnumber` varchar(50) DEFAULT '' COMMENT '工号',
  `realname` varchar(100) DEFAULT '' COMMENT '姓名',
  `logo` varchar(500) DEFAULT '' COMMENT '头像',
  PRIMARY KEY (`id`),
  KEY `resour_leader_index_courseid` (`courseid`),
  KEY `resour_leader_index_userid` (`userid`),
  KEY `resour_leader_index_leadertype` (`leadertype`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='资源库课程团队成员';

-- ----------------------------
-- Records of resour_leader
-- ----------------------------

-- ----------------------------
-- Table structure for resour_tree
-- ----------------------------
DROP TABLE IF EXISTS `resour_tree`;
CREATE TABLE `resour_tree` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `userid` int(11) NOT NULL DEFAULT '0' COMMENT '用户id',
  `specialid` int(11) NOT NULL DEFAULT '0' COMMENT '专业id',
  `courseid` int(11) NOT NULL DEFAULT '0' COMMENT '课程id',
  `parentid` int(11) NOT NULL DEFAULT '0' COMMENT '父级id',
  `nodetype` tinyint(4) NOT NULL DEFAULT '0' COMMENT '类型:1章,2节,3知识点',
  `nodepath` varchar(200) NOT NULL DEFAULT '' COMMENT '节点路径',
  `name` varchar(100) NOT NULL DEFAULT '' COMMENT '名称',
  `spelling` varchar(500) NOT NULL DEFAULT '' COMMENT '拼音',
  `firstletter` varchar(10) NOT NULL DEFAULT 'Z' COMMENT '首字母',
  `missing` int(11) NOT NULL DEFAULT '0' COMMENT '是否被删除:1是0否',
  `sortid` int(11) NOT NULL DEFAULT '0' COMMENT '排序(升序)',
  `cometime` datetime DEFAULT NULL COMMENT '创建时间',
  `resournum` int(11) NOT NULL DEFAULT '0' COMMENT '资源数量',
  `questinum` int(11) NOT NULL DEFAULT '0' COMMENT '题目数量',
  `schoolid` int(10) DEFAULT '0' COMMENT '学校id',
  `originid` varchar(50) DEFAULT '' COMMENT '导入的原始id',
  PRIMARY KEY (`id`),
  KEY `resour_tree_index_specialid` (`specialid`),
  KEY `resour_tree_index_courseid` (`courseid`),
  KEY `resour_tree_index_parentid` (`parentid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='资源库章节知识点';

-- ----------------------------
-- Records of resour_tree
-- ----------------------------

-- ----------------------------
-- Table structure for role
-- ----------------------------
DROP TABLE IF EXISTS `role`;
CREATE TABLE `role` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `name` varchar(50) NOT NULL DEFAULT '' COMMENT '角色名称',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COMMENT='角色';

-- ----------------------------
-- Records of role
-- ----------------------------
INSERT INTO `role` VALUES ('1', '超管');
INSERT INTO `role` VALUES ('2', '校长');
INSERT INTO `role` VALUES ('3', '教师');
INSERT INTO `role` VALUES ('4', '学生');
INSERT INTO `role` VALUES ('5', '企业');
INSERT INTO `role` VALUES ('6', '社会学习者');

-- ----------------------------
-- Table structure for role_group
-- ----------------------------
DROP TABLE IF EXISTS `role_group`;
CREATE TABLE `role_group` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `roleid` int(10) NOT NULL DEFAULT '0' COMMENT '角色id',
  `name` varchar(50) NOT NULL DEFAULT '' COMMENT '用户组',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8 COMMENT='用户组';

-- ----------------------------
-- Records of role_group
-- ----------------------------
INSERT INTO `role_group` VALUES ('1', '1', '超管');
INSERT INTO `role_group` VALUES ('2', '2', '校长');
INSERT INTO `role_group` VALUES ('3', '3', '教师');
INSERT INTO `role_group` VALUES ('4', '4', '学生');
INSERT INTO `role_group` VALUES ('5', '5', '企业');
INSERT INTO `role_group` VALUES ('6', '6', '社会学习者');
INSERT INTO `role_group` VALUES ('7', '3', '院系负责人');
INSERT INTO `role_group` VALUES ('8', '3', '专业负责人');
INSERT INTO `role_group` VALUES ('9', '3', '课程负责人');

-- ----------------------------
-- Table structure for schoolclass
-- ----------------------------
DROP TABLE IF EXISTS `schoolclass`;
CREATE TABLE `schoolclass` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `specialid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '专业id',
  `name` varchar(100) NOT NULL DEFAULT '' COMMENT '班级名称',
  `code` varchar(50) DEFAULT '' COMMENT '班级代码',
  `studentnum` int(10) NOT NULL DEFAULT '0' COMMENT '学生人数',
  `grade` int(10) NOT NULL DEFAULT '0' COMMENT '年级',
  `cometime` datetime DEFAULT NULL COMMENT '创建时间',
  `specialpath` varchar(200) DEFAULT '' COMMENT '专业节点路径',
  `spelling` varchar(500) DEFAULT '' COMMENT '汉语拼音',
  `firstletter` varchar(10) DEFAULT 'Z' COMMENT '首字母',
  `isarchived` int(10) NOT NULL DEFAULT '0' COMMENT '是否已存档,大于0表示年份',
  PRIMARY KEY (`id`),
  KEY `schoolclass_index_specialid` (`specialid`),
  KEY `schoolclass_index_grade` (`grade`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='行政班级';

-- ----------------------------
-- Records of schoolclass
-- ----------------------------

-- ----------------------------
-- Table structure for specialty
-- ----------------------------
DROP TABLE IF EXISTS `specialty`;
CREATE TABLE `specialty` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `parentid` int(11) NOT NULL DEFAULT '0' COMMENT '父级id',
  `nodetype` tinyint(4) NOT NULL DEFAULT '0' COMMENT '类型:1院,2系,3专业',
  `nodepath` varchar(200) NOT NULL DEFAULT '' COMMENT '节点路径',
  `name` varchar(100) NOT NULL DEFAULT '' COMMENT '名称',
  `spelling` varchar(500) NOT NULL DEFAULT '' COMMENT '拼音',
  `firstletter` varchar(10) NOT NULL DEFAULT 'Z' COMMENT '首字母',
  `sortid` int(11) NOT NULL DEFAULT '0' COMMENT '排序(升序)',
  `cometime` datetime DEFAULT NULL COMMENT '创建时间',
  `resournum` int(11) NOT NULL DEFAULT '0' COMMENT '资源数量',
  `questinum` int(11) NOT NULL DEFAULT '0' COMMENT '题目数量',
  `studentnum` int(10) NOT NULL DEFAULT '0' COMMENT '学生数量',
  `isseen` tinyint(2) NOT NULL DEFAULT '0' COMMENT '是否显示:1显示,0隐藏',
  `icveid` varchar(50) DEFAULT '' COMMENT 'icve原始id号',
  PRIMARY KEY (`id`),
  KEY `specialty_index_parentid` (`parentid`),
  KEY `specialty_index_isseen` (`isseen`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='专业';

-- ----------------------------
-- Records of specialty
-- ----------------------------

-- ----------------------------
-- Table structure for specialty_leader
-- ----------------------------
DROP TABLE IF EXISTS `specialty_leader`;
CREATE TABLE `specialty_leader` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `specialid` int(10) NOT NULL DEFAULT '0' COMMENT '专业id',
  `specialtype` int(10) NOT NULL DEFAULT '0' COMMENT '类型:1院,2系,3专业',
  `userid` int(10) NOT NULL DEFAULT '0' COMMENT '用户id',
  `leadertype` tinyint(2) NOT NULL DEFAULT '1' COMMENT '类型:1负责人,2普通成员',
  `username` varchar(50) DEFAULT '' COMMENT '用户名',
  `stdnumber` varchar(50) DEFAULT '' COMMENT '工号',
  `realname` varchar(100) DEFAULT '' COMMENT '姓名',
  `logo` varchar(500) DEFAULT '' COMMENT '头像',
  PRIMARY KEY (`id`),
  KEY `specialty_leader_index_specialid` (`specialid`),
  KEY `specialty_leader_index_userid` (`userid`),
  KEY `specialty_leader_index_leadertype` (`leadertype`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='专业团队成员';

-- ----------------------------
-- Records of specialty_leader
-- ----------------------------

-- ----------------------------
-- Table structure for user
-- ----------------------------
DROP TABLE IF EXISTS `user`;
CREATE TABLE `user` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `roleid` int(11) NOT NULL DEFAULT '0' COMMENT '用户角色',
  `groupid` int(10) NOT NULL DEFAULT '0' COMMENT '用户组',
  `username` varchar(50) NOT NULL DEFAULT '' COMMENT '用户名',
  `stdnumber` varchar(50) DEFAULT '' COMMENT '学号',
  `password` varchar(100) NOT NULL DEFAULT '' COMMENT '密码',
  `salt` varchar(100) NOT NULL DEFAULT '' COMMENT '加密随机数',
  `male` tinyint(2) NOT NULL DEFAULT '0' COMMENT '性别:1男,2女,0保密',
  `realname` varchar(100) NOT NULL DEFAULT '' COMMENT '姓名',
  `nicename` varchar(100) NOT NULL DEFAULT '' COMMENT '昵称',
  `regtime` datetime DEFAULT NULL COMMENT '注册时间',
  `regip` varchar(100) NOT NULL DEFAULT '' COMMENT '注册ip',
  `logintime` datetime DEFAULT NULL COMMENT '登录时间',
  `loginip` varchar(100) NOT NULL DEFAULT '' COMMENT '登录ip',
  `logo` varchar(500) NOT NULL DEFAULT '' COMMENT '头像',
  `islocked` tinyint(2) NOT NULL DEFAULT '0' COMMENT '是否被锁定:1是0否',
  `email` varchar(100) NOT NULL DEFAULT '' COMMENT '电子邮箱',
  `cellphone` varchar(50) NOT NULL DEFAULT '' COMMENT '手机号',
  `isactive` tinyint(2) NOT NULL DEFAULT '0' COMMENT '是否已激活:1是0否',
  `missing` int(10) NOT NULL DEFAULT '0' COMMENT '是否被删除:1是0否',
  `token` varchar(100) NOT NULL DEFAULT '' COMMENT '激活令牌',
  `specialid` int(10) DEFAULT '0' COMMENT '专业id',
  `xzclassid` int(10) DEFAULT '0' COMMENT '行政班级id',
  `specialpath` varchar(200) DEFAULT '' COMMENT '专业节点路径',
  `grade` int(10) DEFAULT '0' COMMENT '年级',
  `leadspecialids` varchar(500) DEFAULT ',0,' COMMENT '负责的专业',
  `leadcourseidszyk` varchar(500) DEFAULT ',0,' COMMENT '负责的课程',
  `isarchived` int(10) NOT NULL DEFAULT '0' COMMENT '是否已存档,大于0表示年份',
  `wxopenid` varchar(100) DEFAULT '' COMMENT '微信OpenId',
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_index_username` (`username`),
  UNIQUE KEY `user_index_stdnumber` (`stdnumber`),
  KEY `user_index_specialid` (`specialid`),
  KEY `user_index_xzclassid` (`xzclassid`),
  KEY `user_index_roleid` (`roleid`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='用户信息';

-- ----------------------------
-- Records of user
-- ----------------------------
INSERT INTO `user` VALUES ('1', '1', '1', 'admin', 'admin', 'f0a5f849648352755fac4fc2907b47eb', '15faa097c65fb4ad5cb9df3d6675595f', '1', '管理员', '管理员', '2018-02-01 16:36:28', '192.168.1.150', '2018-04-25 10:05:17', '192.168.1.150', '/userfiles/face/201804/04/9519b1b317a7ded5b60161eeb01d2fef_s.jpg', '0', '', '', '1', '0', '', '0', '0', '', '0', ',0,', ',0,', '0', '');
