<?php
namespace app\extensions\pager;

class Pager
{
//类开始
	public $allsize	= 0;		//总记录条数
	public $pagesize= 0;		//每页记录数
	public $allpage	= 0;		//总页数
	public $curpage	= 0;		//当前页数
	public $pagelink= 0;		//分页链接
	
	public function init(){
		//
	}
	
	//计算分页信息
	public function get_pagerinfo(){
		if(empty($this->curpage) || is_numeric($this->curpage)==false || $this->curpage<0){
			$this->curpage = 1;
		}
		$this->get_allpage();
		$this->get_curpage();
	}
	
	//总页数
	public function get_allpage(){
		if( $this->allsize ){
			if( $this->allsize < $this->pagesize ){ $this->allpage = 1; }
			if( $this->allsize % $this->pagesize ){
				$this->allpage = (int)($this->allsize / $this->pagesize) + 1;
			}else{
				$this->allpage = $this->allsize / $this->pagesize;
			}
		}else{
			$this->allpage = 0;
		}
	}
	
	//当前页数
	public function get_curpage(){
		if($this->allsize>0){
			if($this->allpage>0 && $this->curpage>$this->allpage){
				$this->curpage = $this->allpage;
			}
		}else{
			$this->curpage = 1;
		}
	}
			
//类结束
}
?>