<?php
namespace app\extensions\upload;

class Yikong_imagetransfer
{
//类开始
	public $originimage			= "";	//源图片文件地址
	public $imageext			= "";	//源图片格式
	public $thumbimage			= "";	//缩略图文件存放地址
	public $thumb_maxwidth		= 100;	//缩略图最大宽度
	public $thumb_maxheight		= 100;	//缩略图最大高度
	public $watermark_text		= "";	//水印文字内容
	public $watermark_minwidth	= 300;	//源图片最小宽度：大于此值时加水印
	public $watermark_minheight	= 200;	//源图片最小高度：大于此值时加水印
	public $watermark_fontfile	= "";	//字体文件
	public $watermark_fontsize	= 14;	//字体大小
	public $watermark_logo		= "";	//水印LOGO地址
	public $watermark_transparent = 80;	//水印LOGO不透明度
	private $origin_width		= 0;	//源图片宽度
	private $origin_height		= 0;	//源图片高度
	private $tmp_originimage	= "";	//临时图片(源图片)
	private $tmp_thumbimage		= "";	//临时图片(缩略图)
	private $tmp_waterimage		= "";	//临时图片(水印LOGO)
	
	//生成缩略图
	public function gen_thumbimage(){
		if($this->originimage=="" || $this->thumbimage==""){
			return 0;
		}
		$this->get_oriwidthheight();
		if($this->origin_width < $this->thumb_maxwidth && $this->origin_height < $this->thumb_maxheight){
			$this->thumb_maxwidth = $this->origin_width;
			$this->thumb_maxheight = $this->origin_height;
		}else{
			if ($this->origin_width < $this->origin_height) {
				$this->thumb_maxwidth = ($this->thumb_maxheight / $this->origin_height) * $this->origin_width;
			} else {
				$this->thumb_maxheight = ($this->thumb_maxwidth / $this->origin_width) * $this->origin_height;
			}
		}
		$this->get_imagetype();
		$this->gen_tmpimage_origin();
		$this->gen_tmpimage_thumb();
		if($this->tmp_originimage=="" || $this->tmp_thumbimage==""){
			return -1;
		}
		imagecopyresampled($this->tmp_thumbimage, $this->tmp_originimage, 0, 0, 0, 0, $this->thumb_maxwidth, $this->thumb_maxheight, $this->origin_width, $this->origin_height);
		switch ($this->imageext) {
			case "gif":
				imagegif($this->tmp_thumbimage, $this->thumbimage);
				return 1;
				break;
			case "jpg":
				imagejpeg($this->tmp_thumbimage, $this->thumbimage, 100);
				return 2;
				break;
			case "png":
				imagepng($this->tmp_thumbimage, $this->thumbimage);
				return 3;
				break;
			default:
				imagejpeg($this->tmp_thumbimage, $this->thumbimage, 100);
				return 2;
				break;
		}
	}
	
	//添加文字水印
	public function add_watermark1(){
		if($this->originimage=="" || $this->watermark_text=="" || $this->watermark_fontfile==""){
			return 0;
		}
		$this->get_oriwidthheight();
		if($this->origin_width < $this->watermark_minwidth || $this->origin_height < $this->watermark_minheight){
			return 0;
		}
		$this->get_imagetype();
		$this->gen_tmpimage_origin();
		if($this->tmp_originimage==""){
			return -1;
		}
		$textcolor	= imagecolorallocate($this->tmp_originimage, 255, 0, 0);
		$angle		= 0;
		$px     	= $this->origin_width - 100;
		$py     	= $this->origin_height - 10;
		imagettftext($this->tmp_originimage, $this->watermark_fontsize, $angle, $px, $py, $textcolor, $this->watermark_fontfile, $this->watermark_text);
		switch ($this->imageext) {
			case "gif":
				imagegif($this->tmp_originimage, $this->originimage);
				return 1;
				break;
			case "jpg":
				imagejpeg($this->tmp_originimage, $this->originimage, 100);
				return 2;
				break;
			case "png":
				imagepng($this->tmp_originimage, $this->originimage);
				return 3;
				break;
			default:
				imagejpeg($this->tmp_originimage, $this->originimage, 100);
				return 2;
				break;
		}
	}
	
	//添加LOGO水印
	public function add_watermark2(){
		if($this->originimage=="" || $this->watermark_logo==""){
			return 0;
		}
		$this->get_oriwidthheight();
		if($this->origin_width < $this->watermark_minwidth || $this->origin_height < $this->watermark_minheight){
			return 0;
		}
		$this->get_imagetype();
		$this->gen_tmpimage_origin();
		$this->gen_tmpimage_waterlogo();
		if($this->tmp_originimage=="" || $this->tmp_waterimage==""){
			return -1;
		}
		list($logo_width, $logo_height) = getimagesize($this->watermark_logo);
		$px		= $this->origin_width - $logo_width - 5;
		$py     = $this->origin_height - $logo_height - 5;
		imagecopymerge($this->tmp_originimage, $this->tmp_waterimage, $px, $py, 0, 0, $logo_width, $logo_height, $this->watermark_transparent);
		switch ($this->imageext) {
			case "gif":
				imagegif($this->tmp_originimage, $this->originimage);
				return 1;
				break;
			case "jpg":
				imagejpeg($this->tmp_originimage, $this->originimage, 100);
				return 2;
				break;
			case "png":
				imagepng($this->tmp_originimage, $this->originimage);
				return 3;
				break;
			default:
				imagejpeg($this->tmp_originimage, $this->originimage, 100);
				return 2;
				break;
		}
	}
	
	//获取图片尺寸
	private function get_oriwidthheight(){
		list($this->origin_width, $this->origin_height) = getimagesize($this->originimage);
		return 1;
	}
	
	//检测图片格式
	private function get_imagetype(){
		$patharr = explode(".", $this->originimage);
		$this->imageext = strtolower(end($patharr));
	}
	
	//创建临时图片(源图片)
	private function gen_tmpimage_origin(){
		$patharr = explode(".", $this->originimage);
		$ext = strtolower(end($patharr));
		switch ($ext) {
		case "gif":
			$this->tmp_originimage = imagecreatefromgif($this->originimage);
			$bgcolor = imagecolorallocate($this->tmp_originimage,0,0,0);   
			$bgcolortrans = imagecolortransparent($this->tmp_originimage,$bgcolor);
			break;
		case "jpg":
			$this->tmp_originimage = imagecreatefromjpeg($this->originimage);
			break;
		case "png":
			$this->tmp_originimage = imagecreatefrompng($this->originimage);
			imagesavealpha($this->tmp_originimage, true);
			break;
		default:
			$this->tmp_originimage = imagecreatefromjpeg($this->originimage);
			break;
		}
	}
	
	//创建临时图片(缩略图)
	private function gen_tmpimage_thumb(){
		$patharr = explode(".", $this->originimage);
		$ext = strtolower(end($patharr));
		switch ($ext) {
		case "gif":
			$this->tmp_thumbimage = imagecreatetruecolor($this->thumb_maxwidth, $this->thumb_maxheight);
			$bgcolor = imagecolorallocate($this->tmp_thumbimage,255,255,255);
			imagefill($this->tmp_thumbimage,0,0,$bgcolor);
			break;
		case "jpg":
			$this->tmp_thumbimage = imagecreatetruecolor($this->thumb_maxwidth, $this->thumb_maxheight);
			break;
		case "png":
			$this->tmp_thumbimage = imagecreatetruecolor($this->thumb_maxwidth, $this->thumb_maxheight);
			$bgcolor = imagecolorallocate($this->tmp_thumbimage,255,255,255);
			imagefill($this->tmp_thumbimage,0,0,$bgcolor);
			imagealphablending($this->tmp_thumbimage, false);
			imagesavealpha($this->tmp_thumbimage, true);
			break;
		default:
			$this->tmp_thumbimage = imagecreatetruecolor($this->thumb_maxwidth, $this->thumb_maxheight);
			break;
		}
	}
		
	//创建临时图片(LOGO水印)
	private function gen_tmpimage_waterlogo(){
		$patharr = explode(".", $this->watermark_logo);
		$ext = strtolower(end($patharr));
		switch ($ext) {
		case "gif":
			$this->tmp_waterimage = imagecreatefromgif($this->watermark_logo);
			$bgcolor = imagecolorallocate($this->tmp_waterimage,0,0,0);   
			$bgcolortrans = imagecolortransparent($this->tmp_waterimage,$bgcolor);
			break;
		case "jpg":
			$this->tmp_waterimage = imagecreatefromjpeg($this->watermark_logo);
			break;
		case "png":
			$this->tmp_waterimage = imagecreatefrompng($this->watermark_logo);
			imagesavealpha($this->tmp_waterimage, true);
			break;
		default:
			$this->tmp_waterimage = imagecreatefromjpeg($this->watermark_logo);
			break;
		}
	}
	
	//释放资源
	public function __destruct(){
		if(is_object($this->tmp_originimage)==true){
			imagedestroy($this->tmp_originimage);
		}
		if(is_object($this->tmp_thumbimage)==true){
			imagedestroy($this->tmp_thumbimage);
		}
		if(is_object($this->tmp_waterimage)==true){
			imagedestroy($this->tmp_waterimage);
		}
	}
//类结束
}
?>