<?php
namespace app\modules\doexam\controllers;

use Yii;
use yii\web\Controller;
use app\models\Config;
use app\models\Doexam;
use app\models\Doexam_answer;
use app\models\Exam;
use app\models\Exam_option;
use app\models\Exam_stem;
use app\models\Resour_course;
use app\models\Specialty;
use app\components\WarningHelper;
use app\components\AccessControl;
use app\components\UserHelper;
use app\components\SpecialtyHelper;
use app\extensions\pager\Pager;

class DefaultController extends Controller
{
	
	private $userobj; //用户登录信息
	private $request; //Yii::$app->request对象
	private $pagesize = 20; //分页数量
	
    public function init(){
		$this->userobj = AccessControl::isLogin();
		$this->request = Yii::$app->request;
	}
	
	public function beforeAction($action) {
		$this->view->params["navicode"] = "doexam";
		$this->view->params["navicode_two"] = "doexam_manage";
		$this->view->params["meta_title"] = "我的考试 - ";
		return true;
	}
	
	//考试管理
	public function actionIndex(){
		$se_title = $this->request->post("se_title");
		$se_title = htmlspecialchars(strip_tags(trim($se_title)));

		$se_specialid = $this->request->post("se_specialid");
		$se_specialid = htmlspecialchars(strip_tags(trim($se_specialid)));

		$se_courseid = $this->request->post("se_courseid");
		$se_courseid = htmlspecialchars(strip_tags(trim($se_courseid)));

		$se_isdone = $this->request->post("se_isdone");
		$se_isdone = htmlspecialchars(strip_tags(trim($se_isdone)));
		
		$listmore = $this->request->post("listmore");
		$listmore = htmlspecialchars(strip_tags(trim($listmore)));

		$curpage = $this->request->post("curpage");
		$curpage = htmlspecialchars(strip_tags(trim($curpage)));
		if(empty($curpage) || !is_numeric($curpage)){
			$curpage = 1;
		}

		$condition = "ispublish=1 and find_in_set('". $this->userobj->xzclassid ."',forclass)";
		if(!empty($se_title)){
			$condition .= " and title like '%". $se_title ."%'";
		}
		if(!empty($se_specialid) && is_numeric($se_specialid)){
			$condition .= " and find_in_set('". $se_specialid ."',specialpath)";
		}
		if(!empty($se_courseid) && is_numeric($se_courseid)){
			$condition .= " and courseid=". $se_courseid;
		}
		if($se_isdone==1){
			$condition .= " and not id in (select examid from doexam where userid=". $this->userobj->id ." and isdone in (2,3))";
		}elseif($se_isdone==2){
			$condition .= " and id in (select examid from doexam where userid=". $this->userobj->id ." and isdone in (2))";
		}elseif($se_isdone==3){
			$condition .= " and id in (select examid from doexam where userid=". $this->userobj->id ." and isdone in (3))";
		}
		$allsize = Exam::find()->where($condition)->count();
		$pager = new Pager();
		$pager->allsize		= $allsize;  //总记录条数
		$pager->pagesize	= $this->pagesize;  //每页数量
		$pager->curpage	= $curpage;	  //当前页数
		$pager->get_pagerinfo();
		if($listmore=="yes"){
			$exams = Exam::find()->select("id,userid,specialid,courseid,title,points,begintime,endtime,ispublish,specialpath,questway")->where($condition)->orderby("begintime desc")->offset(($pager->curpage-1)*$this->pagesize)->limit($this->pagesize)->all();
			foreach ($exams as $oneexam) {
				$oneexam->doexam = Doexam::find()->where("examid=". $oneexam->id ." and userid=". $this->userobj->id)->one();
			}
			return $this->renderPartial("pagelist", ["exams"=>$exams]);
		}else{
			$colleges = SpecialtyHelper::getCollegelistall();
			$courses = [];
			if(!empty($se_specialid) && is_numeric($se_specialid)){
				$courses = Resour_course::find()->select("id,name,spelling")->where("specialid=". $se_specialid)->orderby("spelling asc")->all();
			}
			return $this->render("index", ["pager"=>$pager, "colleges"=>$colleges, "courses"=>$courses, "search"=>["se_title"=>$se_title, "se_specialid"=>$se_specialid, "se_courseid"=>$se_courseid, "se_isdone"=>$se_isdone]]);
		}
	}
		
}
?>