<?php
namespace app\modules\doexam\controllers;

use Yii;
use yii\web\Controller;
use app\models\Config;
use app\models\Doexam;
use app\models\Doexam_answer;
use app\models\Exam;
use app\models\Exam_stem;
use app\models\Exam_option;
use app\models\Questi_stem;
use app\models\Questi_option;
use app\models\Specialty;
use app\models\Resour_course;
use app\components\AccessControl;
use app\components\WarningHelper;
use app\components\SafetyHelper;

class QuestionController extends Controller
{
	
	private $userobj; //考试登录信息
	private $request; //Yii::$app->request对象
	
    public function init(){
		$this->userobj = AccessControl::isLogin();
		$this->request = Yii::$app->request;
	}
	
	public function beforeAction($action) {
		$this->view->params["navicode"] = "doexam";
		$this->view->params["navicode_two"] = "doexam_manage";
		$this->view->params["meta_title"] = "我的考试 - ";
		return true;
	}
	
	//试题管理
	public function actionIndex(){
		$examid = $this->request->get("id");
		$examid = htmlspecialchars(strip_tags(trim($examid)));
		if(empty($examid) || !is_numeric($examid)){
			WarningHelper::warning("参数错误", "/doexam/default/index"); die();
		}
		$exam = Exam::find()->where("id=". $examid)->one();
		if(empty($exam)){
			WarningHelper::warning("考试不存在", "/doexam/default/index"); die();
		}
		if(stripos($exam->forclass, ",". $this->userobj->xzclassid .",")===false){
			WarningHelper::warning("无权访问", "/doexam/default/index"); die();
		}
		if($exam->ispublish!=1){
			WarningHelper::warning("考试未发布", "/doexam/default/index"); die();
		}
		if($exam->begintime>date("Y-m-d H:i:s")){
			WarningHelper::warning("考试未开始", "/doexam/default/index"); die();
		}
		if($exam->endtime<date('Y-m-d H:i:s',strtotime('-10 minute'))){ //延长10分钟交卷时间
			WarningHelper::warning("考试已结束", "/doexam/default/index"); die();
		}
		$exam->course = Resour_course::find()->where("id=". $exam->courseid)->one();
		$exam->doexam = Doexam::find()->where("examid=". $exam->id ." and userid=". $this->userobj->id)->one();
		if(!empty($exam->doexam)){
			if($exam->doexam->isdone==2 || $exam->doexam->isdone==3){
				WarningHelper::warning("您已经完成了考试", "/doexam/default/index"); die();
			}
		}
		$exstems = Exam_stem::find()->where("examid=". $exam->id)->orderby("typechild asc,id asc")->all();
		foreach ($exstems as $onestem) {
			$onestem->options = Exam_option::find()->where("examid=". $exam->id ." and stemid=". $onestem->id)->orderby("code asc")->all();
			$onestem->doanswer = Doexam_answer::find()->where("examid=". $exam->id ." and stemid=". $onestem->id ." and userid=". $this->userobj->id)->one();
			if(empty($onestem->doanswer)){
				$onestem->doanswer = new Doexam_answer();
			}
		}
		return $this->render("index", ["exam"=>$exam, "exstems"=>$exstems]);
	}

	//提交试卷/保存做题进度
	function actionFinishedok(){
		$examid = $this->request->post("examid");
		$examid = htmlspecialchars(strip_tags(trim($examid)));
		$savetype = $this->request->post("savetype");
		$savetype = htmlspecialchars(strip_tags(trim($savetype)));
		$exstemidarr = $this->request->post("exstemid");
		$exstemtypearr = $this->request->post("exstemtype");
		if(empty($examid) || is_numeric($examid)==false){
			echo json_encode(["code"=>"failed", "msg"=>"参数错误"]);
			die();
		}
		if($savetype==2){
			//do nothing
		}else{
			$savetype = 1;
		}
		$exam = Exam::find()->where("id=". $examid)->one();
		if(empty($exam)){
			echo json_encode(["code"=>"failed", "msg"=>"考试不存在"]);
			die();
		}
		if($exam->begintime>date("Y-m-d H:i:s")){
			echo json_encode(["code"=>"failed", "msg"=>"考试未开始"]);
			die();
		}
		if($exam->endtime<date('Y-m-d H:i:s',strtotime('-10 minute'))){ //延长10分钟交卷时间
			echo json_encode(["code"=>"failed", "msg"=>"考试已结束"]);
			die();
		}
		$doexam = Doexam::find()->where("examid=". $exam->id ." and userid=". $this->userobj->id)->one();
		if(empty($doexam)){
			$doexam = new Doexam();
			$doexam->userid = $this->userobj->id;
			$doexam->examid = $exam->id;
			$doexam->specialid = $exam->specialid;
			$doexam->courseid = $exam->courseid;
			$doexam->username = $this->userobj->username;
			$doexam->stdnumber = $this->userobj->stdnumber;
			$doexam->realname = $this->userobj->realname;
			$doexam->xzclassid = $this->userobj->xzclassid;
		}
		$doexam->isdone = $savetype;
		$doexam->cometime = date("Y-m-d H:i:s");
		$doexam->save();
		$totalpoints = 0; //总得分
		foreach ($exstemidarr as $onekey => $onestemid) {
			$typeid = $exstemtypearr[$onekey];
			$answers = $this->request->post("stem_". $onestemid ."_answer");
			if(empty($answers)){continue;}
			$onestem = Exam_stem::find()->where("id=". $onestemid)->one();
			if(empty($onestem)){continue;}
			$doanswer = Doexam_answer::find()->where("userid=". $this->userobj->id ." and examid=". $examid ." and stemid=". $onestemid)->one();
			if(empty($doanswer)){
				$doanswer = new Doexam_answer();
				$doanswer->userid = $this->userobj->id;
				$doanswer->examid = $examid;
				$doanswer->stemid = $onestem->id;
				$doanswer->qbank_stemid = $onestem->qbank_stemid;
			}
			$stemanswer = $onestem->answer;
			if($typeid==1){ //单选
				$doanswer->answer = $answers;
			}elseif($typeid==2){ //多选
				$doanswer->answer = implode(",", $answers);
			}elseif($typeid==3){ //判断
				$doanswer->answer = $answers;
			}elseif($typeid==4){ //填空
				$doanswer->answer = implode("#{#--#}#", $answers);
				$stemoptions = Exam_option::find()->where("examid=". $exam->id ." and stemid=". $onestem->id ." order by code asc")->all();
				$stemanswer = "";
				foreach ($stemoptions as $onestoption) {
					if(empty($stemanswer)){
						$stemanswer = $onestoption->content;
					}else{
						$stemanswer .= "#{#--#}#". $onestoption->content;
					}
				}
			}elseif($typeid==5){ //问答
				$doanswer->answer = $answers;
			}
			if(!empty($doanswer->answer) && $doanswer->answer==$stemanswer){
				$doanswer->points = $onestem->points;
				$totalpoints += $onestem->points;
			}
			$doanswer->save();
			$doexam->points = $totalpoints;
			$doexam->save();
		}
		echo json_encode(["code"=>"success","msg"=>"成功"]);
	}
		
}
?>