<?php
namespace app\modules\doexam\controllers;

use Yii;
use yii\web\Controller;
use app\models\Config;
use app\models\Doexam;
use app\models\Doexam_answer;
use app\models\Exam;
use app\models\Exam_option;
use app\models\Exam_stem;
use app\models\Resour_course;
use app\models\Specialty;
use app\models\User;
use app\models\Schoolclass;
use app\components\WarningHelper;
use app\components\AccessControl;
use app\components\UserHelper;
use app\components\SpecialtyHelper;
use app\extensions\pager\Pager;

class ResultController extends Controller
{
	
	private $userobj; //用户登录信息
	private $request; //Yii::$app->request对象
	private $pagesize = 20; //分页数量
	
    public function init(){
		$this->userobj = AccessControl::isLogin();
		$this->request = Yii::$app->request;
	}
	
	public function beforeAction($action) {
		$this->view->params["navicode"] = "doexam";
		$this->view->params["navicode_two"] = "doexam_manage";
		$this->view->params["meta_title"] = "考试管理 - ";
		return true;
	}
	
	//查看试卷结果
	public function actionIndex(){
		$doexid = $this->request->get("id");
		$doexid = htmlspecialchars(strip_tags(trim($doexid)));

		if(empty($doexid) || !is_numeric($doexid)){
			echo "参数错误"; die();
		}

		$doexam = Doexam::find()->where("id=". $doexid)->one();
		if(empty($doexam)){
			echo "学生试卷不存在"; die();
		}

		if($doexam->userid!=$this->userobj->id){
			echo "无权访问"; die();
		}

		$exam = Exam::find()->where("id=". $doexam->examid)->one();
		if(empty($exam)){
			echo "考试不存在"; die();
		}

		$exstems = Exam_stem::find()->where("examid=". $exam->id)->orderby("typechild asc,id asc")->all();
		foreach ($exstems as $onestem) {
			$onestem->options = Exam_option::find()->where("examid=". $exam->id ." and stemid=". $onestem->id)->orderby("code asc")->all();
			$onestem->doanswer = Doexam_answer::find()->where("examid=". $exam->id ." and stemid=". $onestem->id ." and userid=". $doexam->userid)->one();
			if(empty($onestem->doanswer)){
				$onestem->doanswer = new Doexam_answer();
			}
		}
		return $this->renderPartial("index", ["doexam"=>$doexam, "exam"=>$exam, "exstems"=>$exstems]);
	}
		
}
?>