<?php
namespace app\modules\glconfig\controllers;

use Yii;
use yii\web\Controller;
use app\models\Config;
use app\components\AccessControl;
use app\components\StringHelper;

class DefaultController extends Controller
{
	
	private $config; //系统设置信息
	private $userobj; //用户登录信息
	private $request; //Yii::$app->request对象
	
    public function init(){
		$this->config = Config::find()->where("id=1")->one();
		$this->userobj = AccessControl::isLogin();
		$this->request = Yii::$app->request;
	}
	
	public function beforeAction($action) {
		$this->view->params["navicode"] = "glconfig";
		$this->view->params["navicode_two"] = "glconfig_basic";
		$this->view->params["meta_title"] = "系统设置 - ";
		return true;
	}
	
	//基本设置
	public function actionIndex(){
		$regiforbid = "";
		if(file_exists(WEBROOT ."/upfiles/config/regiforbid.txt")){
			$regiforbid = file_get_contents(WEBROOT ."/upfiles/config/regiforbid.txt");
		}
		return $this->render("index", ["config"=>$this->config, "regiforbid"=>$regiforbid]);
	}

	//基本设置，保存
	public function actionBasicok(){
		$title = $this->request->post("title");
		$title = htmlspecialchars(strip_tags(trim($title)));
		$domain = $this->request->post("domain");
		$domain = htmlspecialchars(strip_tags(trim($domain)));
		$icpno = $this->request->post("icpno");
		$icpno = htmlspecialchars(strip_tags(trim($icpno)));
		$copyright = $this->request->post("copyright");
		$copyright = htmlspecialchars(strip_tags(trim($copyright)));
		$isregist = $this->request->post("isregist");
		$isregist = htmlspecialchars(strip_tags(trim($isregist)));
		$regiforbid = $this->request->post("regiforbid");
		$regiforbid = htmlspecialchars(strip_tags(trim($regiforbid)));
		if(empty($title)){
			echo json_encode(array("code"=>"failed", "msg"=>"网站名称不能为空"));
			die();
		}
		if(empty($domain)){
			echo json_encode(array("code"=>"failed", "msg"=>"网站域名不能为空"));
			die();
		}
		if(empty($copyright)){$copyright = "";}
		$this->config->name = $title;
		$this->config->domain = $domain;
		$this->config->icpno = $icpno;
		$this->config->isregist = $isregist;
		$this->config->copyright = $copyright;
		$this->config->save();
		file_put_contents(WEBROOT ."/upfiles/config/regiforbid.txt", $regiforbid);
		echo json_encode(array("code"=>"success", "msg"=>"成功"));
	}
	
}
?>