<?php
namespace app\modules\glconfig\controllers;

use Yii;
use yii\web\Controller;
use app\models\Config;
use app\components\AccessControl;

class FaviconController extends Controller
{
	
	private $userobj; //用户登录信息
	private $request; //Yii::$app->request对象
	
    public function init(){
		$this->userobj = AccessControl::isLogin();
		$this->request = Yii::$app->request;
	}
	
	public function beforeAction($action) {
		$this->view->params["navicode"] = "glconfig";
		$this->view->params["navicode_two"] = "glconfig_favicon";
		$this->view->params["meta_title"] = "系统设置 - ";
		return true;
	}
	
	//收藏栏图标
	public function actionIndex(){
		return $this->render("index");
	}
	
}
?>