<?php
namespace app\modules\glconfig\controllers;

use Yii;
use yii\web\Controller;
use app\models\Config;
use app\components\AccessControl;

class LogoController extends Controller
{
	
	private $config; //系统设置信息
	private $userobj; //用户登录信息
	private $request; //Yii::$app->request对象
	
    public function init(){
		$this->config = Config::find()->where("id=1")->one();
		$this->userobj = AccessControl::isLogin();
		$this->request = Yii::$app->request;
	}
	
	public function beforeAction($action) {
		$this->view->params["navicode"] = "glconfig";
		$this->view->params["navicode_two"] = "glconfig_logo";
		$this->view->params["meta_title"] = "系统设置 - ";
		return true;
	}
	
	//网站图标
	public function actionIndex(){
		return $this->render("index", ["config"=>$this->config]);
	}
	
}
?>