<?php
namespace app\modules\glconfig\controllers;

use Yii;
use yii\web\Controller;
use app\models\Config;
use app\models\Questi_type;
use app\components\WarningHelper;
use app\components\AccessControl;

class QutypeController extends Controller
{
	
	private $userobj; //用户登录信息
	private $request; //Yii::$app->request对象
	
    public function init(){
		$this->userobj = AccessControl::isLogin();
		$this->request = Yii::$app->request;
	}
	
	public function beforeAction($action) {
		$this->view->params["navicode"] = "glconfig";
		$this->view->params["navicode_two"] = "glconfig_qutype";
		$this->view->params["meta_title"] = "题目类型";
		return true;
	}
		
	//题目类型
	public function actionIndex(){
		$chapters = Questi_type::find()->where("parentid=0")->orderby("sortid asc")->all();
		foreach ($chapters as $onechapter) {
			$onechapter->children = Questi_type::find()->where("parentid=". $onechapter->id)->orderby("sortid asc")->all();
		}
		return $this->render("index", ["chapters"=>$chapters]);
	}
	
}
?>